/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.threading;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.threading.ThreadHeartbeatCounter;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SingleThreadInvoker
implements AsyncInvoker {
    private static final ILogger log = Log.getLogger(SingleThreadInvoker.class);
    private String name;
    private BlockingQueue<Runnable> queue;
    private final Worker worker;
    private Thread thread = null;

    public SingleThreadInvoker() {
        this(null);
    }

    public SingleThreadInvoker(String name) {
        this(name, Integer.MAX_VALUE);
    }

    public SingleThreadInvoker(String name, int queueSize) {
        this.name = name;
        this.queue = new LinkedBlockingQueue<Runnable>(queueSize);
        this.worker = new Worker(this);
        this.startThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Runnable target) {
        try {
            Worker worker = this.worker;
            synchronized (worker) {
                if (!this.worker.active) {
                    throw new IllegalStateException("Invoker is not active (has been stopped)");
                }
                if (!this.worker.isActive()) {
                    this.startThread();
                }
                if (!this.queue.offer(target, 0L, TimeUnit.MILLISECONDS)) {
                    log.warn("Invoker is overloaded!");
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Worker worker = this.worker;
        synchronized (worker) {
            this.worker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Worker worker = this.worker;
        synchronized (worker) {
            this.worker.stop();
        }
    }

    Thread thread() {
        return this.thread;
    }

    private void startThread() {
        String threadName = "com.genesyslab.PCT.invoker";
        if (this.name != null) {
            threadName = threadName + "." + this.name;
        }
        this.thread = new Thread((Runnable)this.worker, threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public String toString() {
        return "SingleThreadInvoker[" + this.name + "]: active=" + this.worker.active + ", thread=" + this.worker.isActive();
    }

    private static class Worker
    implements Runnable {
        private volatile boolean active = true;
        private volatile boolean released = false;
        private Thread thread;
        private ReferenceQueue<AsyncInvoker> invokerRefQueue = new ReferenceQueue();
        private WeakReference<AsyncInvoker> invokerRef;
        private String name;
        private BlockingQueue<Runnable> queue;
        private static final Runnable releaseMarker = new Runnable(){

            public void run() {
            }
        };

        private Worker(SingleThreadInvoker invoker) {
            this.invokerRef = new WeakReference<AsyncInvoker>(invoker, this.invokerRefQueue);
            this.name = invoker.name;
            this.queue = invoker.queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            String threadId = "SingleThreadInvoker" + (this.name == null ? "" : "('" + this.name + "')");
            if (log.isInfo()) {
                log.info(threadId + " has started");
            }
            this.thread = Thread.currentThread();
            this.released = false;
            ThreadHeartbeatCounter monitor = null;
            try {
                monitor = ThreadHeartbeatCounter.createThreadHeartbeatCounter(threadId, 1);
                monitor.initialize();
            }
            catch (Exception e1) {
                log.error("Exception while creating thread monitor", e1);
            }
            try {
                while (this.active) {
                    if (monitor != null) {
                        monitor.alive();
                    }
                    try {
                        block17: {
                            Runnable task;
                            block16: {
                                task = this.queue.poll(500L, TimeUnit.MILLISECONDS);
                                if (monitor != null) {
                                    monitor.alive();
                                }
                                if (task != null) break block16;
                                if (this.invokerRefQueue.poll() != null) {
                                    this.active = false;
                                    this.invokerRef.clear();
                                    break block17;
                                } else if (this.invokerRef.get() == null) {
                                    this.active = false;
                                }
                                break block17;
                            }
                            task.run();
                        }
                        if (!this.released || !this.queue.isEmpty()) continue;
                        return;
                    }
                    catch (InterruptedException e) {
                        if (this.active) continue;
                        log.debug("Stopping invoker");
                    }
                    catch (Exception e) {
                        log.warn("Unhandled exception in AsyncInvoker", e);
                    }
                }
                return;
            }
            finally {
                if (monitor != null) {
                    monitor.unregister();
                }
            }
        }

        public void release() {
            this.released = true;
            this.queue.offer(releaseMarker);
        }

        public void stop() {
            this.active = false;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }

        public boolean isActive() {
            return this.active && (this.thread == null || this.thread.isAlive());
        }
    }
}

