/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.Pair;
import com.genesyslab.platform.commons.collections.UTFValue;

public class KeyValuePair
extends Pair {
    public KeyValuePair(String key) {
        this.setKey(key);
    }

    public KeyValuePair(String key, byte[] value) {
        this.setKey(key);
        this.setValue(value);
    }

    public KeyValuePair(String key, int value) {
        this.setKey(key);
        this.value = new Integer(value);
    }

    public KeyValuePair(String key, String value) {
        this(key, value, false);
    }

    public KeyValuePair(String key, String value, boolean isWideString) {
        this.setKey(key);
        if (isWideString) {
            this.value = new UTFValue(value);
        } else {
            this.setValue(value);
        }
    }

    public KeyValuePair(String key, KeyValueCollection value) {
        this.setKey(key);
        this.setValue(value);
    }

    public KeyValueCollection getTKVValue() {
        if (this.value instanceof KeyValueCollection) {
            return (KeyValueCollection)this.value;
        }
        return null;
    }

    public void setTKVValue(KeyValueCollection val) {
        this.setValue(val);
    }

    private void setKey(String key) {
        if (key == null) {
            throw new NullPointerException("null keys are not supported");
        }
        this.key = key;
    }
}

