/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.UTFValue;
import com.genesyslab.platform.commons.collections.ValueType;
import java.io.Serializable;

public abstract class Pair
implements Serializable,
Cloneable {
    protected Object key;
    protected Object value;

    public String getStringKey() {
        if (this.key instanceof String) {
            return (String)this.key;
        }
        return null;
    }

    public Integer getIntValue() {
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        return null;
    }

    public void setIntValue(int i) {
        this.value = new Integer(i);
    }

    public void setIntValue(Integer i) {
        this.value = i;
    }

    public byte[] getBinaryValue() {
        if (this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        return null;
    }

    public Object getValue() {
        return this.value;
    }

    public void setBinaryValue(byte[] data) {
        this.setValue(data);
    }

    public String getStringValue() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value instanceof UTFValue) {
            return ((UTFValue)this.value).getValue();
        }
        return null;
    }

    public void setStringValue(String val) {
        this.setValue(val);
    }

    public void setUTF16Value(String val) {
        this.setValue(new UTFValue(val));
    }

    public void setUTF16Value(UTFValue val) {
        this.setValue(val);
    }

    public ValueType getValueType() {
        if (this.value instanceof byte[]) {
            return ValueType.BINARY;
        }
        if (this.value instanceof Double) {
            return ValueType.FLOAT;
        }
        if (this.value instanceof Integer) {
            return ValueType.INT;
        }
        if (this.value instanceof Long) {
            return ValueType.LONG;
        }
        if (this.value instanceof String) {
            return ValueType.STRING;
        }
        if (this.value instanceof KeyValueCollection) {
            return ValueType.TKV_LIST;
        }
        if (this.value instanceof UTFValue) {
            return ValueType.WIDE_STRING;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pair) {
            Pair pair = (Pair)obj;
            if (!this.key.equals(pair.key)) {
                return false;
            }
            if (this.value instanceof byte[]) {
                return this.equalArr(pair.value);
            }
            return this.value.equals(pair.value);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.key.hashCode() + this.valueHashCode();
    }

    private int valueHashCode() {
        if (this.value instanceof byte[]) {
            int h = 0;
            byte[] bb = (byte[])this.value;
            if (bb != null) {
                int index = 0;
                h = 1;
                for (byte b : bb) {
                    int h0 = b ^ index++;
                    int i = index & 0x1F;
                    h = h * 31 + (h0 << i | -h0 >>> i);
                }
            }
            return h;
        }
        return this.value.hashCode();
    }

    public String toString() {
        return "{" + this.key.toString() + ":" + this.value.toString() + "}";
    }

    protected Object clone() throws CloneNotSupportedException {
        Pair pair = (Pair)super.clone();
        if (this.value instanceof byte[]) {
            int len = ((byte[])this.value).length;
            pair.value = new byte[len];
            System.arraycopy(this.value, 0, pair.value, 0, len);
        }
        return pair;
    }

    protected void setValue(Object val) {
        if (val == null) {
            throw new NullPointerException("value can't be null");
        }
        this.value = val;
    }

    private boolean equalArr(Object val) {
        byte[] other;
        byte[] me;
        if (val instanceof byte[] && (me = (byte[])this.value).length == (other = (byte[])val).length) {
            for (int i = 0; i < me.length; ++i) {
                if (me[i] == other[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

