/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections.processor;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.runtime.processor.KeyValueFilterSet;

public class KeyValuePrinter {
    private static KeyValuePrinter defaultPrinter;
    private KeyValueFilterSet filters;
    public static final String DEF_FILTER_OPTION = "default-filter-type";
    public static final String TRUNCATE_THRESHOLD_OPTION = "truncate-threshold";
    public static final String COPY_FILTER_NAME = "copy";
    public static final String HIDE_FILTER_NAME = "hide";
    public static final String SKIP_FILTER_NAME = "skip";
    public static final String TRUNCATE_FILTER_NAME = "truncate";
    public static final String HIDE_FIRST_FILTER_NAME = "hide-first";
    public static final String HIDE_FIRST_CHARACTERS_COUNT = "hide-first-count";
    public static final String HIDE_LAST_FILTER_NAME = "hide-last";
    public static final String HIDE_LAST_CHARACTERS_COUNT = "hide-last-count";
    public static final String UNHIDE_FIRST_FILTER_NAME = "unhide-first";
    public static final String UNHIDE_FIRST_CHARACTERS_COUNT = "unhide-first-count";
    public static final String UNHIDE_LAST_FILTER_NAME = "unhide-last";
    public static final String UNHIDE_LAST_CHARACTERS_COUNT = "unhide-last-count";
    public static final String FILTER_NAME = "filter-name";
    public static final String CUSTOM_FILTER_NAME = "custom-filter";
    public static final String CUSTOM_FILTER_TYPE = "custom-filter-type";
    public static final String CUSTOM_FILTER_OPTIONS = "custom-filter-options";

    private KeyValuePrinter(KeyValueFilterSet filters) {
        this.filters = filters;
    }

    public KeyValuePrinter(KeyValueCollection options, KeyValueCollection data) {
        this.filters = new KeyValueFilterSet(options, data);
    }

    public static synchronized KeyValuePrinter getDefaultPrinter() {
        if (defaultPrinter == null) {
            defaultPrinter = new KeyValuePrinter(KeyValueFilterSet.DEFAULT_FILTERS);
        }
        return defaultPrinter;
    }

    public static synchronized void setDefaultPrinter(KeyValuePrinter printer) {
        if (printer == null) {
            throw new NullPointerException("printer cant be null");
        }
        defaultPrinter = printer;
    }

    public String toString(KeyValueCollection kvList) {
        return this.filters.filterList(null, kvList).toString();
    }

    public String toString(String key, Object value) {
        StringBuffer buf = new StringBuffer();
        this.filters.filterPair(buf, key, value);
        return buf.toString();
    }

    public void appendValue(StringBuffer buf, KeyValueCollection list) {
        this.filters.filterList(buf, list);
    }

    public void appendValue(StringBuffer buf, String key, Object value) {
        this.filters.filterPair(buf, key, value);
    }
}

