/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com;

import com.genesyslab.platform.applicationblocks.com.CfgDelta;
import com.genesyslab.platform.applicationblocks.com.CfgStructure;
import com.genesyslab.platform.applicationblocks.com.ConfigException;
import com.genesyslab.platform.applicationblocks.com.ConfigRuntimeException;
import com.genesyslab.platform.applicationblocks.com.ICfgBase;
import com.genesyslab.platform.applicationblocks.com.ICfgBriefInfo;
import com.genesyslab.platform.applicationblocks.com.ICfgDelta;
import com.genesyslab.platform.applicationblocks.com.ICfgObject;
import com.genesyslab.platform.applicationblocks.com.IConfService;
import com.genesyslab.platform.applicationblocks.com.runtime.ICollectionsBroker;
import com.genesyslab.platform.applicationblocks.com.runtime.StructuresBroker;
import com.genesyslab.platform.applicationblocks.com.runtime.XmlObjectUpdateHelper;
import com.genesyslab.platform.applicationblocks.com.runtime.XmlPropertiesHelper;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.Protocol;
import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import com.genesyslab.platform.configuration.protocol.ConfServerProtocol;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceKeyListDelta;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.metadata.ICfgAttributeOperationalInfo;
import com.genesyslab.platform.configuration.protocol.metadata.ICfgClassOperationalInfo;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CfgBase
implements ICfgBase {
    private IConfService configurationService;
    private CfgDescriptionClass dataClass;
    private boolean isStructure;
    private ReadWriteLock rwLock;
    private boolean isSaved;
    private Node xmlData;
    private Hashtable<String, Object> objectsHash;
    protected static final String CFG_NS = ConfServerProtocol.PROTOCOL_DESCRIPTION.getNS();
    private CfgBase parent;
    private final ILogger log = Log.getLogger(CfgBase.class);
    private static DocumentBuilder documentBuilder;

    protected CfgBase(IConfService confService, Node initXmlData, boolean initIsStructure, CfgBase initParent, String initDataClassName) {
        this.isSaved = true;
        this.initialize(confService, initXmlData, initIsStructure, initParent, initDataClassName);
    }

    protected CfgBase(IConfService confService, String className, boolean initIsStructure, CfgBase initParent, String initDataClassName) {
        Document dataTemp = documentBuilder.newDocument();
        dataTemp.appendChild(dataTemp.createElementNS(CFG_NS, className));
        Element node = dataTemp.getDocumentElement();
        this.initialize(confService, node, initIsStructure, initParent, initDataClassName);
    }

    protected final ILogger getLogger() {
        return this.log;
    }

    protected final ReadWriteLock lockObject() {
        return this.rwLock;
    }

    public final IConfService getConfigurationService() {
        return this.configurationService;
    }

    @Override
    public final Endpoint getEndpoint() {
        if (this.configurationService == null) {
            return null;
        }
        Protocol proto = this.configurationService.getProtocol();
        if (proto == null) {
            return null;
        }
        return proto.getEndpoint();
    }

    @Override
    public Node toXml() {
        this.refreshXml();
        return XmlObjectUpdateHelper.sortObjectAttributes(this.xmlData, this.dataClass).cloneNode(true);
    }

    protected ICfgObject getParent() {
        if (!(this.parent instanceof ICfgObject)) {
            throw new IllegalArgumentException("Parent is of invalid type. It is not an object");
        }
        return (ICfgObject)((Object)this.parent);
    }

    protected DocumentBuilder getDocumentBuilder() {
        return documentBuilder;
    }

    public final boolean isSaved() {
        return this.isSaved;
    }

    final void setIsSaved(boolean savedState) {
        this.isSaved = savedState;
    }

    protected void initialize(IConfService initConfService, Node initXmlData, boolean initIsStructure, CfgBase initParent, String initDataClassName) {
        this.isStructure = initIsStructure;
        this.configurationService = initConfService;
        this.parent = initParent;
        this.rwLock = new ReentrantReadWriteLock();
        this.dataClass = this.configurationService.getMetaData().getCfgClass(initDataClassName);
        this.initData(initXmlData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initData(Node xmlNewData) {
        if (xmlNewData == null) {
            throw new NullPointerException("xmlData");
        }
        this.rwLock.writeLock().lock();
        try {
            this.xmlData = xmlNewData;
            this.objectsHash = null;
            this.initData(xmlNewData, this.dataClass);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private void initData(Node xmlNewData, CfgDescriptionClass objDesc) {
        if (this.objectsHash == null) {
            this.objectsHash = new Hashtable();
        }
        CfgBase myParent = this.isStructure() ? this.parent : this;
        for (CfgDescriptionAttribute info : objDesc.getAttributes()) {
            Object objVal;
            List<CfgStructure> collectionTemp;
            String propName = info.getSchemaName();
            if (info.isCfgType(CfgTypeMask.Reference) && objDesc.isCfgType(CfgTypeMask.Delta) && !info.isCfgType(CfgTypeMask.List)) {
                CfgDescriptionAttributeReference rf = (CfgDescriptionAttributeReference)info;
                ICfgClassOperationalInfo deltaDataClass = (ICfgClassOperationalInfo)objDesc;
                if (rf.getCfgClass().getName().equals(deltaDataClass.getSubjectClassDescription().getName())) {
                    this.initData(xmlNewData, rf.getCfgClass());
                }
            }
            if (this.isDeltaStructureList(info)) {
                collectionTemp = XmlPropertiesHelper.createDeltaStructureList(propName, myParent, objDesc, this.configurationService, this.xmlData);
                if (collectionTemp == null) continue;
                this.objectsHash.put(propName, new StructuresBroker<CfgStructure>(collectionTemp));
                continue;
            }
            if (info instanceof CfgDescriptionAttributeReferenceKeyListDelta) {
                collectionTemp = XmlPropertiesHelper.createDeltaStructureList(propName, myParent, objDesc, this.configurationService, this.xmlData);
                if (collectionTemp == null) continue;
                this.objectsHash.put(propName, new StructuresBroker<CfgStructure>(collectionTemp));
                continue;
            }
            if (info.isCfgType(CfgTypeMask.List) && info.isCfgType(CfgTypeMask.Structure) || this.isListOfLinkStructures(info)) {
                collectionTemp = XmlPropertiesHelper.createStructureList(propName, myParent, objDesc, this.configurationService, this.xmlData);
                if (collectionTemp == null) continue;
                this.objectsHash.put(propName, new StructuresBroker<CfgStructure>(collectionTemp));
                continue;
            }
            if (info.isCfgType(CfgTypeMask.Link) && info.isCfgType(CfgTypeMask.List)) {
                Collection broker = XmlPropertiesHelper.createLinksListBroker(this.configurationService, this, this.parent, objDesc, info);
                if (broker == null) continue;
                this.objectsHash.put(propName, broker);
                continue;
            }
            if (info.isCfgType(CfgTypeMask.KvList) || !info.isCfgType(CfgTypeMask.Structure) || (objVal = XmlPropertiesHelper.createStructureClass(propName, myParent, objDesc, this.configurationService, this.xmlData)) == null) continue;
            this.objectsHash.put(propName, objVal);
        }
    }

    private boolean isDeltaStructureList(CfgDescriptionAttribute info) {
        ICfgAttributeOperationalInfo attrInfo = null;
        if (info instanceof ICfgAttributeOperationalInfo) {
            attrInfo = (ICfgAttributeOperationalInfo)info;
        }
        if (attrInfo == null || attrInfo.getSubjectAttributeDescription() == null) {
            return false;
        }
        return (attrInfo.getSubjectAttributeDescription().getTypeBitMask() & info.getTypeBitMask()) != attrInfo.getSubjectAttributeDescription().getTypeBitMask();
    }

    private boolean isListOfLinkStructures(CfgDescriptionAttribute info) {
        boolean br = false;
        if (info.isCfgType(CfgTypeMask.List) && info.isCfgType(CfgTypeMask.Link)) {
            CfgDescriptionAttributeReference refAttr = (CfgDescriptionAttributeReference)info;
            br = refAttr.getCfgClass().isCfgType(CfgTypeMask.Structure);
        }
        return br;
    }

    void reloadObjectWithNewXml(Node xmlNewData) {
        this.initData(xmlNewData);
    }

    public final Node getData() {
        return this.xmlData;
    }

    public final CfgDescriptionClass getMetaData() {
        return this.dataClass;
    }

    public final boolean isStructure() {
        return this.isStructure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer getLinkValue(String propertyName) {
        Integer tempValue = null;
        this.rwLock.readLock().lock();
        try {
            tempValue = XmlPropertiesHelper.getLinkValue(propertyName, this.dataClass, this.xmlData);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return tempValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Integer[] getLinkListValue(String propertyName) {
        Integer[] tempValue = null;
        this.rwLock.readLock().lock();
        try {
            tempValue = XmlPropertiesHelper.getLinkListValue(propertyName, this.dataClass, this.xmlData);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return tempValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Integer> getLinkListCollection(String propertyName) {
        this.rwLock.readLock().lock();
        try {
            Collection<Integer> collection = XmlPropertiesHelper.getLinkListCollection(propertyName, this.dataClass, this.xmlData);
            return collection;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private CfgDescriptionAttribute getAttributeInfo(String propertyName) {
        CfgDescriptionAttribute info = this.dataClass.getAttribute(propertyName);
        if (info == null && this.dataClass instanceof ICfgClassOperationalInfo) {
            ICfgClassOperationalInfo delta = (ICfgClassOperationalInfo)this.dataClass;
            info = delta.getSubjectClassDescription().getAttribute(propertyName);
        }
        return info;
    }

    private Object getPropertyImpl(Class<?> retClass, String propertyName) throws ConfigException {
        CfgDescriptionAttribute info = this.getAttributeInfo(propertyName);
        if (info == null && !this.isStructure() && propertyName.compareTo("DBID") == 0) {
            if (this instanceof ICfgBriefInfo) {
                CfgBase id = (CfgBase)this.getPropertyImpl(null, "ID");
                if (id != null) {
                    return id.getPropertyImpl(null, "DBID");
                }
                return null;
            }
            CfgBase groupInfo = this instanceof ICfgDelta ? (CfgBase)this.getPropertyImpl(null, "deltaGroupInfo") : (CfgBase)this.getPropertyImpl(null, "groupInfo");
            if (groupInfo == null) {
                return null;
            }
            return groupInfo.getPropertyImpl(null, "DBID");
        }
        if (info == null) {
            throw new ConfigRuntimeException("There is no property '" + propertyName + "' in this class in current schema version.");
        }
        if (info.isCfgType(CfgTypeMask.Primitive)) {
            return XmlPropertiesHelper.getSimpleProperty(propertyName, retClass, info, this.xmlData);
        }
        if (info.isCfgType(CfgTypeMask.KvList)) {
            KeyValueCollection val = (KeyValueCollection)this.objectsHash.get(propertyName);
            if (val == null && (val = XmlPropertiesHelper.createKvList(propertyName, this, info.getParent(), this.xmlData)) != null) {
                this.objectsHash.put(propertyName, val);
            }
            return val;
        }
        if (info.isCfgType(CfgTypeMask.Structure) || info.isCfgType(CfgTypeMask.List) && info.isCfgType(CfgTypeMask.Structure) || info.isCfgType(CfgTypeMask.List) && info.isCfgType(CfgTypeMask.Link) || info instanceof CfgDescriptionAttributeReferenceKeyListDelta) {
            return this.objectsHash.get(propertyName);
        }
        if (info.isCfgType(CfgTypeMask.Link)) {
            Object cachedVal = this.objectsHash.get(propertyName);
            if (cachedVal != null) {
                return cachedVal;
            }
            ICfgObject linkObject = XmlPropertiesHelper.createLinkObject(info, this.configurationService, this.xmlData);
            return linkObject;
        }
        return null;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.getProperty(null, propertyName);
    }

    protected Object getProperty(Class<?> retClass, String propertyName) {
        Object tempObject = null;
        this.rwLock.readLock().lock();
        try {
            tempObject = this.getPropertyImpl(retClass, propertyName);
        }
        catch (ConfigException e) {
            throw new ConfigRuntimeException("Error getting property value for " + propertyName + "", e);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return tempObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String propertyName, Object value) {
        this.rwLock.writeLock().lock();
        try {
            this.ensureDataBackup();
            this.setPropertyImpl(propertyName, value);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private void setPropertyImpl(String propertyName, Object propertyValue) {
        CfgDescriptionAttribute info = this.dataClass.getAttribute(propertyName);
        if (!this.isStructure() && propertyName.compareTo("DBID") == 0 && info == null) {
            try {
                if (this instanceof ICfgBriefInfo) {
                    CfgBase id = (CfgBase)this.getPropertyImpl(null, "ID");
                    if (id != null) {
                        id.setPropertyImpl("DBID", propertyValue);
                    }
                    return;
                }
                CfgBase groupInfo = this instanceof CfgDelta ? (CfgBase)this.getPropertyImpl(null, "deltaGroupInfo") : (CfgBase)this.getPropertyImpl(null, "groupInfo");
                if (groupInfo == null) {
                    throw new ConfigRuntimeException("There is no inner group info structure initialized to set DBID value.");
                }
                groupInfo.setPropertyImpl("DBID", propertyValue);
                return;
            }
            catch (ConfigException e) {
                throw new ConfigRuntimeException("Object does not have inner group information set ('groupInfo' property)", e);
            }
        }
        if (info == null) {
            throw new ConfigRuntimeException("There is no property '" + propertyName + "' in this class in current schema version.");
        }
        if (this.xmlData == null) {
            throw new IllegalArgumentException("The object doesn't have a root node");
        }
        if (propertyValue == null) {
            throw new IllegalArgumentException("New value is null");
        }
        if (info.isCfgType(CfgTypeMask.Primitive)) {
            XmlPropertiesHelper.setSimpleProperty(info, this.xmlData, propertyValue);
        } else if (info.isCfgType(CfgTypeMask.KvList)) {
            if (!(propertyValue instanceof KeyValueCollection)) {
                throw new IllegalArgumentException("The new value is not the right type. It should be KeyValueCollection");
            }
            XmlPropertiesHelper.setKvListProperty(info, this.xmlData, propertyValue);
            this.objectsHash.put(propertyName, propertyValue);
        } else if (info.isCfgType(CfgTypeMask.Structure)) {
            if (!info.isCfgType(CfgTypeMask.List)) {
                if (!(propertyValue instanceof CfgBase)) {
                    throw new IllegalArgumentException("The new value is not the right type. It should be CfgBase");
                }
                XmlPropertiesHelper.setStructureProperty(propertyValue, this.xmlData);
                CfgBase myParent = this.isStructure ? this.parent : this;
                this.objectsHash.put(propertyName, XmlPropertiesHelper.createStructureClass(propertyName, myParent, this.dataClass, this.configurationService, this.xmlData));
            } else {
                XmlPropertiesHelper.setStructureCollectionProperty(propertyValue, info, this.xmlData);
                CfgBase myParent = this.isStructure ? this.parent : this;
                this.objectsHash.put(propertyName, XmlPropertiesHelper.createStructureList(propertyName, myParent, this.dataClass, this.configurationService, this.xmlData));
            }
        } else if (info.isCfgType(CfgTypeMask.Link)) {
            if (!info.isCfgType(CfgTypeMask.List)) {
                XmlPropertiesHelper.setLinkProperty(propertyValue, info, this.xmlData);
                this.objectsHash.remove(propertyName);
            } else {
                XmlPropertiesHelper.setLinkColProperty(propertyValue, info, this.xmlData);
                ICollectionsBroker broker = (ICollectionsBroker)this.objectsHash.get(propertyName);
                broker.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean refreshXml() {
        this.rwLock.writeLock().lock();
        boolean br = false;
        try {
            br = this.refreshXmlImpl();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        return br;
    }

    boolean refreshXmlImpl() {
        boolean refreshPerformed = false;
        Collection properties = this.dataClass.getAttributes();
        for (CfgDescriptionAttribute info : properties) {
            KeyValueCollection col;
            if (info.isCfgType(CfgTypeMask.Structure)) {
                if (info.isCfgType(CfgTypeMask.List)) {
                    List structureCollection = (List)this.objectsHash.get(info.getSchemaName());
                    if (structureCollection == null) continue;
                    for (Object obj : structureCollection) {
                        ((CfgBase)obj).refreshXmlImpl();
                    }
                    XmlPropertiesHelper.setStructureCollectionProperty(structureCollection, info, this.xmlData);
                    refreshPerformed = true;
                    continue;
                }
                CfgBase structure = (CfgBase)this.objectsHash.get(info.getSchemaName());
                if (structure == null) continue;
                structure.refreshXmlImpl();
                XmlPropertiesHelper.setStructureProperty(structure, this.xmlData);
                refreshPerformed = true;
                continue;
            }
            if (!info.isCfgType(CfgTypeMask.KvList) || (col = (KeyValueCollection)this.objectsHash.get(info.getSchemaName())) == null) continue;
            XmlPropertiesHelper.setKvListProperty(info, this.xmlData, col);
            refreshPerformed = true;
        }
        return refreshPerformed;
    }

    protected void ensureDataBackup() {
        if (this.parent != null) {
            this.parent.ensureDataBackup();
        }
    }

    protected void updateChildrenSavedState() {
        Collection properties = this.dataClass.getAttributes();
        for (CfgDescriptionAttribute info : properties) {
            if (!info.isCfgType(CfgTypeMask.Structure)) continue;
            if (info.isCfgType(CfgTypeMask.List)) {
                Collection structureCollection = (Collection)this.objectsHash.get(info.getName());
                if (structureCollection == null) continue;
                for (Object item : structureCollection) {
                    ((CfgBase)item).setIsSaved(this.isSaved());
                }
                continue;
            }
            CfgBase structure = (CfgBase)this.objectsHash.get(info.getName());
            if (structure == null) continue;
            structure.setIsSaved(this.isSaved());
        }
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("Configuration object: type = ");
        output.append(this.getClass().getSimpleName());
        output.append(", properties = {\n");
        StringBuilder propertiesOutput = this.toStringProperties();
        String propFormat = propertiesOutput.toString();
        propFormat = propFormat.replaceAll("\n", "\n    ");
        propFormat = propFormat.trim();
        if (propFormat.length() > 0) {
            output.append("    ").append(propFormat).append("\n");
        }
        output.append("}");
        return output.toString();
    }

    protected StringBuilder toStringProperties() {
        StringBuilder propertiesOutput = new StringBuilder();
        for (CfgDescriptionAttribute info : this.getMetaData().getAttributes()) {
            String key = info.getSchemaName();
            Object val = null;
            if (info.isCfgType(CfgTypeMask.Link) && !info.isCfgType(CfgTypeMask.List)) {
                val = this.getLinkValue(key);
            } else {
                val = this.getProperty(key);
                if (val instanceof Calendar) {
                    val = DateFormat.getDateTimeInstance(1, 1).format(((Calendar)val).getTime());
                }
            }
            if (val == null) continue;
            propertiesOutput.append(key).append(" : ");
            propertiesOutput.append(val);
            propertiesOutput.append("\n");
        }
        return propertiesOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CfgBase clone() throws CloneNotSupportedException {
        this.rwLock.writeLock().lock();
        CfgBase ret = null;
        Node xmlCopy = this.xmlData;
        try {
            this.refreshXmlImpl();
            ret = (CfgBase)super.clone();
            Document dataTemp = documentBuilder.newDocument();
            xmlCopy = dataTemp.importNode(this.xmlData, true);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        ret.xmlData = xmlCopy;
        ret.initialize(this.getConfigurationService(), xmlCopy, this.isStructure, null, this.getMetaData().getName());
        return ret;
    }

    static {
        try {
            documentBuilder = XmlFactories.newDocumentBuilderNS();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

