/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com;

import com.genesyslab.platform.applicationblocks.com.CfgQuery;
import com.genesyslab.platform.applicationblocks.com.ICfgFilterBasedQuery;
import com.genesyslab.platform.applicationblocks.com.ICfgObject;
import com.genesyslab.platform.applicationblocks.com.IConfService;
import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CfgFilterBasedQuery
extends CfgQuery
implements ICfgFilterBasedQuery {
    private CfgObjectType objectType;
    private Class<? extends ICfgObject> objectClass;
    private Hashtable<String, Object> filter = new Hashtable();

    public CfgFilterBasedQuery(CfgObjectType objectType, IConfService confService) {
        super(confService);
        this.objectType = objectType;
        this.filter.put("read_folder_dbid", 0);
        this.filter.put("object_path", 0);
    }

    public CfgFilterBasedQuery(CfgObjectType objType) {
        this(objType, null);
    }

    protected <T extends ICfgObject> void setObjectClass(Class<T> clazz) {
        this.objectClass = clazz;
    }

    @Override
    public void setDoRequestObjectPath(boolean value) {
        this.setProperty("object_path", value ? Integer.valueOf(0) : null);
    }

    @Override
    public boolean getDoRequestObjectPath() {
        return this.getProperty("object_path") != null;
    }

    @Override
    public void setDoRequestFolderId(boolean value) {
        this.setProperty("read_folder_dbid", value ? Integer.valueOf(0) : null);
    }

    @Override
    public boolean getDoRequestFolderId() {
        return this.getProperty("read_folder_dbid") != null;
    }

    @Override
    public void setProperty(String name, Object newValue) {
        if (newValue == null) {
            this.filter.remove(name);
        } else {
            this.filter.put(name, newValue);
        }
    }

    @Override
    public Object getProperty(String name) {
        return this.filter.get(name);
    }

    @Override
    public int getInt(String name) {
        Object obj = this.getProperty(name);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof GEnum) {
            return ((GEnum)obj).ordinal();
        }
        return Integer.parseInt(obj.toString());
    }

    @Override
    public String getString(String name) {
        Object obj = this.getProperty(name);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public CfgObjectType getCfgObjectType() {
        return this.objectType;
    }

    public <T extends ICfgObject> Class<T> getCfgObjectClass() {
        return this.objectClass;
    }

    @Override
    public Hashtable<String, Object> getFilter() {
        return this.filter;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.filter != null) {
            res.append("Query object type: ").append(this.objectType).append("\n");
            res.append("Query filters:\n");
            for (String key : this.filter.keySet()) {
                res.append("  Key: ").append(key).append(", Value: ").append(this.filter.get(key));
            }
        }
        return res.toString();
    }
}

