/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com;

import com.genesyslab.platform.applicationblocks.com.AsyncRequestResult;
import com.genesyslab.platform.applicationblocks.com.CfgFilterBasedQuery;
import com.genesyslab.platform.applicationblocks.com.CfgObject;
import com.genesyslab.platform.applicationblocks.com.CfgXPathBasedQuery;
import com.genesyslab.platform.applicationblocks.com.ConfEvent;
import com.genesyslab.platform.applicationblocks.com.ConfigException;
import com.genesyslab.platform.applicationblocks.com.ConfigRuntimeException;
import com.genesyslab.platform.applicationblocks.com.DefaultConfServicePolicy;
import com.genesyslab.platform.applicationblocks.com.ICfgBriefInfo;
import com.genesyslab.platform.applicationblocks.com.ICfgFilterBasedQuery;
import com.genesyslab.platform.applicationblocks.com.ICfgObject;
import com.genesyslab.platform.applicationblocks.com.ICfgQuery;
import com.genesyslab.platform.applicationblocks.com.IConfService;
import com.genesyslab.platform.applicationblocks.com.IConfServicePolicy;
import com.genesyslab.platform.applicationblocks.com.NotificationQuery;
import com.genesyslab.platform.applicationblocks.com.Subscription;
import com.genesyslab.platform.applicationblocks.com.cache.DefaultConfCache;
import com.genesyslab.platform.applicationblocks.com.cache.IConfCache;
import com.genesyslab.platform.applicationblocks.com.runtime.AsyncRequestResultImpl;
import com.genesyslab.platform.applicationblocks.com.runtime.CfgObjectActivator;
import com.genesyslab.platform.applicationblocks.com.runtime.EventService;
import com.genesyslab.platform.applicationblocks.com.runtime.GlobalConfService;
import com.genesyslab.platform.applicationblocks.commons.Action;
import com.genesyslab.platform.applicationblocks.commons.Predicate;
import com.genesyslab.platform.applicationblocks.commons.broker.Subscriber;
import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.AsyncInvokerSupport;
import com.genesyslab.platform.commons.protocol.DuplexChannel;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.MessageHandler;
import com.genesyslab.platform.commons.protocol.Protocol;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.configuration.protocol.ConfServerProtocol;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventBriefInfo;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventError;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectsRead;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestGetBriefInfo;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestReadObjects;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestReadObjects2;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfService
implements IConfService,
Subscriber<Message>,
AsyncInvokerSupport {
    private Protocol confProtocol;
    private EventService eventService;
    private AsyncInvoker asyncInvoker = null;
    private IConfServicePolicy confPolicy = new DefaultConfServicePolicy();
    private IConfCache confCache = null;
    private CfgMetadata metaData = null;
    private MessageHandler ownMessageHandler = null;
    private MessageHandler userMessageHandler = null;
    private boolean isDisposed = false;
    private Object lifecycleGuard = new Object();
    private final ILogger log = Log.getLogger(ConfService.class);

    protected ConfService(Protocol protocol) {
        if (protocol == null) {
            throw new NullPointerException("protocol");
        }
        if (!ConfServerProtocol.PROTOCOL_DESCRIPTION.equals((Object)protocol.getProtocolDescription())) {
            throw new IllegalArgumentException("Illegal protocol - should be ConfServerProtocol");
        }
        this.confProtocol = protocol;
        this.initLogging();
        this.eventService = new EventService(this);
        if (protocol instanceof ConfServerProtocol) {
            this.metaData = ((ConfServerProtocol)protocol).getServerContext().getMetadata();
        } else {
            try {
                ConfServerProtocol csp = new ConfServerProtocol(new Endpoint(new URI("tcp://test:123")));
                csp.setUseConfDataNs(true);
                this.metaData = csp.getServerContext().getMetadata();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unexpected internal exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupInternalMessageHandler() {
        Object object = this.lifecycleGuard;
        synchronized (object) {
            if (!(this.confProtocol instanceof DuplexChannel)) {
                throw new IllegalArgumentException("Only DuplexChannel has MessageHandler interface support");
            }
            COMMessageHandler hndl = new COMMessageHandler();
            ((DuplexChannel)this.confProtocol).setMessageHandler((MessageHandler)hndl);
            this.ownMessageHandler = hndl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Object object = this.lifecycleGuard;
        synchronized (object) {
            if (!this.isDisposed) {
                this.isDisposed = true;
                if (this.ownMessageHandler != null) {
                    try {
                        ((DuplexChannel)this.confProtocol).setMessageHandler(null);
                    }
                    catch (Exception ex) {
                        this.log.error((Object)"Exception removing private MessageHandler from protocol", (Throwable)ex);
                    }
                    this.ownMessageHandler = null;
                }
                this.eventService.dispose();
                this.eventService = null;
                this.confProtocol = null;
                this.metaData = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Object object = this.lifecycleGuard;
        synchronized (object) {
            return this.isDisposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exceptionIfDisposed() {
        Object object = this.lifecycleGuard;
        synchronized (object) {
            if (this.isDisposed) {
                throw new RuntimeException("Service is already disposed");
            }
        }
    }

    @Override
    public CfgMetadata getMetaData() {
        return this.metaData;
    }

    protected ILogger getLogger() {
        return this.log;
    }

    @Override
    public Protocol getProtocol() {
        return this.confProtocol;
    }

    @Override
    public void setUserMessageHandler(MessageHandler msgHandler) {
        this.userMessageHandler = msgHandler;
    }

    protected AsyncInvoker getInvokerNotNull() {
        if (this.asyncInvoker == null) {
            throw new ConfigRuntimeException("AsyncInvoker has not been set. Use ConfService.setInvoker()");
        }
        return this.asyncInvoker;
    }

    @Override
    public void setInvoker(AsyncInvoker invoker) {
        this.asyncInvoker = invoker;
    }

    @Override
    public void setBrokerInvoker(AsyncInvoker invoker) {
        this.eventService.setInvoker(this.asyncInvoker);
    }

    @Override
    public IConfCache getCache() {
        return this.confCache;
    }

    void setCache(IConfCache cache) {
        if (cache instanceof DefaultConfCache) {
            DefaultConfCache defCache = (DefaultConfCache)cache;
            if (this.getProtocol() != null && this.getProtocol().getEndpoint() != null) {
                if (defCache.getEndpointCount() > 0) {
                    throw new IllegalArgumentException("This cache has been previously associated with a configuration service.");
                }
                defCache.addEndpoint(this.getProtocol().getEndpoint());
            }
        }
        this.confCache = cache;
        this.getLogger().infoFormat("Caching enabled: {0}", (Object)(this.confCache != null ? 1 : 0));
    }

    @Override
    public IConfServicePolicy getPolicy() {
        return this.confPolicy;
    }

    void setPolicy(IConfServicePolicy policy) {
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        this.confPolicy = policy;
    }

    @Override
    public ICfgObject retrieveObject(CfgObjectType objectType, int dbId) throws ConfigException {
        CfgFilterBasedQuery query = new CfgFilterBasedQuery(objectType);
        query.setProperty("dbid", dbId);
        return this.retrieveObject(null, query, false);
    }

    @Override
    public ICfgObject retrieveObject(ICfgQuery query) throws ConfigException {
        return this.retrieveObject(null, query, false);
    }

    @Override
    public <T extends ICfgObject> T retrieveObject(Class<T> cls, ICfgQuery query) throws ConfigException {
        this.checkObjectClass(cls, query);
        return (T)this.retrieveObject(null, query, cls != null && ICfgBriefInfo.class.isAssignableFrom(cls));
    }

    @Override
    public <T extends ICfgObject> Collection<T> retrieveMultipleObjects(Class<T> cls, ICfgQuery query) throws ConfigException, InterruptedException {
        return this.endRetrieveMultipleObjects(this.beginRetrieveMultipleObjects(cls, query, null));
    }

    @Override
    public <T extends ICfgObject> Collection<T> retrieveMultipleObjects(Class<T> cls, ICfgQuery query, long timeout) throws ConfigException, InterruptedException {
        return this.endRetrieveMultipleObjects(this.beginRetrieveMultipleObjects(cls, query, null, null, timeout));
    }

    private <T extends ICfgObject> Collection<T> retrieveMultipleFromCache(Class<T> cls, ICfgQuery query) throws ConfigException {
        if (this.getLogger().isDebug()) {
            this.getLogger().debug((Object)"Querying cache...");
        }
        Iterable<T> objs = this.confCache.retrieveMultiple(cls, query);
        ArrayList<ICfgObject> ret = null;
        if (objs != null) {
            ret = new ArrayList<ICfgObject>();
            for (ICfgObject obj : objs) {
                ret.add(obj);
            }
            if (this.getLogger().isInfo()) {
                this.getLogger().info((Object)("Retrieved " + ret.size() + " objects from cache."));
            }
        } else {
            this.getLogger().info((Object)"No data returned from cache.");
        }
        return ret;
    }

    @Override
    public void saveObject(ICfgObject cfgObject) throws ConfigException {
        if (cfgObject == null) {
            throw new NullPointerException("cfgObject");
        }
        cfgObject.save();
    }

    @Override
    public void deleteObject(ICfgObject cfgObject) throws ConfigException {
        if (cfgObject == null) {
            throw new NullPointerException("cfgObject");
        }
        cfgObject.delete();
    }

    @Override
    public void refreshObject(ICfgObject cfgObject) throws ConfigException {
        if (cfgObject == null) {
            throw new NullPointerException("cfgObject");
        }
        CfgFilterBasedQuery query = new CfgFilterBasedQuery(cfgObject.getObjectType());
        query.setProperty("dbid", cfgObject.getObjectDbid());
        if (this.retrieveObject(cfgObject, query, false) == null) {
            throw new ConfigException("Configuration server does not contain object to refresh from");
        }
    }

    public void register(Subscriber<ConfEvent> subscriber) {
        if (this.log.isDebug() && subscriber != null) {
            this.log.debug((Object)("Registering subscriber " + subscriber.toString()));
        }
        this.eventService.register(subscriber);
    }

    public void register(Action<ConfEvent> handler, Predicate<ConfEvent> filter) {
        if (this.log.isDebug() && handler != null) {
            this.log.debugFormat("Registering handler [{0}] with filer [{1}]", (Object)new Object[]{handler.toString(), filter});
        }
        this.eventService.register(handler, filter);
    }

    public void unregister(Subscriber<ConfEvent> subscriber) {
        if (this.log.isDebug() && subscriber != null) {
            this.log.debug((Object)("Unregistering subscriber " + subscriber.toString()));
        }
        this.eventService.unregister(subscriber);
    }

    public void unregister(Action<ConfEvent> handler) {
        if (this.log.isDebug() && handler != null) {
            this.log.debugFormat("Unregistering handler [{0}]", (Object)new Object[]{handler.toString()});
        }
        this.eventService.unregister(handler);
    }

    @Override
    public Subscription subscribe(NotificationQuery query) throws ConfigException {
        return GlobalConfService.subscribe(this.confProtocol, query);
    }

    @Override
    public Subscription subscribe(ICfgObject obj) throws ConfigException {
        return GlobalConfService.subscribe(this.confProtocol, obj);
    }

    @Override
    public void unsubscribe(Subscription subscription) throws ConfigException {
        GlobalConfService.unsubscribe(this.confProtocol, subscription);
    }

    protected ICfgObject retrieveObject(ICfgObject confObj, ICfgQuery query) throws ConfigException {
        return this.retrieveObject(confObj, query, false);
    }

    protected ICfgObject retrieveObject(ICfgObject confObj, ICfgQuery query, boolean isBriefInfo) throws ConfigException {
        Document confObject;
        Message response;
        Message message;
        ICfgObject result = confObj;
        boolean isBriefInfoRequest = isBriefInfo;
        if (confObj != null) {
            isBriefInfoRequest = confObj instanceof ICfgBriefInfo;
        }
        if (this.getLogger().isInfo()) {
            this.getLogger().info((Object)("Retrieve object using query: \r\n\r\n" + query));
        }
        if (confObj == null && !isBriefInfoRequest && this.confPolicy.getQueryCacheOnRetrieve(query)) {
            if (this.confCache == null) {
                throw new NullPointerException("ConfCache");
            }
            if (this.getLogger().isDebug()) {
                this.getLogger().debug((Object)"Querying cache...");
            }
            if ((result = this.confCache.retrieve(ICfgObject.class, query)) != null) {
                return result;
            }
        }
        Message message2 = message = isBriefInfoRequest ? this.prepareRequestReadBriefInfoMessage(query) : this.prepareRequestReadObjectsMessage(query);
        if (message == null) {
            throw new ConfigException("Got null RequestReadObjects message");
        }
        if (this.getLogger().isDebug()) {
            this.getLogger().debug((Object)"Querying configuration server...");
        }
        try {
            response = this.getProtocol().request(message);
        }
        catch (Exception ex) {
            this.getLogger().error((Object)"Exception on request handling", (Throwable)ex);
            throw new ConfigException("Exception on reading configuration data", ex);
        }
        if (response == null) {
            this.getLogger().error((Object)("Null response got on MSG: " + message));
            throw new ConfigException("Error reading configuration data - timeout waiting for server response");
        }
        if (response instanceof EventError) {
            throw GlobalConfService.createConfigServerException((EventError)response);
        }
        EventObjectsRead readResponse = null;
        EventBriefInfo briefInfoResponse = null;
        if (response.messageId() == 73) {
            readResponse = (EventObjectsRead)response;
            confObject = readResponse.getConfObject();
        } else if (response.messageId() == 29) {
            briefInfoResponse = (EventBriefInfo)response;
            confObject = briefInfoResponse.getBriefInfo();
        } else {
            return null;
        }
        if (confObject == null) {
            return null;
        }
        int objectsCount = confObject.getDocumentElement().getChildNodes().getLength();
        if (objectsCount == 0) {
            return null;
        }
        if (objectsCount != 1) {
            throw new IllegalArgumentException("Query returned invalid number of objects. Should be 1. Use retrieveMultipleObjects() for this query.");
        }
        long[] foldersDbids = null;
        String[] objectPaths = null;
        if (readResponse != null) {
            foldersDbids = readResponse.getFolderDbids();
            if (foldersDbids != null && foldersDbids.length < objectsCount) {
                throw new ConfigException("There is a wrong number of folder dbids  in the Read request result");
            }
            objectPaths = readResponse.getObjectPaths();
            if (objectPaths == null) {
                if (foldersDbids != null) {
                    objectPaths = new String[]{"/"};
                }
            } else if (objectPaths.length < objectsCount) {
                throw new ConfigException("There is a wrong number of object paths in the Read request result");
            }
        }
        if (result == null) {
            int folderDbid = 0;
            String objectPath = null;
            if (foldersDbids != null && foldersDbids.length > 0) {
                folderDbid = (int)foldersDbids[0];
            }
            if (objectPaths != null && objectPaths.length > 0) {
                objectPath = objectPaths[0];
            }
            result = this.createObjectFromXML(confObject.getDocumentElement().getFirstChild(), objectPath, folderDbid, true);
            if (!isBriefInfoRequest) {
                GlobalConfService.addToCache(this, result);
            }
        } else {
            ((CfgObject)result).reloadObjectWithNewXml(confObject.getDocumentElement().getFirstChild());
        }
        if (this.getLogger().isInfo() && result != null) {
            this.getLogger().infoFormat("Retrieved object [{0}], dbid: [{1}]", (Object)new Object[]{result.getObjectType(), result.getObjectDbid()});
        }
        if (this.getLogger().isDebug() && result != null) {
            this.getLogger().debug((Object)("Object content: \r\n\r\n" + result.toString()));
        }
        return result;
    }

    protected KeyValueCollection prepareReadObjectsFilter(ICfgFilterBasedQuery query) {
        KeyValueCollection objectFilter = new KeyValueCollection();
        if (query != null) {
            Hashtable<String, Object> filter = query.getFilter();
            for (String key : filter.keySet()) {
                Object value = filter.get(key);
                if (value instanceof GEnum) {
                    objectFilter.addInt(key, ((GEnum)value).asInteger());
                    continue;
                }
                if (value instanceof Integer) {
                    objectFilter.addInt(key, (Integer)value);
                    continue;
                }
                objectFilter.addObject(key, value);
            }
        }
        return objectFilter;
    }

    protected Message prepareRequestReadBriefInfoMessage(ICfgQuery query) {
        int objType = CfgObjectType.CFGNoObject.ordinal();
        if (query instanceof ICfgFilterBasedQuery) {
            KeyValueCollection objectFilter = this.prepareReadObjectsFilter((ICfgFilterBasedQuery)query);
            objType = ((ICfgFilterBasedQuery)query).getCfgObjectType().ordinal();
            return RequestGetBriefInfo.create((Integer)objType, (KeyValueCollection)objectFilter);
        }
        throw new IllegalArgumentException("unsupported query type");
    }

    @Override
    public <T extends ICfgObject> AsyncRequestResult<T> beginRetrieveMultipleObjects(Class<T> cls, ICfgQuery query, Action<AsyncRequestResult<T>> finishCallback) throws ConfigException {
        return this.beginRetrieveMultipleObjects(cls, query, null, finishCallback, this.getProtocol().getTimeout());
    }

    @Override
    public <T extends ICfgObject> AsyncRequestResult<T> beginRetrieveMultipleObjects(Class<T> cls, ICfgQuery query, Action<Collection<T>> dataCallback, Action<AsyncRequestResult<T>> finishCallback) throws ConfigException {
        return this.beginRetrieveMultipleObjects(cls, query, dataCallback, finishCallback, this.getProtocol().getTimeout());
    }

    @Override
    public <T extends ICfgObject> AsyncRequestResult<T> beginRetrieveMultipleObjects(Class<T> cls, ICfgQuery query, Action<Collection<T>> dataCallback, Action<AsyncRequestResult<T>> finishCallback, long timeout) throws ConfigException {
        Collection<T> objs;
        boolean isBriefInfoRequest;
        this.checkObjectClass(cls, query);
        boolean bl = isBriefInfoRequest = cls != null && ICfgBriefInfo.class.isAssignableFrom(cls);
        if (this.getLogger().isInfo()) {
            this.getLogger().info((Object)("Beginning multiple retrieve operation using query: \r\n\r\n" + query));
        }
        if (!isBriefInfoRequest && this.confPolicy.getQueryCacheOnRetrieveMultiple(query) && (objs = this.retrieveMultipleFromCache(cls, query)) != null && objs.size() > 0) {
            AsyncInvoker invoker = null;
            if (dataCallback != null || finishCallback != null) {
                invoker = this.getInvokerNotNull();
            }
            return new AsyncRequestResultImpl<T>(cls, query, objs, dataCallback, finishCallback, invoker);
        }
        if (this.getLogger().isDebug()) {
            this.getLogger().debug((Object)"Querying configuration server...");
        }
        try {
            Message rqMsg;
            Message message = rqMsg = isBriefInfoRequest ? this.prepareRequestReadBriefInfoMessage(query) : this.prepareRequestReadObjectsMessage(query);
            if (rqMsg == null) {
                throw new ConfigException("Got null RequestReadObjects message");
            }
            AsyncInvoker invoker = null;
            if (dataCallback != null || finishCallback != null) {
                invoker = this.getInvokerNotNull();
            }
            AsyncRequestResultImpl<T> ret = new AsyncRequestResultImpl<T>(cls, query, rqMsg, dataCallback, finishCallback, invoker, timeout);
            this.eventService.registerAsyncRequest(this.getProtocol().getReferenceBuilder().updateReference(rqMsg), ret);
            this.getProtocol().send(rqMsg);
            return ret;
        }
        catch (Exception ex) {
            this.getLogger().error((Object)"Exception on sending request", (Throwable)ex);
            throw new ConfigException("Exception on sending request", ex);
        }
    }

    @Override
    public <T extends ICfgObject> Collection<T> endRetrieveMultipleObjects(AsyncRequestResult<T> rqResult) throws ConfigException, InterruptedException {
        try {
            return rqResult.get();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (!(throwable instanceof ConfigException) && !(throwable instanceof ConfigRuntimeException)) {
                throwable = e;
            }
            this.getLogger().error((Object)"Error processing async request", throwable);
            if (throwable instanceof ConfigException) {
                throw (ConfigException)throwable;
            }
            if (throwable instanceof ConfigRuntimeException) {
                throw (ConfigRuntimeException)throwable;
            }
            throw new ConfigException("Error processing async request", e);
        }
    }

    @Override
    public ICfgObject createObjectFromXML(Node confObject, String objectPath, int folderDbid, boolean isSaved) throws ConfigException {
        if (confObject == null || confObject.getChildNodes().getLength() == 0) {
            throw new IllegalArgumentException("confObject");
        }
        String objTypeName = confObject.getNodeName();
        try {
            KeyValueCollection param = new KeyValueCollection();
            if (folderDbid > 0) {
                param.addInt("folder_dbid", folderDbid);
            }
            CfgObject ret = (CfgObject)CfgObjectActivator.createInstance(objTypeName, this, confObject, new Object[]{param, objectPath});
            ret.setIsSaved(isSaved);
            return ret;
        }
        catch (Exception ex) {
            this.getLogger().error((Object)"Error creating object from XML", (Throwable)ex);
            throw new ConfigException("Unknown object type '" + objTypeName + "'", ex);
        }
    }

    @Override
    public ICfgObject createObjectFromXML(Node confObject, boolean isSaved) throws ConfigException {
        return this.createObjectFromXML(confObject, null, 0, isSaved);
    }

    @Override
    public <T extends ICfgObject> Collection<T> createMultipleObjectsFromXML(Node confObjectsContainer, String[] objectsPaths, int[] foldersDbids) throws ConfigException {
        if (confObjectsContainer == null) {
            throw new NullPointerException("confObjectsContainer");
        }
        return this.createMultipleObjectsFromXML(confObjectsContainer.getChildNodes(), objectsPaths, foldersDbids);
    }

    public <T extends ICfgObject> Collection<T> createMultipleObjectsFromXML(NodeList confObjects, String[] objectsPaths, int[] foldersDbids) throws ConfigException {
        if (confObjects == null) {
            throw new NullPointerException("confObjectsContainer");
        }
        String[] pathes = objectsPaths;
        int[] folderIds = foldersDbids;
        int elemCount = confObjects.getLength();
        int objectsCount = 0;
        for (int i = 0; i < elemCount; ++i) {
            Node node = confObjects.item(i);
            if (!(node instanceof Element)) continue;
            ++objectsCount;
        }
        if (folderIds != null && folderIds.length != objectsCount) {
            this.log.warn((Object)"folderDbid array size does not match received objects list - skipping folderDbid's");
            folderIds = null;
        }
        if (pathes != null && pathes.length != objectsCount) {
            this.log.warn((Object)"objectPaths array size does not match received objects list - skipping objectPaths");
            pathes = null;
        }
        int objIdx = 0;
        ArrayList<ICfgObject> result = new ArrayList<ICfgObject>(objectsCount);
        for (int i = 0; i < elemCount; ++i) {
            Node node = confObjects.item(i);
            if (!(node instanceof Element)) continue;
            int objFolderDbid = 0;
            String objPath = null;
            if (folderIds != null && objIdx < folderIds.length) {
                objFolderDbid = folderIds[objIdx];
            }
            if (pathes != null && objIdx < pathes.length) {
                objPath = pathes[objIdx];
            }
            ICfgObject obj = this.createObjectFromXML(node, objPath, objFolderDbid, true);
            result.add(obj);
            ++objIdx;
        }
        return result;
    }

    public Collection<ICfgObject> createMultipleObjectsFromXML(Node confObjectsContainer) throws ConfigException {
        return this.createMultipleObjectsFromXML(confObjectsContainer, null, null);
    }

    public Collection<ICfgObject> createMultipleObjectsFromXML(NodeList confObjects) throws ConfigException {
        return this.createMultipleObjectsFromXML(confObjects, null, null);
    }

    protected Message prepareRequestReadObjectsMessage(ICfgQuery query) {
        if (query instanceof CfgXPathBasedQuery) {
            return RequestReadObjects2.create((Integer)((CfgXPathBasedQuery)query).getObjectType(), (String)((CfgXPathBasedQuery)query).getXPath());
        }
        int objType = CfgObjectType.CFGNoObject.ordinal();
        if (query instanceof ICfgFilterBasedQuery) {
            KeyValueCollection objectFilter = this.prepareReadObjectsFilter((ICfgFilterBasedQuery)query);
            objType = ((ICfgFilterBasedQuery)query).getCfgObjectType().ordinal();
            return RequestReadObjects.create((Integer)objType, (KeyValueCollection)objectFilter);
        }
        throw new IllegalArgumentException("unsupported query type");
    }

    public Predicate<Message> getFilter() {
        return this.eventService.getFilter();
    }

    public void handle(Message obj) {
        this.eventService.handle(obj);
    }

    private void initLogging() {
        this.getLogger().info((Object)"COM Logging started.");
        if (this.getLogger().isInfo()) {
            this.getLogger().infoFormat("Protocol state: {0}", this.confProtocol != null ? this.getProtocol().getState() : null);
        }
    }

    private <T extends ICfgObject> void checkObjectClass(Class<T> cls, ICfgQuery query) throws ConfigException {
        CfgObjectType qotype = null;
        if (query instanceof CfgFilterBasedQuery) {
            qotype = ((CfgFilterBasedQuery)query).getCfgObjectType();
        } else if (query instanceof CfgXPathBasedQuery) {
            qotype = ((CfgXPathBasedQuery)query).getCfgObjectType();
        } else {
            throw new IllegalArgumentException("unsupported query type");
        }
        if (qotype != null) {
            Field typeField = null;
            CfgObjectType objtype = null;
            try {
                typeField = cls.getDeclaredField("OBJECT_TYPE");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (typeField != null) {
                try {
                    objtype = (CfgObjectType)typeField.get(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (objtype != null && objtype != qotype) {
                throw new ConfigException("Incompatible result and query types");
            }
        }
    }

    private class COMMessageHandler
    implements MessageHandler {
        private COMMessageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            if (!ConfService.this.isDisposed) {
                try {
                    ConfService.this.eventService.handle(message);
                }
                catch (Exception ex) {
                    ConfService.this.log.error((Object)"Exception incoming message handling in the COM EventService", (Throwable)ex);
                }
                finally {
                    MessageHandler userHndl = ConfService.this.userMessageHandler;
                    if (userHndl != null) {
                        try {
                            userHndl.onMessage(message);
                        }
                        catch (Exception ex) {
                            ConfService.this.log.error((Object)"Exception incoming message handling in User MessageHandler", (Throwable)ex);
                        }
                    }
                }
            }
        }
    }
}

