/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBlockEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBody;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.OnExpandAnyHandler;
import java.util.ArrayList;

abstract class AbstractRule
implements Cloneable {
    AbstractRule Parent;
    private ArrayList<OnExpandAnyHandler> OnExpandAnyHandlers = new ArrayList();

    AbstractRule(AbstractRule parent) {
        this.Parent = parent;
    }

    public AbstractRule getParent() {
        return this.Parent;
    }

    public void registerOnExpandAny(OnExpandAnyHandler handler) throws CapacityRuleException {
        if (handler == null) {
            throw new CapacityRuleException("null handler argument");
        }
        if (!this.OnExpandAnyHandlers.contains(handler)) {
            this.OnExpandAnyHandlers.add(handler);
        }
    }

    public void invokeOnExpandAnyHandlers(AbstractRule source, CRMediaMap map, int capacity) throws CapacityRuleException {
        for (OnExpandAnyHandler handler : this.OnExpandAnyHandlers) {
            handler.onExpandAnyHandler(source, map, capacity);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractRule o = (AbstractRule)super.clone();
        o.OnExpandAnyHandlers = new ArrayList();
        return o;
    }

    public abstract void assignMediaTypes(CRMediaMap var1) throws CapacityRuleException;

    public abstract void expandAny(CRMediaMap var1) throws CapacityRuleException;

    public abstract boolean calculate(byte[] var1);

    public abstract CRRuleBody createBinaryStructure(CRRuleBlockEntry var1) throws CapacityRuleException;
}

