/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CRAndExprBlock;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleAbstractElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleWriter;
import java.nio.ByteBuffer;

final class CRElemExpr
extends CapacityRuleAbstractElement {
    private CRAndExprBlock Parent;
    int mediaType;
    int capacity;

    public CRElemExpr(CRAndExprBlock parent) {
        this.Parent = parent;
    }

    public CRElemExpr(CRAndExprBlock ab, int capacity, int mediaType) throws CapacityRuleException {
        if (mediaType < 0 || mediaType > 255) {
            throw new CapacityRuleException("invalid mediaType (0..255) : " + mediaType);
        }
        if (capacity < 1 || capacity > 255) {
            throw new CapacityRuleException("invalid capacity (1..255) : " + capacity);
        }
        this.mediaType = mediaType;
        this.capacity = capacity;
    }

    public CRElemExpr(CRAndExprBlock parent, ByteBuffer buf) {
        this(parent);
        this.read(buf);
    }

    public CRAndExprBlock getParent() {
        return this.Parent;
    }

    public void write(ICapacityRuleWriter writer) {
        writer.addByte((byte)this.mediaType);
        writer.addByte((byte)this.capacity);
    }

    private void read(ByteBuffer buf) {
        this.mediaType = buf.get() & 0xFF;
        this.capacity = buf.get() & 0xFF;
    }

    public int hashCode() {
        int h = CRElemExpr.class.hashCode();
        h = h * 31 + this.mediaType;
        h = h * 31 + this.capacity;
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CRElemExpr)) {
            return false;
        }
        CRElemExpr o = (CRElemExpr)obj;
        CRMediaMap map = this.getMap();
        CRMediaMap map2 = o.getMap();
        if (map != null && map2 != null && map != map2) {
            String mediaName1 = map.getEntries().get(this.mediaType).getMediaName();
            String mediaName2 = map2.getEntries().get(o.mediaType).getMediaName();
            if (mediaName1 == null || mediaName2 == null) {
                return false;
            }
            if (!mediaName1.equals(mediaName2)) {
                return false;
            }
        } else if (this.mediaType != o.mediaType) {
            return false;
        }
        return this.capacity == o.capacity;
    }

    private CRMediaMap getMap() {
        return this.Parent != null ? this.Parent.getMap() : null;
    }

    public String toString() {
        CRMediaMap map = this.getMap();
        return (map != null ? map.getEntries().get(this.mediaType).getMediaName() : "#" + this.mediaType) + ">" + this.capacity;
    }
}

