/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CRHeader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMapEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRXmlUtils;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleAbstractElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.EnterElementArgs;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleProcessElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleReader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleWriter;
import com.genesyslab.platform.applicationblocks.com.capacityrules.LeaveElementArgs;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CRMediaMap
extends CapacityRuleAbstractElement
implements ICapacityRuleProcessElement {
    static final String TAG_NAME = "MediaTypes";
    private CRHeader parent;
    private final List<CRMediaMapEntry> entries = new ArrayList<CRMediaMapEntry>();
    private final HashMap<String, Integer> simpleMap = new HashMap(0);

    public CRMediaMap(CRHeader parent) {
        this.parent = parent;
    }

    public CRMediaMap(CRHeader parent, ICapacityRuleReader reader) {
        this.parent = parent;
        reader.registerProcessElement(this);
    }

    public CRMediaMap(CRHeader parent, ByteBuffer buf, int positionBase) throws CapacityRuleException {
        this(parent);
        this.read(buf, positionBase);
    }

    public HashMap<String, Integer> getSimpleMediaMap() {
        return this.simpleMap;
    }

    @Override
    public CRHeader getParent() {
        return this.parent;
    }

    public int getMediaTypeCount() {
        return this.entries == null ? 0 : this.entries.size();
    }

    public List<CRMediaMapEntry> getEntries() {
        return this.entries;
    }

    public int getMediaType(String mediaName) throws CapacityRuleException {
        if (this.entries == null) {
            throw new CapacityRuleException("No media types in capacity rules");
        }
        for (CRMediaMapEntry entry : this.entries) {
            if (!entry.getMediaName().equalsIgnoreCase(mediaName)) continue;
            return entry.getMediaType();
        }
        throw new CapacityRuleException("Unknown media name: '" + mediaName + "'");
    }

    @Override
    public void onProcessElement(Object sender, Object args) throws CapacityRuleException {
        String localName;
        Object eargs;
        Element element;
        if (args instanceof EnterElementArgs && (element = ((EnterElementArgs)(eargs = (EnterElementArgs)args)).getElement()) != null && (localName = CRXmlUtils.getLocalName(element)).equalsIgnoreCase("Media")) {
            CRMediaMapEntry item = CRMediaMapEntry.create(this, element);
            this.add(item);
        }
        if (args instanceof LeaveElementArgs && (element = ((LeaveElementArgs)(eargs = (LeaveElementArgs)args)).getElement()) != null && element.getLocalName().equalsIgnoreCase(TAG_NAME) && sender instanceof ICapacityRuleReader) {
            ((ICapacityRuleReader)sender).unregisterProcessElement(this);
        }
    }

    private void add(CRMediaMapEntry entry) throws CapacityRuleException {
        if (entry != null) {
            if (null != this.simpleMap.put(entry.getMediaName(), entry.getMediaType())) {
                throw new CapacityRuleException("duplicate media map entry : " + entry.getMediaName());
            }
            this.entries.add(entry);
        }
    }

    @Override
    public void write(ICapacityRuleWriter writer) {
        CRMediaMapEntry item;
        int i;
        if (this.entries == null) {
            return;
        }
        int count = this.entries.size();
        writer.addByte((byte)count);
        int offsetsTable = writer.size();
        for (i = 0; i < count; ++i) {
            item = this.entries.get(i);
            writer.addByte((byte)item.getMediaType());
            writer.addInt(-1);
        }
        for (i = 0; i < count; ++i) {
            item = this.entries.get(i);
            if (item == null) continue;
            writer.setInt(offsetsTable + i * 5 + 1, writer.size());
            item.write(writer);
        }
    }

    private void read(ByteBuffer buf, int positionBase) throws CapacityRuleException {
        int count = buf.get() & 0xFF;
        CRMediaMapEntry[] a = new CRMediaMapEntry[count];
        for (int index = 0; index < count; ++index) {
            CRMediaMapEntry entry;
            String mediaName;
            int mediaType = buf.get() & 0xFF;
            if (mediaType >= a.length) {
                throw new CapacityRuleException("invalid media rule type: " + mediaType + " ( index:" + index + " )");
            }
            if (a[mediaType] != null) {
                throw new CapacityRuleException("duplcate media rule type: " + mediaType + " ( index:" + index + " )");
            }
            int mediaOffset = buf.getInt() & Integer.MAX_VALUE;
            int posBackup = buf.position();
            try {
                buf.position(positionBase + mediaOffset);
            }
            catch (IllegalArgumentException e) {
                throw new CapacityRuleException("invalid media rule entry offset: " + mediaOffset + " ( index:" + index + " )");
            }
            try {
                mediaName = this.readZEString(buf);
            }
            catch (Throwable e) {
                throw new CapacityRuleException("fail read media rule name. mediaType=" + mediaOffset + " ( index:" + index + " )");
            }
            a[mediaType] = entry = new CRMediaMapEntry(this, mediaName, mediaType);
            this.add(entry);
            buf.position(posBackup);
        }
    }

    private String readZEString(ByteBuffer buf) {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = buf.get() & 0xFF) != 0) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    public String toString() {
        String leftMargin = "  ";
        StringBuilder sb = new StringBuilder();
        sb.append("  ").append("[CRMediaMap]\n");
        for (CRMediaMapEntry entry : this.entries) {
            sb.append("  ").append(" ").append(entry).append('\n');
        }
        return sb.toString();
    }

    public int hashCode() {
        int hashCode = CRMediaMap.class.hashCode();
        if (this.entries != null) {
            for (CRMediaMapEntry entry : this.entries) {
                hashCode ^= entry.getMediaName().hashCode();
            }
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CRMediaMap)) {
            return false;
        }
        CRMediaMap o = (CRMediaMap)obj;
        if (this.simpleMap != null) {
            if (this.simpleMap.size() != o.simpleMap.size()) {
                return false;
            }
            for (String key : this.simpleMap.keySet()) {
                if (o.simpleMap.containsKey(key)) continue;
                return false;
            }
        } else if (o.simpleMap != null) {
            return false;
        }
        return true;
    }
}

