/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaDirEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBlockEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleAbstractElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleReader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CRRuleBlock
extends CapacityRuleAbstractElement {
    private CRMediaDirEntry parent;
    private final ArrayList<CRRuleBlockEntry> list = new ArrayList();

    public CRRuleBlock(CRMediaDirEntry parent, ICapacityRuleReader reader, Element element) {
        this.parent = parent;
        this.addNewRule(reader, element);
    }

    public CRRuleBlock(CRMediaDirEntry parent, ByteBuffer buf, int positionBase) throws CapacityRuleException {
        this.parent = parent;
        this.read(buf, positionBase);
    }

    public List<CRRuleBlockEntry> getEntries() {
        return this.list;
    }

    public void addNewRule(ICapacityRuleReader reader, Element element) {
        String attrPiorityValue = element.getAttribute("priority");
        CRRuleBlockEntry ruleBlock = new CRRuleBlockEntry(this, reader, attrPiorityValue == null ? "" : attrPiorityValue);
        this.list.add(ruleBlock);
    }

    public void process(CRMediaMap map) throws CapacityRuleException {
        if (this.list != null) {
            for (CRRuleBlockEntry ruleBlockEntry : this.list) {
                ruleBlockEntry.process(map);
            }
        }
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public void write(ICapacityRuleWriter writer) {
        CRRuleBlockEntry item;
        int i;
        if (this.list == null) {
            return;
        }
        int count = this.list.size();
        writer.addByte((byte)count);
        int offsetsTable = writer.size();
        for (i = 0; i < count; ++i) {
            item = this.list.get(i);
            writer.addByte((byte)item.getPriority());
            writer.addInt(-1);
        }
        for (i = 0; i < count; ++i) {
            item = this.list.get(i);
            if (item == null) continue;
            writer.setInt(offsetsTable + i * 5 + 1, writer.size());
            item.write(writer);
        }
    }

    private void read(ByteBuffer buf, int positionBase) throws CapacityRuleException {
        int count = buf.get() & 0xFF;
        for (int i = 0; i < count; ++i) {
            int priority = buf.get() & 0xFF;
            int entryOffset = buf.getInt();
            int posBackup = buf.position();
            try {
                buf.position(positionBase + entryOffset);
            }
            catch (IllegalArgumentException e) {
                throw new CapacityRuleException("invalid rule block entry offset : " + entryOffset + " ( index:" + i + " )");
            }
            this.list.add(new CRRuleBlockEntry(this, priority, buf, positionBase));
            buf.position(posBackup);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.list != null) {
            for (CRRuleBlockEntry item : this.list) {
                sb.append(" ").append(item).append("\n");
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int hashCode = CRRuleBlock.class.hashCode();
        for (CRRuleBlockEntry entry : this.list) {
            hashCode = hashCode * 31 + entry.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CRRuleBlock)) {
            return false;
        }
        CRRuleBlock o = (CRRuleBlock)obj;
        if (this.list.size() != o.list.size()) {
            return false;
        }
        ArrayList tmp = (ArrayList)o.list.clone();
        block0: for (CRRuleBlockEntry entry : this.list) {
            int size = tmp.size();
            for (int j = 0; j < size; ++j) {
                CRRuleBlockEntry entry2 = (CRRuleBlockEntry)tmp.get(j);
                if (!entry.equals(entry2)) continue;
                tmp.remove(j);
                continue block0;
            }
            return false;
        }
        return true;
    }

    public CRMediaMap getMap() {
        return this.parent != null ? this.parent.getMap() : null;
    }

    public boolean match(CRRuleBlock ruleBlock) {
        if (ruleBlock == null) {
            return false;
        }
        if (this.list.size() != ruleBlock.list.size()) {
            return false;
        }
        ArrayList tmp = (ArrayList)ruleBlock.list.clone();
        block0: for (CRRuleBlockEntry entry : this.list) {
            int size = tmp.size();
            for (int j = 0; j < size; ++j) {
                CRRuleBlockEntry entry2 = (CRRuleBlockEntry)tmp.get(j);
                if (!entry.match(entry2)) continue;
                tmp.remove(j);
                continue block0;
            }
            return false;
        }
        return true;
    }
}

