/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.EnterElementArgs;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleProcessElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleReader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.LeaveElementArgs;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class CapacityRuleReader
implements ICapacityRuleReader {
    static final ILogger log = Log.getLogger(CapacityRuleReader.class);
    private Document document;
    private final List<ICapacityRuleProcessElement> eventHandlers = new ArrayList<ICapacityRuleProcessElement>();

    CapacityRuleReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProcessElement(ICapacityRuleProcessElement processElement) {
        List<ICapacityRuleProcessElement> list = this.eventHandlers;
        synchronized (list) {
            if (!this.eventHandlers.contains(processElement)) {
                this.eventHandlers.add(processElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterProcessElement(ICapacityRuleProcessElement processElement) {
        List<ICapacityRuleProcessElement> list = this.eventHandlers;
        synchronized (list) {
            this.eventHandlers.remove(processElement);
        }
    }

    public void process() throws CapacityRuleException {
        if (this.document == null) {
            throw new IllegalStateException("source not assigned");
        }
        Element documentElement = this.document.getDocumentElement();
        if (documentElement == null || !documentElement.getNodeName().equalsIgnoreCase("CapacityRule")) {
            return;
        }
        this.processNode(documentElement);
    }

    public ICapacityRuleReader setSource(Object source) throws CapacityRuleException {
        if (!(source instanceof Document)) {
            throw new CapacityRuleException("Illegal source : " + source);
        }
        this.document = (Document)source;
        return this;
    }

    private void processNode(Node node) throws CapacityRuleException {
        if (node == null) {
            return;
        }
        if (!(node instanceof Element)) {
            return;
        }
        Element element = (Element)node;
        EnterElementArgs args = new EnterElementArgs(element);
        this.invokeHandlers(this, args);
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            this.processNode(child);
        }
        LeaveElementArgs lArgs = new LeaveElementArgs(element);
        this.invokeHandlers(this, lArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeHandlers(CapacityRuleReader sender, Object args) throws CapacityRuleException {
        ICapacityRuleProcessElement[] handlers;
        List<ICapacityRuleProcessElement> list = this.eventHandlers;
        synchronized (list) {
            handlers = new ICapacityRuleProcessElement[this.eventHandlers.size()];
            this.eventHandlers.toArray(handlers);
        }
        for (ICapacityRuleProcessElement handler : handlers) {
            handler.onProcessElement(sender, args);
        }
    }
}

