/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.AbstractRule;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRAndExprBlock;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRElemExpr;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMapEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBlockEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBody;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ElementaryRule;
import java.util.ArrayList;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComplexCondition
extends AbstractRule {
    private final String ATTR_CONDITION_TYPE = "type";
    private ConditionType Condition;
    private ArrayList<AbstractRule> ChildRules;

    public ComplexCondition(AbstractRule parent, ConditionType condition) {
        super(parent);
        this.Condition = condition;
        this.ChildRules = new ArrayList();
    }

    public ComplexCondition(AbstractRule parent, ConditionType condition, int capacity) {
        super(parent);
        this.Condition = condition;
        this.ChildRules = new ArrayList(capacity);
    }

    public ComplexCondition(AbstractRule parent, Element element) throws CapacityRuleException {
        super(parent);
        String sCondition = element.getAttribute("type");
        try {
            this.Condition = ConditionType.valueOf(sCondition.toUpperCase());
            if (this.Condition != null) {
                this.ChildRules = new ArrayList();
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new CapacityRuleException("Capacity rule XML contains invalid attribute value. Attribute 'type value ='" + (Object)((Object)this.Condition) + "'");
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        ComplexCondition o = (ComplexCondition)super.clone();
        o.ChildRules = new ArrayList();
        for (AbstractRule childRule : this.ChildRules) {
            o.ChildRules.add((AbstractRule)childRule.clone());
        }
        return o;
    }

    public ConditionType getContrCondition() {
        switch (this.Condition) {
            case OR: {
                return ConditionType.AND;
            }
            case AND: {
                return ConditionType.OR;
            }
        }
        return null;
    }

    public ConditionType getCondition() {
        return this.Condition;
    }

    public void setCondition(ConditionType condition) {
        this.Condition = condition;
    }

    public ArrayList<AbstractRule> getChildRules() {
        return this.ChildRules;
    }

    public AbstractRule addRule(AbstractRule rule) {
        if (rule == this) {
            boolean bl = true;
        }
        this.ChildRules.add(rule);
        return this;
    }

    public AbstractRule addRuleAt(AbstractRule rule, int index) {
        this.ChildRules.add(index, rule);
        return this;
    }

    public AbstractRule removeRule(AbstractRule rule) {
        this.ChildRules.remove(rule);
        return this;
    }

    public AbstractRule removeRule(int index) {
        this.ChildRules.remove(index);
        return this;
    }

    @Override
    public void assignMediaTypes(CRMediaMap map) throws CapacityRuleException {
        if (this.ChildRules == null) {
            return;
        }
        for (AbstractRule childRule : this.ChildRules) {
            childRule.assignMediaTypes(map);
        }
    }

    @Override
    public void expandAny(CRMediaMap map) throws CapacityRuleException {
        if (this.ChildRules == null) {
            return;
        }
        for (AbstractRule childRule : this.ChildRules.toArray(new AbstractRule[this.ChildRules.size()])) {
            childRule.expandAny(map);
        }
    }

    @Override
    public boolean calculate(byte[] values) {
        boolean result;
        boolean bl = result = this.Condition == ConditionType.AND;
        if (this.ChildRules == null) {
            return result;
        }
        for (AbstractRule rule : this.ChildRules) {
            if (this.Condition == ConditionType.AND) {
                result &= rule.calculate(values);
                continue;
            }
            result |= rule.calculate(values);
        }
        return result;
    }

    @Override
    public CRRuleBody createBinaryStructure(CRRuleBlockEntry parent) throws CapacityRuleException {
        CRRuleBody body = new CRRuleBody(parent);
        for (AbstractRule childRule : this.ChildRules) {
            CRAndExprBlock ab = new CRAndExprBlock(body);
            if (childRule instanceof ComplexCondition) {
                ComplexCondition crule = (ComplexCondition)childRule;
                for (AbstractRule rule : crule.getChildRules()) {
                    if (!(rule instanceof ElementaryRule)) continue;
                    ElementaryRule erule = (ElementaryRule)rule;
                    ab.add(new CRElemExpr(ab, erule.getCapacity(), erule.getMediaType()));
                }
            } else if (childRule instanceof ElementaryRule) {
                ElementaryRule erule = (ElementaryRule)childRule;
                ab.add(new CRElemExpr(ab, erule.getCapacity(), erule.getMediaType()));
            }
            body.add(ab);
        }
        return body;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.Condition.name());
        sb.append('(');
        for (AbstractRule rule : this.ChildRules) {
            sb.append(rule);
            sb.append(',');
        }
        if (!this.ChildRules.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(')');
        return sb.toString();
    }

    static ComplexCondition castOrNull(AbstractRule rule) {
        return rule instanceof ComplexCondition ? (ComplexCondition)rule : null;
    }

    public void add(CRAndExprBlock expr) throws CapacityRuleException {
        ComplexCondition and = new ComplexCondition((AbstractRule)this, ConditionType.AND);
        CRMediaMap map = expr.getMap();
        for (CRElemExpr op : expr.getList()) {
            CRMediaMapEntry mapEntry = map.getEntries().get(op.mediaType);
            and.addRule(new ElementaryRule(and, mapEntry.getMediaName(), op.mediaType, op.capacity));
            mapEntry.MaxCapacity = Math.max(op.capacity, mapEntry.MaxCapacity);
        }
        this.addRule(and);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConditionType {
        OR,
        AND,
        NOT;

    }
}

