/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.runtime;

import com.genesyslab.platform.applicationblocks.com.CfgObject;
import com.genesyslab.platform.applicationblocks.com.ConfService;
import com.genesyslab.platform.applicationblocks.com.ConfigException;
import com.genesyslab.platform.applicationblocks.com.ConfigServerException;
import com.genesyslab.platform.applicationblocks.com.ICfgObject;
import com.genesyslab.platform.applicationblocks.com.IConfService;
import com.genesyslab.platform.applicationblocks.com.IConfServicePolicy;
import com.genesyslab.platform.applicationblocks.com.NotificationQuery;
import com.genesyslab.platform.applicationblocks.com.Subscription;
import com.genesyslab.platform.applicationblocks.com.cache.IConfCache;
import com.genesyslab.platform.applicationblocks.com.runtime.SubscriptionImpl;
import com.genesyslab.platform.applicationblocks.com.runtime.XmlPermissionsHelper;
import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.Protocol;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventBriefInfo;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventError;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventNotificationRegistered;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventNotificationUnregistered;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectCreated;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectDeleted;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectPermissionsRead;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectUpdated;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectsRead;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventPermissionsRead;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventPermissionsUpdated;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestCreateObject;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestDeleteObject;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestRegisterNotification;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestUnregisterNotification;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestUpdateObject;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestReadObjectPermissions;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestReadPermissions;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestUpdatePermissions;
import com.genesyslab.platform.configuration.protocol.types.CfgErrorType;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectProperty;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlobalConfService {
    private static Hashtable<String, Integer> objectTypes;
    private static ILogger log;

    private GlobalConfService() {
    }

    static Integer getDBIDFromDeltaDoc(Document deltaDoc) {
        try {
            return Integer.parseInt(deltaDoc.getElementsByTagName("DBID").item(0).getAttributes().getNamedItem("value").getNodeValue());
        }
        catch (Exception ex) {
            log.error((Object)"Error looking DBID in document object", (Throwable)ex);
            return null;
        }
    }

    static Integer getDBIDFromObjectDoc(Document doc) {
        try {
            return Integer.parseInt(doc.getElementsByTagName("DBID").item(0).getAttributes().getNamedItem("value").getNodeValue());
        }
        catch (Exception ex) {
            log.error((Object)"Error looking DBID in document object", (Throwable)ex);
            return null;
        }
    }

    static CfgObjectType getObjectTypeFromDelta(Document deltaDoc) {
        if (deltaDoc.getDocumentElement() == null || deltaDoc.getDocumentElement().getChildNodes().getLength() == 0) {
            throw new IllegalArgumentException();
        }
        return GlobalConfService.deltaNameToObjectType(deltaDoc.getDocumentElement().getChildNodes().item(0).getNodeName());
    }

    static CfgObjectType getObjectTypeFromDoc(Document doc) {
        if (doc.getDocumentElement() == null || doc.getDocumentElement().getChildNodes().getLength() == 0) {
            throw new IllegalArgumentException();
        }
        return GlobalConfService.nameToObjectType(doc.getDocumentElement().getChildNodes().item(0).getNodeName());
    }

    public static String objectTypeToName(CfgObjectType objType) {
        String tempString = objType.toString();
        tempString = tempString.replace("CFG", "Cfg");
        return tempString;
    }

    static String nameToDelta(String objName) {
        String deltaName = objName.substring(0, 3) + "Delta" + objName.substring(3);
        return deltaName;
    }

    static CfgObjectType shortNameToObjectType(String objName) {
        if (!objectTypes.containsKey(objName)) {
            throw new IllegalArgumentException();
        }
        return (CfgObjectType)CfgObjectType.getValue(CfgObjectType.class, (Integer)objectTypes.get(objName));
    }

    public static CfgObjectType nameToObjectType(String objName) {
        return GlobalConfService.shortNameToObjectType(objName.substring(3));
    }

    static CfgObjectType deltaNameToObjectType(String objName) {
        return GlobalConfService.shortNameToObjectType(objName.substring(8));
    }

    public static EventObjectCreated createObject(Protocol protocol, CfgObjectType objectType, Document deltaDoc, KeyValueCollection parameters) throws ConfigException {
        RequestCreateObject mes = RequestCreateObject.create((Integer)objectType.ordinal(), (Document)deltaDoc, (KeyValueCollection)parameters);
        try {
            Message myEvent = protocol.request((Message)mes);
            if (myEvent == null) {
                throw new ConfigException("Error occured when creating object! We received null event as a result.");
            }
            if (myEvent instanceof EventObjectCreated) {
                return (EventObjectCreated)myEvent;
            }
            if (myEvent instanceof EventError) {
                throw GlobalConfService.createConfigServerException((EventError)myEvent);
            }
            throw new ConfigException("Unknown response got when creating object! " + myEvent);
        }
        catch (ProtocolException ex) {
            throw new ConfigException("Protocol exception occured when creating object! ", ex);
        }
    }

    public static EventObjectUpdated updateObject(Protocol protocol, CfgObjectType objectType, Document deltaDoc, KeyValueCollection parameters) throws ConfigException {
        RequestUpdateObject mes = RequestUpdateObject.create((Integer)objectType.ordinal(), (Document)deltaDoc, (KeyValueCollection)parameters);
        try {
            Message myEvent = protocol.request((Message)mes);
            if (myEvent == null) {
                throw new ConfigException("Error occured when updating object! We received null event as a result.");
            }
            if (myEvent instanceof EventObjectUpdated) {
                return (EventObjectUpdated)myEvent;
            }
            if (myEvent instanceof EventError) {
                throw GlobalConfService.createConfigServerException((EventError)myEvent);
            }
            throw new ConfigException("Unknown response got when updating object! " + myEvent);
        }
        catch (ProtocolException ex) {
            throw new ConfigException("Protocol exception occured when updating object! " + (Object)((Object)ex));
        }
    }

    public static EventObjectDeleted deleteObject(Protocol protocol, CfgObjectType objectType, int objectDbid) throws ConfigException {
        RequestDeleteObject mes = RequestDeleteObject.create((Integer)objectType.ordinal(), (Integer)objectDbid);
        try {
            Message myEvent = protocol.request((Message)mes);
            if (myEvent == null) {
                throw new ConfigException("Error occured when deleting object! We received null event as a result.");
            }
            if (myEvent instanceof EventObjectDeleted) {
                return (EventObjectDeleted)myEvent;
            }
            if (myEvent instanceof EventError) {
                throw GlobalConfService.createConfigServerException((EventError)myEvent);
            }
            throw new ConfigException("Unknown response got when deleting object! " + myEvent);
        }
        catch (ProtocolException ex) {
            throw new ConfigException("Error occured when deleting object!", ex);
        }
    }

    static <T extends CfgObject> Collection<T> activateMultipleObjects(Class<T> cls, IConfService service, EventObjectsRead message) throws ConfigException {
        Collection<Object> result = null;
        if (message == null) {
            return result;
        }
        result = new ArrayList();
        Document confObject = message.getConfObject();
        if (confObject == null) {
            return result;
        }
        int objectsCount = confObject.getDocumentElement().getChildNodes().getLength();
        if (objectsCount == 0) {
            return result;
        }
        long[] foldersDbids = message.getFolderDbids();
        int[] iaFoldersDbids = null;
        if (foldersDbids != null) {
            iaFoldersDbids = new int[foldersDbids.length];
            for (int i = 0; i < iaFoldersDbids.length; ++i) {
                iaFoldersDbids[i] = (int)foldersDbids[i];
            }
        }
        String[] objectPaths = message.getObjectPaths();
        result = service.createMultipleObjectsFromXML(confObject.getDocumentElement(), objectPaths, iaFoldersDbids);
        for (CfgObject cfgObject : result) {
            if (log.isInfo() && cfgObject != null) {
                log.infoFormat("Retrieved object [{0}], dbid: [{1}]", (Object)new Object[]{cfgObject.getObjectType(), cfgObject.getObjectDbid()});
            }
            if (log.isDebug() && cfgObject != null) {
                log.debug((Object)("Object content: \r\n\r\n" + cfgObject));
            }
            GlobalConfService.addToCache(service, cfgObject);
        }
        return result;
    }

    static <T extends CfgObject> Collection<T> activateMultipleObjects(Class<T> cls, IConfService service, EventBriefInfo message) throws ConfigException {
        Document confObject;
        Collection<Object> result = null;
        if (message != null && (confObject = message.getBriefInfo()) != null) {
            result = new ArrayList();
            int objectsCount = confObject.getDocumentElement().getChildNodes().getLength();
            if (objectsCount > 0) {
                result = service.createMultipleObjectsFromXML(confObject.getDocumentElement(), null, null);
            }
        }
        return result;
    }

    public static Subscription subscribe(Protocol protocol, NotificationQuery query) throws ConfigException {
        KeyValueCollection objectFilter = new KeyValueCollection();
        Hashtable<String, Object> filter = query.getFilter();
        for (String key : filter.keySet()) {
            Object val = filter.get(key);
            if (val instanceof GEnum) {
                objectFilter.addObject(key, (Object)((GEnum)val).ordinal());
                continue;
            }
            objectFilter.addObject(key, val);
        }
        KeyValueCollection subscriptionFilter = new KeyValueCollection();
        subscriptionFilter.addList("subscription", objectFilter);
        RequestRegisterNotification registerNotification = RequestRegisterNotification.create((KeyValueCollection)subscriptionFilter);
        try {
            Message eventMessage = protocol.request((Message)registerNotification);
            if (eventMessage == null) {
                throw new ConfigException("Timeout waiting for the server response");
            }
            if (eventMessage instanceof EventNotificationRegistered) {
                return new SubscriptionImpl(query);
            }
            if (eventMessage instanceof EventError) {
                throw GlobalConfService.createConfigServerException((EventError)eventMessage);
            }
            log.error((Object)("Error on RegisterNotification: got unexpected " + eventMessage.toString()));
            throw new ConfigException("Error on RegisterNotification: got unexpected " + eventMessage.toString());
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"Exception on subscription request", (Throwable)ex);
            throw new ConfigException("Exception on subscription request", ex);
        }
    }

    public static void unsubscribe(Protocol protocol, Subscription subscription) throws ConfigException {
        KeyValueCollection objectFilter = new KeyValueCollection();
        Hashtable<String, Object> filter = subscription.getQuery().getFilter();
        for (String key : filter.keySet()) {
            Object val = filter.get(key);
            if (val instanceof GEnum) {
                objectFilter.addObject(key, (Object)((GEnum)val).ordinal());
                continue;
            }
            objectFilter.addObject(key, val);
        }
        KeyValueCollection subscriptionFilter = new KeyValueCollection();
        subscriptionFilter.addList("subscription", objectFilter);
        RequestUnregisterNotification unregisterNotification = RequestUnregisterNotification.create((KeyValueCollection)subscriptionFilter);
        try {
            Message eventMessage = protocol.request((Message)unregisterNotification);
            if (eventMessage == null) {
                throw new ConfigException("Timeout waiting for the server response");
            }
            if (!(eventMessage instanceof EventNotificationUnregistered)) {
                if (eventMessage instanceof EventError) {
                    throw GlobalConfService.createConfigServerException((EventError)eventMessage);
                }
                log.error((Object)("Error on UnregisterNotification: got unexpected " + eventMessage.toString()));
                throw new ConfigException("Error on UnregisterNotification: got unexpected " + eventMessage.toString());
            }
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"Exception on unsubscription request", (Throwable)ex);
            throw new ConfigException("Exception on unsubscription request", ex);
        }
    }

    public static Subscription subscribe(Protocol protocol, ICfgObject obj) throws ConfigException {
        NotificationQuery query = new NotificationQuery();
        query.setObjectDbid((Integer)obj.getProperty("DBID"));
        query.setObjectType(obj.getObjectType());
        return GlobalConfService.subscribe(protocol, query);
    }

    public static int readObjectPermissions(Protocol protocol, int objectDbid, CfgObjectType objectType, int accountDbid, CfgObjectType accountType) throws ConfigException {
        Document objectDoc = XmlPermissionsHelper.createPermissionsObjectXml(objectDbid, objectType.ordinal());
        Document accountDoc = XmlPermissionsHelper.createPermissionsObjectXml(accountDbid, accountType.ordinal());
        RequestReadObjectPermissions mes = RequestReadObjectPermissions.create((Document)objectDoc, (Document)accountDoc);
        try {
            Message myEvent = protocol.request((Message)mes);
            if (myEvent == null) {
                throw new ConfigException("Timeout waiting for the server response");
            }
            if (myEvent instanceof EventObjectPermissionsRead) {
                EventObjectPermissionsRead realEvent = (EventObjectPermissionsRead)myEvent;
                return realEvent.getPermissions();
            }
            if (myEvent instanceof EventError) {
                throw GlobalConfService.createConfigServerException((EventError)myEvent);
            }
            throw new ConfigException("Received unknown event when reading permissions! " + myEvent);
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigException("Error occured when reading permissions!", ex);
        }
    }

    public static Document readPermissions(Protocol protocol, int objectDbid, CfgObjectType objectType) throws ConfigException {
        Document objectDoc = XmlPermissionsHelper.createPermissionsObjectXml(objectDbid, objectType.ordinal());
        RequestReadPermissions mes = RequestReadPermissions.create((Document)objectDoc);
        try {
            Message myEvent = protocol.request((Message)mes);
            if (myEvent == null) {
                throw new ConfigException("Timeout waiting for the server response");
            }
            if (myEvent instanceof EventPermissionsRead) {
                EventPermissionsRead realEvent = (EventPermissionsRead)myEvent;
                return realEvent.getConfPermissions();
            }
            if (myEvent instanceof EventError) {
                throw GlobalConfService.createConfigServerException((EventError)myEvent);
            }
            throw new ConfigException("Received unknown event when reading permissions! " + myEvent);
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigException("Error occured when reading permissions!", ex);
        }
    }

    public static EventPermissionsUpdated updatePermissions(Protocol protocol, int objectDbid, CfgObjectType objectType, int accountDbid, CfgObjectType accountType, int newPermissionsMask, int recursion) throws ConfigException {
        Document oldPermissionsDoc;
        Message myEvent;
        Document objectDoc = XmlPermissionsHelper.createPermissionsObjectXml(objectDbid, objectType.ordinal());
        try {
            myEvent = protocol.request((Message)RequestReadPermissions.create((Document)objectDoc));
            if (myEvent == null) {
                throw new ConfigException("Timeout waiting for the server response on read");
            }
            if (!(myEvent instanceof EventPermissionsRead)) {
                if (myEvent instanceof EventError) {
                    throw GlobalConfService.createConfigServerException((EventError)myEvent);
                }
                throw new ConfigException("Received unknown event when reading permissions! " + myEvent);
            }
            EventPermissionsRead realEvent = (EventPermissionsRead)myEvent;
            oldPermissionsDoc = realEvent.getConfPermissions();
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigException("Got Exception when reading permissions!", ex);
        }
        Document newDoc = XmlPermissionsHelper.createUpdateXml(oldPermissionsDoc, accountDbid, accountType.ordinal(), newPermissionsMask);
        if (newDoc == null) {
            log.debug((Object)"Permission update xml is null");
            return null;
        }
        try {
            myEvent = protocol.request((Message)RequestUpdatePermissions.create((Document)newDoc, (Integer)recursion));
            if (myEvent == null) {
                throw new ConfigException("Timeout waiting for the server response on update");
            }
            if (myEvent instanceof EventPermissionsUpdated) {
                return (EventPermissionsUpdated)myEvent;
            }
            if (myEvent instanceof EventError) {
                throw GlobalConfService.createConfigServerException((EventError)myEvent);
            }
            throw new ConfigException("Received unknown event when updating permissions! " + myEvent);
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigException("Got Exception when updating permissions!", ex);
        }
    }

    public static void removeAccount(Protocol protocol, int objectDbid, CfgObjectType objectType, int accountDbid, CfgObjectType accountType, int recursion) throws ConfigException {
        Document objectDoc = XmlPermissionsHelper.createPermissionsObjectXml(objectDbid, objectType.asInteger());
        RequestReadPermissions mes = RequestReadPermissions.create((Document)objectDoc);
        Message myEvent = null;
        try {
            myEvent = protocol.request((Message)mes);
        }
        catch (Exception e) {
            throw new ConfigException("Error occured when reading permissions during update!", e);
        }
        if (myEvent == null) {
            throw new ConfigException("Error occured when reading permissions during update! We received null event as a result.");
        }
        Document oldPermissionsDoc = null;
        if (!(myEvent instanceof EventPermissionsRead)) {
            throw new ConfigException("Received unknown event when reading permissions! MSG=" + mes);
        }
        oldPermissionsDoc = ((EventPermissionsRead)myEvent).getConfPermissions();
        Document newDoc = XmlPermissionsHelper.removeAccountFromPermissionsXml(oldPermissionsDoc, accountDbid, accountType.asInteger());
        if (newDoc == null) {
            return;
        }
        RequestUpdatePermissions messageUpdate = RequestUpdatePermissions.create((Document)newDoc, (Integer)recursion);
        try {
            myEvent = protocol.request((Message)messageUpdate);
        }
        catch (Exception e) {
            throw new ConfigException("Error occured when updating permissions!", e);
        }
        if (myEvent == null) {
            throw new ConfigException("Error occured when updating permissions! We received null event as a result.");
        }
        if (myEvent instanceof EventPermissionsUpdated) {
            return;
        }
        if (myEvent instanceof EventError) {
            throw GlobalConfService.createConfigServerException((EventError)myEvent);
        }
        throw new ConfigException("Received unknown event when updating permissions! MSG=" + mes);
    }

    public static ConfigServerException createConfigServerException(EventError eventError) {
        CfgErrorType errorType = (CfgErrorType)GEnum.getValue(CfgErrorType.class, (int)(eventError.getErrorCode() & 0xFF));
        CfgObjectType objType = (CfgObjectType)GEnum.getValue(CfgObjectType.class, (int)(eventError.getErrorCode() >> 8 & 0xFF));
        CfgObjectProperty property = (CfgObjectProperty)GEnum.getValue(CfgObjectProperty.class, (int)(eventError.getErrorCode() >> 16));
        String message = eventError.getDescription();
        return new ConfigServerException(errorType, objType, property, message);
    }

    public static void addToCache(IConfService service, ICfgObject obj) {
        block10: {
            if (service == null) {
                throw new NullPointerException("service");
            }
            IConfServicePolicy confPolicy = service.getPolicy();
            if (obj != null && confPolicy.getCacheOnRetrieve(obj)) {
                IConfCache confCache = service.getCache();
                if (confCache == null) {
                    throw new NullPointerException("confCache");
                }
                try {
                    if (confCache.contains(obj)) {
                        if (confPolicy.getOverwriteCachedVersionOnRetrieve(obj)) {
                            if (log.isDebug()) {
                                log.debugFormat("Updating object in cache [{0}], dbid: [{1}]", (Object)new Object[]{obj.getObjectType(), obj.getObjectDbid()});
                            }
                            confCache.update(obj);
                        }
                    } else {
                        if (log.isDebug()) {
                            log.debugFormat("Adding object to cache [{0}], dbid: [{1}]", (Object)new Object[]{obj.getObjectType(), obj.getObjectDbid()});
                        }
                        confCache.add(obj);
                    }
                }
                catch (Exception ex) {
                    if (!log.isDebug()) break block10;
                    log.debug((Object)("Error adding to cache [" + obj.getObjectType() + "], dbid: [" + obj.getObjectDbid() + "]"), (Throwable)ex);
                }
            }
        }
    }

    static {
        log = Log.getLogger(ConfService.class);
        objectTypes = new Hashtable();
        for (Object obj : CfgObjectType.values(CfgObjectType.class)) {
            CfgObjectType val = (CfgObjectType)obj;
            objectTypes.put(val.name().substring(3), val.ordinal());
        }
    }
}

