/*
 * Decompiled with CFR 0.152.
 */
package sample;

import com.genesyslab.platform.applicationblocks.com.ConfServiceFactory;
import com.genesyslab.platform.applicationblocks.com.IConfService;
import com.genesyslab.platform.applicationblocks.com.objects.CfgApplication;
import com.genesyslab.platform.applicationblocks.com.queries.CfgApplicationQuery;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.Protocol;
import com.genesyslab.platform.configuration.protocol.ConfServerProtocol;
import com.genesyslab.platform.configuration.protocol.types.CfgAppType;

public class ConfigurationAccessor {
    private String cfgHost;
    private int cfgPort;
    private String userName;
    private String password;
    private String clientName;
    private Integer clientType;
    private IConfService confService;

    private ConfServerProtocol GetProtocol() {
        Endpoint desc = new Endpoint(this.cfgHost, this.cfgPort);
        ConfServerProtocol confProtocol = new ConfServerProtocol(desc);
        confProtocol.setClientApplicationType(this.clientType);
        confProtocol.setClientName(this.clientName);
        confProtocol.setUserName(this.userName);
        confProtocol.setUserPassword(this.password);
        return confProtocol;
    }

    public ChannelState getChannelState() {
        ConfServerProtocol protocol = (ConfServerProtocol)this.confService.getProtocol();
        return protocol == null ? ChannelState.Closed : protocol.getState();
    }

    public void Connect() throws Exception {
        ConfServerProtocol protocol = this.GetProtocol();
        this.confService = ConfServiceFactory.createConfService((Protocol)protocol);
        try {
            protocol.open();
        }
        catch (Exception ex) {
            throw new Exception("Cannot connect to the configuration server (" + ex.getMessage() + ").");
        }
    }

    public void Initialize(String host, int port, String UserName, String UserPwd, String clientName) throws Exception {
        this.cfgHost = host;
        this.cfgPort = port;
        this.userName = UserName;
        this.password = UserPwd;
        this.clientName = clientName;
        this.clientType = CfgAppType.CFGGenericServer.ordinal();
    }

    public void Disconnect() throws Exception {
        if (this.confService != null) {
            Protocol protocol = this.confService.getProtocol();
            if (protocol != null && protocol.getState() != ChannelState.Closed) {
                protocol.close();
            }
            ConfServiceFactory.releaseConfService(this.confService);
        }
    }

    public CfgApplication RetrieveApplication(String appName) throws Exception {
        CfgApplicationQuery query = new CfgApplicationQuery();
        query.setName(appName);
        return this.confService.retrieveObject(CfgApplication.class, query);
    }
}

