/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.ConnectionContext;
import com.genesyslab.platform.commons.connection.configuration.ServerContext;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.AsyncInvokerSupport;
import com.genesyslab.platform.commons.protocol.Channel;
import com.genesyslab.platform.commons.protocol.ChannelClosedEvent;
import com.genesyslab.platform.commons.protocol.ChannelClosedOnCloseException;
import com.genesyslab.platform.commons.protocol.ChannelClosedOnSendException;
import com.genesyslab.platform.commons.protocol.ChannelErrorEvent;
import com.genesyslab.platform.commons.protocol.ChannelListener;
import com.genesyslab.platform.commons.protocol.ChannelNotClosedException;
import com.genesyslab.platform.commons.protocol.ChannelNotOpenedException;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.ConfigurationSupport;
import com.genesyslab.platform.commons.protocol.ConnectionInvokerSupport;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.EndpointSupport;
import com.genesyslab.platform.commons.protocol.Listener;
import com.genesyslab.platform.commons.protocol.ListenerHelper;
import com.genesyslab.platform.commons.protocol.NoChannelEndpointException;
import com.genesyslab.platform.commons.protocol.runtime.AbstractContextImpl;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.threading.InvokerFactory;
import com.genesyslab.platform.commons.timer.TimerFactory;
import java.util.EventObject;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChannel
implements Channel,
ConfigurationSupport,
EndpointSupport,
AsyncInvokerSupport,
ConnectionInvokerSupport {
    private static final ILogger log = Log.getLogger(AbstractChannel.class);
    private ChannelState state = ChannelState.Closed;
    private final Object stateGuard = new Object();
    private long timeout;
    private ListenerHelper listenerHelper = new ListenerHelper();
    private AsyncInvoker invoker;
    private AsyncInvoker connectionInvoker;
    private AsyncInvoker externalConnectionInvoker;
    private static final String DEFAULT_INVOKER_NAME = "default";
    private static final String CONN_INVOKER_NAME = "connection";
    private AsyncInvoker defInvoker = null;
    private Endpoint endpoint;
    private final int thisChannelId = AbstractChannel.generateChannelId();
    private final ChannelContextImpl context = new ChannelContextImpl(this);
    private static final AtomicInteger lastChannelId;

    protected AbstractChannel(long timeout, Endpoint endpoint) {
        this.timeout = timeout;
        try {
            this.endpoint = (Endpoint)(endpoint == null ? null : endpoint.clone());
        }
        catch (CloneNotSupportedException e) {
            this.endpoint = endpoint;
        }
        this.copyTLSSettings(endpoint);
    }

    public int getChannelId() {
        return this.thisChannelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelState getState() {
        Object object = this.stateGuard;
        synchronized (object) {
            return this.state;
        }
    }

    public ConnectionContext<? extends ServerContext> connectionContext() {
        return this.context;
    }

    public ServerContext getServerContext() {
        return this.context.serverContext();
    }

    @Override
    public void setTimeout(long timeout) {
        if (log.isDebug()) {
            log.debugFormat("Setting timeout to {0} ms.", (Object)timeout);
        }
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void addChannelListener(ChannelListener listener) {
        this.listenerHelper.addListener(listener);
    }

    @Override
    public void removeChannelListener(ChannelListener listener) {
        this.listenerHelper.removeListener(listener);
    }

    @Override
    public void setInvoker(AsyncInvoker invoker) {
        this.invoker = invoker;
        if (invoker != null) {
            this.releaseDefaultInvoker();
        }
    }

    @Override
    @Deprecated
    public void setConnectionInvoker(AsyncInvoker connectionInvoker) {
        if (this.connectionInvoker == connectionInvoker) {
            return;
        }
        if (null != this.connectionInvoker && this.connectionInvoker != this.externalConnectionInvoker) {
            this.releaseDefaultConnInvoker();
        }
        this.externalConnectionInvoker = connectionInvoker;
        this.doSetConnectionInvoker(connectionInvoker);
    }

    protected void assignConnectionInvoker(Connection newConnection) {
        newConnection.setInvoker(this.getConnectionInvoker());
    }

    protected void doSetConnectionInvoker(AsyncInvoker connectionInvoker) {
        log.debugFormat("Setting connInvoker {0} for {1}", (Object)new Object[]{connectionInvoker, this});
        this.connectionInvoker = connectionInvoker;
    }

    @Override
    @Deprecated
    public ConnectionConfiguration getConfiguration() {
        if (this.endpoint != null) {
            return this.endpoint.getConfiguration();
        }
        return null;
    }

    @Override
    @Deprecated
    public void configure(ConnectionConfiguration config) {
        this.setConfiguration(config);
        if (this.getState() == ChannelState.Opened) {
            this.applyConfiguration();
        }
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setEndpoint(Endpoint endpoint) {
        this.throwNotClosed();
        try {
            this.endpoint = (Endpoint)(endpoint == null ? null : endpoint.clone());
        }
        catch (CloneNotSupportedException e) {
            this.endpoint = endpoint;
        }
        this.copyTLSSettings(endpoint);
    }

    protected void copyTLSSettings(Endpoint endpoint) {
        if (null == endpoint) {
            this.context.setAttribute("com.genesyslab.platform.commons.connection.SSLContext", null);
            this.context.setAttribute("com.genesyslab.platform.commons.connection.SSLExtendedOptions", null);
        } else {
            this.context.setAttribute("com.genesyslab.platform.commons.connection.SSLContext", endpoint.getSSLContext());
            this.context.setAttribute("com.genesyslab.platform.commons.connection.SSLExtendedOptions", endpoint.getSSLOptions());
        }
    }

    protected AsyncInvoker defaultConnectionInvoker() {
        return InvokerFactory.namedInvoker((String)CONN_INVOKER_NAME);
    }

    protected void releaseDefaultConnInvoker() {
        InvokerFactory.releaseInvoker((String)CONN_INVOKER_NAME);
    }

    protected void releaseConnectionInvoker() {
        if (null != this.connectionInvoker && this.connectionInvoker != this.externalConnectionInvoker) {
            this.releaseDefaultConnInvoker();
        }
        this.doSetConnectionInvoker(null);
    }

    protected void setState(ChannelState state) {
        this.setState(state, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(ChannelState state, ConnectionClosedEvent closedEvent) {
        ChannelState prevState;
        if (log.isDebug()) {
            log.debug((Object)("Channel state transition: " + (Object)((Object)this.state) + "->" + (Object)((Object)state)));
        }
        Object object = this.stateGuard;
        synchronized (object) {
            if (state == this.state) {
                return;
            }
            prevState = this.state;
            this.state = state;
        }
        if (state == ChannelState.Closed) {
            Throwable cause = null;
            if (closedEvent != null) {
                cause = closedEvent.getCause();
            }
            this.fireClosed(new ChannelClosedEvent((Channel)this, cause, prevState));
        } else if (state == ChannelState.Opened) {
            this.fireOpened();
        }
    }

    protected final void setServerContext(ServerContext serverContext) {
        this.context.setServerContext(serverContext);
    }

    private static int generateChannelId() {
        return lastChannelId.incrementAndGet();
    }

    protected void throwNull(Object o, String name) {
        if (o == null) {
            throw new IllegalArgumentException("Null pointer: '" + name);
        }
    }

    protected void throwNullEndpoint() {
        this.throwNull(this.endpoint, "endpoint");
    }

    protected void throwNotOpenedOnSend() throws ChannelClosedOnSendException {
        if (this.getState() != ChannelState.Opened) {
            throw new ChannelClosedOnSendException("Connection is not opened");
        }
    }

    protected void throwNotClosed() throws IllegalStateException {
        if (this.getState() != ChannelState.Closed) {
            throw new ChannelNotClosedException("Operation is not allowed on non closed channel");
        }
    }

    protected void throwNotOpened() throws IllegalStateException {
        if (this.getState() != ChannelState.Opened) {
            throw new ChannelNotOpenedException("Connection is not opened");
        }
    }

    protected void throwNotOpenedOnClose() throws IllegalStateException {
        if (this.getState() != ChannelState.Opened) {
            throw new ChannelClosedOnCloseException("Connection is not opened");
        }
    }

    private void fireOpened() {
        log.debug((Object)"Firing 'onChannelOpened'");
        this.getInvoker().invoke((Runnable)new ChanelOpenVisitor());
    }

    private void fireClosed(ChannelClosedEvent event) {
        log.infoFormat("Channel closed: {0}", (Object)event);
        log.debug((Object)"Firing 'onChannelClosed'");
        this.getInvoker().invoke((Runnable)new ChanelClosedVisitor(event));
        this.releaseDefaultInvoker();
        this.releaseConnectionInvoker();
    }

    protected void fireClosed(Throwable reason, ChannelState prevState) {
        if (log.isDebug()) {
            log.debug((Object)"Firing 'onChannelClosed'");
        }
        ChannelClosedEvent event = new ChannelClosedEvent((Channel)this, reason, prevState);
        this.getInvoker().invoke((Runnable)new ChanelClosedVisitor(event));
        this.releaseDefaultInvoker();
        this.releaseConnectionInvoker();
    }

    protected ListenerHelper getListenerHelper() {
        return this.listenerHelper;
    }

    protected abstract void applyConfiguration();

    protected AsyncInvoker getInvoker() {
        if (this.invoker == null) {
            return this.getDefaultInvoker();
        }
        return this.invoker;
    }

    protected AsyncInvoker getConnectionInvoker() {
        if (null == this.connectionInvoker) {
            this.connectionInvoker = this.defaultConnectionInvoker();
        }
        return this.connectionInvoker;
    }

    protected AsyncInvoker getDefaultInvoker() {
        if (this.defInvoker == null) {
            this.defInvoker = InvokerFactory.namedInvoker((String)DEFAULT_INVOKER_NAME);
        }
        return this.defInvoker;
    }

    protected void releaseDefaultInvoker() {
        if (this.defInvoker != null) {
            InvokerFactory.releaseInvoker((String)DEFAULT_INVOKER_NAME);
            this.defInvoker = null;
        }
    }

    protected void setConfiguration(ConnectionConfiguration config) {
        if (this.endpoint == null) {
            throw new NoChannelEndpointException("The Channel does not have Endpoint instance initialized");
        }
        this.endpoint.setConfiguration(config);
    }

    protected void fireErrorEvent(Throwable exception) {
        ChannelErrorEvent event = new ChannelErrorEvent(this, exception);
        this.fireErrorEvent(event);
    }

    protected void fireErrorEvent(ChannelErrorEvent event) {
        this.throwNull(event, "event");
        this.getInvoker().invoke((Runnable)new AsyncErrorNotifier(event));
    }

    static {
        TimerFactory.getTimer();
        lastChannelId = new AtomicInteger(Math.abs((int)System.currentTimeMillis()));
    }

    protected class AsyncErrorNotifier
    implements Runnable,
    ListenerHelper.NotificationVisitor {
        private ChannelErrorEvent event;

        public AsyncErrorNotifier(ChannelErrorEvent event) {
            this.event = event;
        }

        public AsyncErrorNotifier(Throwable error) {
            this.event = new ChannelErrorEvent(AbstractChannel.this, error);
        }

        public void run() {
            AbstractChannel.this.getListenerHelper().notifyListeners(this);
        }

        public void visitListener(Listener listener) {
            ((ChannelListener)listener).onChannelError(this.event);
        }
    }

    private class ChanelClosedVisitor
    extends AsyncVisitor {
        private ChannelClosedEvent event;

        public ChanelClosedVisitor(ChannelClosedEvent event) {
            this.event = event;
        }

        public void visitListener(Listener listener) {
            ChannelListener chL = (ChannelListener)listener;
            chL.onChannelClosed(this.event);
        }
    }

    private class ChanelOpenVisitor
    extends AsyncVisitor {
        private ChanelOpenVisitor() {
        }

        public void visitListener(Listener listener) {
            ChannelListener chL = (ChannelListener)listener;
            chL.onChannelOpened(new EventObject(AbstractChannel.this));
        }
    }

    private abstract class AsyncVisitor
    implements ListenerHelper.NotificationVisitor,
    Runnable {
        private AsyncVisitor() {
        }

        public void run() {
            AbstractChannel.this.listenerHelper.notifyListeners(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChannelContextImpl
    extends AbstractContextImpl<ServerContext> {
        private ServerContext serverContext = null;

        public ChannelContextImpl(AbstractChannel channel) {
            super(channel);
        }

        @Override
        public ServerContext serverContext() {
            return this.serverContext;
        }

        private void setServerContext(ServerContext newServerContext) {
            this.serverContext = newServerContext;
        }
    }
}

