/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.tls.SSLExtendedOptions;
import com.genesyslab.platform.commons.protocol.Endpoint;
import java.net.URI;
import javax.net.ssl.SSLContext;

public class WildcardEndpoint
extends Endpoint {
    public WildcardEndpoint(int port) {
        this(null, port);
    }

    public WildcardEndpoint(String name, int port) {
        super(name);
        this.validatePort(port);
        this.setEndpointName(name, null, port);
        this.host = null;
        this.port = port;
    }

    public WildcardEndpoint(int port, ConnectionConfiguration connConf) {
        this(null, port, connConf);
    }

    public WildcardEndpoint(String name, int port, ConnectionConfiguration connConf) {
        this(name, port);
        this.setConfiguration(connConf);
    }

    public WildcardEndpoint(int port, ConnectionConfiguration connConf, boolean tlsEnabled, SSLContext sslContext, SSLExtendedOptions sslOptions) {
        this(null, port, connConf, tlsEnabled, sslContext, sslOptions);
    }

    public WildcardEndpoint(String name, int port, ConnectionConfiguration connConf, boolean tlsEnabled, SSLContext sslContext, SSLExtendedOptions sslOptions) {
        this(name, port, connConf);
        if (null == connConf) {
            throw new IllegalArgumentException("connConf must not be null");
        }
        this.connConfig.setBoolean("tls", tlsEnabled);
        this.sslContext = sslContext;
        this.sslOptions = sslOptions;
    }

    @Deprecated
    public URI getUri() {
        throw new UnsupportedOperationException("Wildcard address cannot be expressed as URI.");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.tostringPrefix != null && !this.tostringPrefix.equals("")) {
            buf.append(this.tostringPrefix).append(" - ");
        }
        buf.append("tcp://").append("[anylocal]").append(':').append(this.port);
        return buf.toString();
    }
}

