/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.auth;

import com.genesyslab.platform.commons.protocol.auth.KerberosUtil;
import java.security.PrivilegedExceptionAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AcceptKerberosTicketAction
implements PrivilegedExceptionAction<String> {
    private byte[] ticketBytes;
    private String servicePrincipalName;

    public AcceptKerberosTicketAction(byte[] ticketBytes, String servicePrincipalName) {
        if (null == ticketBytes) {
            throw new IllegalArgumentException("ticketBytes must not be null");
        }
        if (0 == ticketBytes.length) {
            throw new IllegalArgumentException("ticketBytes must not be empty");
        }
        this.ticketBytes = ticketBytes;
        if (null == servicePrincipalName) {
            throw new IllegalArgumentException("servicePrincipalName must not be null");
        }
        if (0 == servicePrincipalName.length()) {
            throw new IllegalArgumentException("servicePrincipalName must not be empty");
        }
        this.servicePrincipalName = servicePrincipalName;
    }

    @Override
    public String run() throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        GSSName serviceName = manager.createName(this.servicePrincipalName, KerberosUtil.getKerberosPrincipalNameOid());
        GSSCredential serviceCredentials = manager.createCredential(serviceName, Integer.MAX_VALUE, KerberosUtil.getKerberos5Oid(), 2);
        GSSContext context = manager.createContext(serviceCredentials);
        context.acceptSecContext(this.ticketBytes, 0, this.ticketBytes.length);
        if (context.isEstablished()) {
            return ((Object)context.getSrcName()).toString();
        }
        return null;
    }
}

