/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecLazyParsingAction;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.LazyParsingAction;
import com.genesyslab.platform.commons.protocol.runtime.PackagerLazyParsingAction;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomPackager;
import java.util.HashMap;
import java.util.Map;

public class CodecLazyParser {
    private static final ILogger log = Log.getLogger(CodecLazyParser.class);
    private final DataSupport message;
    private final Map<String, LazyParsingAction> lazyActions = new HashMap<String, LazyParsingAction>();

    public CodecLazyParser(DataSupport message) {
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String propName) {
        Map<String, LazyParsingAction> map = this.lazyActions;
        synchronized (map) {
            LazyParsingAction action = this.lazyActions.remove(propName);
            if (this.message.attributes().get(propName) != null) {
                action = null;
            }
            if (action != null) {
                try {
                    action.parse(this.message);
                }
                catch (CodecException e) {
                    log.error((Object)"Exception parsing attribute", (Throwable)((Object)e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(String propName, CustomPackager packager, AttributeDescription ai) {
        if (packager == null || ai == null) {
            return;
        }
        Map<String, LazyParsingAction> map = this.lazyActions;
        synchronized (map) {
            this.lazyActions.put(propName, new PackagerLazyParsingAction(packager, ai));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(String propName, AttributeTypeCodec codec, AttributeDescription ai, Object val) {
        if (codec == null || ai == null) {
            return;
        }
        Map<String, LazyParsingAction> map = this.lazyActions;
        synchronized (map) {
            this.lazyActions.put(propName, new CodecLazyParsingAction(codec, ai, val));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNotParsed() {
        String[] names = null;
        Map<String, LazyParsingAction> map = this.lazyActions;
        synchronized (map) {
            names = new String[this.lazyActions.size()];
            int i = 0;
            for (String key : this.lazyActions.keySet()) {
                names[i++] = key;
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeDescription getAttributeDescription(String name) {
        Map<String, LazyParsingAction> map = this.lazyActions;
        synchronized (map) {
            LazyParsingAction action = this.lazyActions.get(name);
            if (action != null) {
                return action.getAttributeDescription();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttribute(String name) {
        Map<String, LazyParsingAction> map = this.lazyActions;
        synchronized (map) {
            return this.lazyActions.containsKey(name);
        }
    }
}

