/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime;

import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecLazyParser;
import com.genesyslab.platform.commons.protocol.runtime.CompoundValue;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.MetaData;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.EnumCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class ToStringHelper {
    private ToStringHelper() {
    }

    public static String toString(Message msg) {
        return ToStringHelper.toString(msg, true, true);
    }

    public static String toString(Message msg, boolean hideAllowed, boolean truncate) {
        StringBuffer buf = new StringBuffer();
        try {
            ToStringContext ctx = new ToStringContext(buf, truncate, hideAllowed);
            ctx.msg = msg;
            ctx.dataSupport = ToStringHelper.asDataSupport(msg);
            ToStringHelper.appendMessageHead(ctx);
            ToStringHelper.toStringBuf(ctx);
        }
        catch (Exception e) {
            Log.getLogger(ToStringHelper.class).warn((Object)"Exception in toString()", (Throwable)e);
            buf.append("!!!EXCEPTION PARSING MESSAGE!!! (WRONG PROTOCOL?): ").append(e.toString());
        }
        return buf.toString();
    }

    public static String toString(CompoundValue val) {
        return ToStringHelper.toString(val, true, true);
    }

    public static String toString(CompoundValue val, boolean truncate, boolean hideAllowed) {
        return ToStringHelper.toString(val, truncate, hideAllowed, 0);
    }

    public static String toString(CompoundValue val, boolean truncate, boolean hideAllowed, int indent) {
        ToStringContext ctx = new ToStringContext(new StringBuffer(), truncate, hideAllowed);
        ctx.dataSupport = ToStringHelper.asDataSupport(val);
        ctx.indent = indent;
        ToStringHelper.toStringBuf(ctx);
        return ctx.buf.toString();
    }

    private static void toStringBuf(ToStringContext ctx) {
        DataSupport attrSet = ctx.dataSupport;
        MetaData meta = attrSet.getMetaData();
        if (attrSet instanceof CompoundValue) {
            ctx.buf.append(meta.getName()).append(':');
        }
        for (Map.Entry entry : attrSet.attributes().entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            AttributeDescription description = meta.getAttributeDescription(key);
            if (description != null && description.getName().equals(key)) {
                if (value instanceof CompoundValue) {
                    ctx.buf.append('\n');
                    ToStringHelper.appendIndent(ctx);
                    ctx.buf.append('\t').append(ToStringHelper.toString((CompoundValue)value, ctx.truncate, ctx.hideAllowed, ctx.indent + 1));
                    continue;
                }
                ToStringHelper.appendSimpleAttr(ctx, description, value);
                continue;
            }
            ToStringHelper.appendRawAttribute(ctx, key, value);
        }
        Collection values = attrSet.getCompounds().values();
        if (!values.isEmpty()) {
            ctx.incIndent();
            for (DataSupport ds : values) {
                if (ds == null) continue;
                ctx.dataSupport = ds;
                ctx.buf.append('\n');
                ToStringHelper.appendIndent(ctx);
                ToStringHelper.toStringBuf(ctx);
            }
            ctx.decIndent();
        }
        CodecLazyParser lazyParser = attrSet.getLazyParser();
        String[] lazyAttrs = null;
        if (lazyParser != null) {
            lazyAttrs = lazyParser.getNotParsed();
        }
        if (lazyAttrs != null) {
            for (String sName : lazyAttrs) {
                AttributeDescription description = lazyParser.getAttributeDescription(sName);
                if (description == null && (description = meta.getAttributeDescription(sName)) == null || ctx.hideAllowed && description.isHideable() && description.isHidden()) continue;
                ToStringHelper.appendLazyAttribute(ctx, description.getLogSignature());
            }
        }
    }

    private static void appendRawAttribute(ToStringContext ctx, String key, Object value) {
        ctx.buf.append('\n');
        ToStringHelper.appendIndent(ctx);
        ctx.buf.append('\t').append(key).append(" [").append(value.getClass().getSimpleName()).append("] <raw data attribute>");
    }

    private static void appendLazyAttribute(ToStringContext ctx, String key) {
        ctx.buf.append('\n');
        ToStringHelper.appendIndent(ctx);
        ctx.buf.append('\t').append(key).append(" <value is not yet parsed>");
    }

    private static void appendIndent(ToStringContext ctx) {
        if (ctx.indent > 0) {
            char[] indent = new char[ctx.indent];
            Arrays.fill(indent, '\t');
            ctx.buf.append(indent);
        }
    }

    private static void appendSimpleAttr(ToStringContext ctx, AttributeDescription key, Object value) {
        if (value == null || key.isHidden()) {
            return;
        }
        StringBuffer buf = ctx.buf;
        buf.append('\n');
        ToStringHelper.appendIndent(ctx);
        buf.append('\t');
        buf.append(key.getLogSignature()).append(" [");
        buf.append(ToStringHelper.getAttributeType(key)).append("] = ");
        try {
            ToStringHelper.appendAttributeValue(ctx, key, value);
        }
        catch (CodecException e) {
            Log.getLogger(ToStringHelper.class).debug((Object)"Codec exception", (Throwable)((Object)e));
            buf.append("<invalid message: ").append(e.getMessage()).append('>');
        }
    }

    private static void appendAttributeValue(ToStringContext ctx, AttributeDescription key, Object value) throws CodecException {
        StringBuffer buf = ctx.buf;
        if (value == null) {
            buf.append("<null>");
        } else {
            boolean hide = ctx.hideAllowed && key.isHideable();
            Class valueType = key.getValueType();
            CustomTypeCodec codec = key.createCodec(ctx.msg, null);
            if (hide) {
                buf.append("[output suppressed]");
            } else if (codec != null) {
                codec.appendLogValue(buf, value, ctx.truncate, ctx.hideAllowed);
            } else if (valueType == String.class) {
                buf.append('\"').append((String)value).append('\"');
            } else if (valueType == Integer.TYPE || valueType == Integer.class || valueType == Long.TYPE || valueType == Long.class) {
                buf.append(value);
            } else if (valueType == byte[].class) {
                CodecUtil.appendBytesStr(buf, (byte[])value, ctx.truncate);
            } else if (key.isEnumProperty()) {
                new EnumCodec().appendLogValue(buf, value, ctx.truncate, hide);
            } else {
                throw new IllegalArgumentException("Unsupported attribute type");
            }
        }
    }

    private static String getAttributeType(AttributeDescription key) {
        CustomTypeCodec codec = key.createCodec(null, null);
        if (codec != null) {
            return codec.getLogType();
        }
        Class valueType = key.getValueType();
        if (valueType == String.class) {
            return "str";
        }
        if (valueType == Integer.TYPE || valueType == Integer.class) {
            return "int";
        }
        if (valueType == byte[].class) {
            return "bstr";
        }
        if (key.isEnumProperty()) {
            return new EnumCodec().getLogType();
        }
        if (valueType == Long.TYPE || valueType == Long.class) {
            return "long";
        }
        throw new IllegalArgumentException("Unsupported attribute type");
    }

    private static void appendMessageHead(ToStringContext ctx) {
        ctx.buf.append('\'').append(ctx.msg.messageName()).append("' ").append('(').append(ctx.msg.messageId()).append(") attributes:");
    }

    private static DataSupport asDataSupport(Object attrCollection) {
        if (!(attrCollection instanceof DataSupport)) {
            throw new IllegalArgumentException("Wrong message, data support is absent. Use generated sources only");
        }
        return (DataSupport)attrCollection;
    }

    private static class ToStringContext {
        private StringBuffer buf;
        private boolean truncate;
        boolean hideAllowed;
        private Message msg;
        private DataSupport dataSupport;
        public int indent;

        private ToStringContext(StringBuffer buf, boolean truncate, boolean hideAllowed) {
            this.buf = buf;
            this.truncate = truncate;
            this.hideAllowed = hideAllowed;
        }

        public void incIndent() {
            ++this.indent;
        }

        public void decIndent() {
            if (--this.indent < 0) {
                this.indent = 0;
            }
        }
    }
}

