/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime.codec;

import com.genesyslab.platform.commons.collections.util.Hex;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.xml.XmlUtil;
import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import java.io.ByteArrayOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CodecUtil {
    public static final String VALUE_HIDDEN_PLACEHOLDER = "[output suppressed]";
    public static final String PSDK_COMMONS_NS = "http://schemas.genesyslab.com/Commons/2005/";

    private CodecUtil() {
    }

    public static void appendBytesStr(StringBuffer buf, byte[] bytes, boolean truncate) {
        Hex.appendBytesStr((StringBuffer)buf, (byte[])bytes, (boolean)truncate);
    }

    public static Element asElement(Source source) throws CodecException {
        DOMSource ds = null;
        try {
            ds = XmlUtil.asDomSource((Source)source);
        }
        catch (TransformerException e) {
            throw new CodecException("parser problems", e);
        }
        Node node = ds.getNode();
        Element elem = null;
        short nodeType = node.getNodeType();
        if (nodeType == 1) {
            elem = (Element)node;
        } else if (nodeType == 9) {
            elem = ((Document)node).getDocumentElement();
        } else {
            throw new CodecException("element or document expected");
        }
        return elem;
    }

    public static void appendText(String text, Result result) throws CodecException {
        if (result instanceof DOMResult) {
            Node node = ((DOMResult)result).getNode();
            Text textNode = node.getOwnerDocument().createTextNode(text);
            node.appendChild(textNode);
        } else {
            Document doc = CodecUtil.createDocument();
            DOMSource src = new DOMSource(doc.createTextNode(text));
            CodecUtil.transform(src, result);
        }
    }

    public static void setAttribute(String attrName, String attrValue, Result result) throws CodecException {
        if (result instanceof DOMResult) {
            Element node = (Element)((DOMResult)result).getNode();
            node.setAttribute(attrName, attrValue);
        } else {
            Document doc = CodecUtil.createDocument();
            Attr attribute = doc.createAttribute(attrName);
            attribute.setValue(attrValue);
            DOMSource src = new DOMSource(attribute);
            CodecUtil.transform(src, result);
        }
    }

    public static void appendElement(Element element, Result result) throws CodecException {
        if (result instanceof DOMResult) {
            Node node = ((DOMResult)result).getNode();
            node.appendChild(element);
        } else {
            DOMSource src = new DOMSource(element);
            CodecUtil.transform(src, result);
        }
    }

    public static Document createDocument() throws CodecException {
        try {
            return XmlFactories.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new CodecException("Parser problems", e);
        }
    }

    public static String toString(Source source) throws CodecException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(stream);
        CodecUtil.transform(source, result);
        return stream.toString();
    }

    public static String toTruncatedString(Source source, final int truncationLength) throws CodecException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(){
            boolean overloaded = false;

            public synchronized void write(byte[] b, int off, int len) {
                if (this.overloaded) {
                    return;
                }
                int l = this.checkTruncation(len);
                if (l > 0) {
                    super.write(b, off, l);
                }
                if (l != len) {
                    byte[] tail = "...[output truncated]".getBytes();
                    super.write(tail, 0, tail.length);
                    this.overloaded = true;
                }
            }

            private int checkTruncation(int len) {
                if (this.size() + len > truncationLength) {
                    return truncationLength - this.size();
                }
                return len;
            }
        };
        StreamResult result = new StreamResult(stream);
        try {
            CodecUtil.transform(source, result);
        }
        catch (Exception e) {
            // empty catch block
        }
        return stream.toString();
    }

    public static void transform(Source source, Result result) throws CodecException {
        try {
            XmlFactories.newTransformer().transform(source, result);
        }
        catch (TransformerException e) {
            throw new CodecException("transformer problems", e);
        }
    }
}

