/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com;

import com.genesyslab.platform.applicationblocks.com.CachingConfServicePolicy;
import com.genesyslab.platform.applicationblocks.com.ConfService;
import com.genesyslab.platform.applicationblocks.com.ConfServiceCreator;
import com.genesyslab.platform.applicationblocks.com.IConfService;
import com.genesyslab.platform.applicationblocks.com.IConfServicePolicy;
import com.genesyslab.platform.applicationblocks.com.cache.DefaultConfCache;
import com.genesyslab.platform.applicationblocks.com.cache.DefaultConfCacheQueryEngine;
import com.genesyslab.platform.applicationblocks.com.cache.DefaultConfCacheStorage;
import com.genesyslab.platform.applicationblocks.com.cache.IConfCache;
import com.genesyslab.platform.applicationblocks.com.cache.IConfCachePolicy;
import com.genesyslab.platform.applicationblocks.commons.broker.Subscriber;
import com.genesyslab.platform.applicationblocks.commons.broker.SubscriptionService;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.Protocol;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfServiceFactory {
    private static Hashtable<Integer, ConfServiceInfo> createdServices = new Hashtable();
    private static ConfServiceCreator serviceCreator = new ConfServiceCreator(){

        public ConfService createInstance(Protocol protocol) {
            return new ConfService(protocol);
        }
    };

    private ConfServiceFactory() {
    }

    public static void setConfServiceCreator(ConfServiceCreator creator) {
        if (creator == null) {
            throw new NullPointerException("ConfServiceCreator");
        }
        serviceCreator = creator;
    }

    public static IConfService createConfService(Protocol protocol) {
        return ConfServiceFactory.createConfServiceInternal(protocol, null);
    }

    public static IConfService createConfService(Protocol protocol, boolean enableCaching) {
        ConfService confService = ConfServiceFactory.createConfServiceInternal(protocol, null);
        if (enableCaching) {
            DefaultConfCacheStorage storage = new DefaultConfCacheStorage();
            DefaultConfCache cache = new DefaultConfCache(null, storage, new DefaultConfCacheQueryEngine(storage));
            confService.setCache(cache);
            confService.setPolicy(new CachingConfServicePolicy());
            confService.register(cache);
        }
        return confService;
    }

    public static IConfService createConfService(Protocol protocol, IConfServicePolicy confServicePolicy, IConfCachePolicy confCachePolicy) {
        ConfService confService = ConfServiceFactory.createConfServiceInternal(protocol, null);
        if (confServicePolicy != null) {
            confService.setPolicy(confServicePolicy);
        }
        DefaultConfCacheStorage storage = new DefaultConfCacheStorage();
        DefaultConfCache confCache = new DefaultConfCache(confCachePolicy, storage, new DefaultConfCacheQueryEngine(storage));
        confService.setCache(confCache);
        confService.register(confCache);
        return confService;
    }

    public static IConfService createConfService(Protocol protocol, IConfServicePolicy confServicePolicy, IConfCache cache) {
        ConfService confService = ConfServiceFactory.createConfServiceInternal(protocol, null);
        if (confServicePolicy != null) {
            confService.setPolicy(confServicePolicy);
        }
        confService.setCache(cache);
        if (cache != null) {
            confService.register(cache);
        }
        return confService;
    }

    @Deprecated
    public static IConfService createConfService(Protocol protocol, SubscriptionService<Message> subscriptionService) {
        return ConfServiceFactory.createConfServiceInternal(protocol, subscriptionService);
    }

    @Deprecated
    public static IConfService createConfService(Protocol protocol, SubscriptionService<Message> subscriptionService, boolean enableCaching) {
        ConfService confService = ConfServiceFactory.createConfServiceInternal(protocol, subscriptionService);
        if (enableCaching) {
            DefaultConfCacheStorage storage = new DefaultConfCacheStorage();
            DefaultConfCache cache = new DefaultConfCache(null, storage, new DefaultConfCacheQueryEngine(storage));
            confService.setCache(cache);
            confService.setPolicy(new CachingConfServicePolicy());
            confService.register(cache);
        }
        return confService;
    }

    @Deprecated
    public static IConfService createConfService(Protocol protocol, SubscriptionService<Message> subscriptionService, IConfServicePolicy confServicePolicy, IConfCachePolicy confCachePolicy) {
        ConfService confService = ConfServiceFactory.createConfServiceInternal(protocol, subscriptionService);
        if (confServicePolicy != null) {
            confService.setPolicy(confServicePolicy);
        }
        DefaultConfCacheStorage storage = new DefaultConfCacheStorage();
        DefaultConfCache confCache = new DefaultConfCache(confCachePolicy, storage, new DefaultConfCacheQueryEngine(storage));
        confService.setCache(confCache);
        confService.register(confCache);
        return confService;
    }

    @Deprecated
    public static IConfService createConfService(Protocol protocol, SubscriptionService<Message> subscriptionService, IConfServicePolicy confServicePolicy, IConfCache cache) {
        ConfService confService = ConfServiceFactory.createConfServiceInternal(protocol, subscriptionService);
        if (confServicePolicy != null) {
            confService.setPolicy(confServicePolicy);
        }
        confService.setCache(cache);
        if (cache != null) {
            confService.register(cache);
        }
        return confService;
    }

    public static IConfService retrieveConfService(Protocol protocol) {
        if (protocol == null) {
            return null;
        }
        ConfServiceInfo res = createdServices.get(protocol.getProtocolId());
        if (res != null) {
            return res.getConfService();
        }
        return null;
    }

    public static IConfService retrieveConfService(Endpoint endpoint) {
        if (endpoint == null) {
            return null;
        }
        for (ConfServiceInfo csi : createdServices.values()) {
            if (!csi.getConfService().getProtocol().getEndpoint().equals((Object)endpoint)) continue;
            return csi.getConfService();
        }
        return null;
    }

    public static void releaseConfService(IConfService confService) {
        if (!(confService instanceof ConfService)) {
            throw new IllegalArgumentException("This type of configuration service is not supported by the factory");
        }
        ConfService cs = (ConfService)confService;
        if (cs.getProtocol() == null) {
            throw new IllegalArgumentException("The configuration service does not have an associated protocol");
        }
        int key = cs.getProtocol().getProtocolId();
        if (!createdServices.containsKey(key)) {
            throw new IllegalArgumentException("The specified object has either already been released or was not created with this factory.");
        }
        ConfServiceInfo info = createdServices.get(key);
        if (info.getConfService() != confService) {
            throw new IllegalArgumentException("The specified object has not been created with this factory");
        }
        if (info.getSubscriptionService() != null) {
            info.getSubscriptionService().unregister((Subscriber)info.getConfService());
        }
        cs.dispose();
        createdServices.remove(key);
    }

    private static ConfService createConfServiceInternal(Protocol protocol, SubscriptionService<Message> subscriptionService) {
        if (protocol == null) {
            throw new IllegalArgumentException("Protocol can't be null");
        }
        if (protocol.getEndpoint() == null) {
            throw new IllegalArgumentException("No endpoint specified in the protocol.");
        }
        if (ConfServiceFactory.retrieveConfService(protocol) != null) {
            throw new IllegalArgumentException("ConfService has already been created for this protocol.");
        }
        if (ConfServiceFactory.retrieveConfService(protocol.getEndpoint()) != null) {
            throw new IllegalArgumentException("ConfService has already been created for this endpoint.");
        }
        ConfService confService = serviceCreator.createInstance(protocol);
        if (confService == null) {
            throw new NullPointerException("ConfServiceCreator result is null");
        }
        if (subscriptionService != null) {
            subscriptionService.register((Subscriber)confService);
        } else {
            confService.setupInternalMessageHandler();
        }
        createdServices.put(protocol.getProtocolId(), new ConfServiceInfo(confService, subscriptionService));
        return confService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfServiceInfo {
        private ConfService confService;
        private SubscriptionService<Message> subscriptionService = null;

        ConfServiceInfo(ConfService cs, SubscriptionService<Message> ss) {
            this.confService = cs;
            this.subscriptionService = ss;
        }

        ConfService getConfService() {
            return this.confService;
        }

        SubscriptionService<Message> getSubscriptionService() {
            return this.subscriptionService;
        }
    }
}

