/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleAbstractElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleWriter;
import org.w3c.dom.Element;

class CRMediaMapEntry
extends CapacityRuleAbstractElement {
    static final String TAG_NAME = "Media";
    static final String TAG_ATTRIBUTE = "name";
    private int MediaType;
    private String MediaName;
    int MaxCapacity;
    private CRMediaMap Parent;

    CRMediaMapEntry(CRMediaMap parent, String mediaName, int mediaType) throws CapacityRuleException {
        if (mediaName == null) {
            throw new CapacityRuleException("null media name for media map entry");
        }
        this.Parent = parent;
        this.MediaType = mediaType;
        this.MediaName = mediaName;
        this.MaxCapacity = 0;
    }

    public CRMediaMapEntry(CRMediaMap parent, String mediaName) {
        this.Parent = parent;
        this.MediaType = parent.getMediaTypeCount();
        this.MediaName = mediaName;
        this.MaxCapacity = 0;
    }

    public CRMediaMap getParent() {
        return this.Parent;
    }

    public String getMediaName() {
        return this.MediaName;
    }

    public int getMediaType() {
        return this.MediaType;
    }

    public static CRMediaMapEntry create(CRMediaMap parent, Element element) {
        String attrValue = element.getAttribute(TAG_ATTRIBUTE);
        if (attrValue != null) {
            return new CRMediaMapEntry(parent, attrValue);
        }
        return null;
    }

    public void write(ICapacityRuleWriter writer) {
        if (this.MediaName == null) {
            return;
        }
        for (char c : this.MediaName.toCharArray()) {
            writer.addByte((byte)c);
        }
        writer.addByte((byte)0);
    }

    public String toString() {
        return "[CRMediaMapEntry] name=\"" + this.MediaName + "\"";
    }
}

