/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBlock;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBody;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRule;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleAbstractElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleReader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleWriter;
import com.genesyslab.platform.applicationblocks.com.capacityrules.MediaRule;
import com.genesyslab.platform.applicationblocks.com.capacityrules.OnMediaRuleChanged;
import java.nio.ByteBuffer;

class CRRuleBlockEntry
extends CapacityRuleAbstractElement {
    private static final int DEFAULT_PRIORITY = 255;
    private CRRuleBlock parent;
    private int priority = Integer.MIN_VALUE;
    private CRRuleBody ruleBody;
    private MediaRule mediaRule;

    public CRRuleBlockEntry(CRRuleBlock parent, ICapacityRuleReader reader, String priority) {
        this.parent = parent;
        try {
            this.priority = Integer.parseInt(priority);
        }
        catch (NumberFormatException e) {
            this.priority = 255;
        }
        this.mediaRule = new MediaRule(reader, this);
    }

    public CRRuleBlockEntry(CRRuleBlock parent, int priority, ByteBuffer buf, int positionBase) throws CapacityRuleException {
        this.parent = parent;
        this.priority = priority;
        this.read(buf, positionBase);
        this.mediaRule = new MediaRule(this, this.ruleBody);
    }

    public void process(CRMediaMap map) throws CapacityRuleException {
        if (this.mediaRule == null) {
            return;
        }
        OnMediaRuleChanged onChanged = null;
        Object parent = this.parent;
        while (parent != null) {
            if (parent instanceof CapacityRule) {
                onChanged = ((CapacityRule)parent).getOnRuleChanged();
                break;
            }
            if (!(parent instanceof CapacityRuleAbstractElement)) break;
            parent = ((CapacityRuleAbstractElement)parent).getParent();
        }
        this.mediaRule.setOnRuleChanged(onChanged);
        this.ruleBody = this.mediaRule.process(map);
    }

    public CRRuleBlock getParent() {
        return this.parent;
    }

    public int getPriority() {
        return this.priority;
    }

    public void write(ICapacityRuleWriter writer) {
        if (this.ruleBody == null) {
            return;
        }
        this.ruleBody.write(writer);
    }

    private void read(ByteBuffer buf, int positionBase) throws CapacityRuleException {
        this.ruleBody = new CRRuleBody(this, buf, positionBase);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.priority != Integer.MIN_VALUE) {
            sb.append("priority=");
            sb.append('\"');
            sb.append(this.priority);
            sb.append('\"');
            sb.append(' ');
        }
        if (this.mediaRule != null) {
            sb.append(this.mediaRule.toString());
        } else if (this.ruleBody != null) {
            sb.append(this.ruleBody.toString());
        }
        return sb.toString();
    }

    public MediaRule getMediaRule() {
        return this.mediaRule;
    }

    public int hashCode() {
        int hashCode = CRRuleBlockEntry.class.hashCode();
        hashCode = hashCode * 31 + this.priority;
        if (this.ruleBody != null) {
            hashCode = hashCode * 31 + this.ruleBody.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CRRuleBlockEntry)) {
            return false;
        }
        CRRuleBlockEntry o = (CRRuleBlockEntry)obj;
        if (this.priority != o.priority) {
            return false;
        }
        return this.ruleBody == null ? o.ruleBody == null : this.ruleBody.equals(o.ruleBody);
    }

    public CRMediaMap getMap() {
        return this.parent == null ? null : this.parent.getMap();
    }

    public boolean match(CRRuleBlockEntry entry) {
        if (entry == null) {
            return false;
        }
        return this.mediaRule == null ? entry.mediaRule == null : this.mediaRule.match(entry.mediaRule);
    }
}

