/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.runtime;

import com.genesyslab.platform.applicationblocks.com.CfgObject;
import com.genesyslab.platform.applicationblocks.com.ConfService;
import com.genesyslab.platform.applicationblocks.com.ConfigException;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import com.genesyslab.platform.configuration.protocol.ConfServerProtocol;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.utilities.Linq;
import com.genesyslab.platform.configuration.protocol.utilities.LinqConditions;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlObjectUpdateHelper {
    private static final String CFG_NS;
    private static DocumentBuilder documentBuilder;
    private static XPath xpath;
    private static ILogger log;

    private XmlObjectUpdateHelper() {
    }

    private static Collection<Node> sortObjectAttributesInternal(Node docToSort, final CfgDescriptionClass propertiesMetaData) {
        return Linq.selectWithOrder((NodeList)docToSort.getChildNodes(), (LinqConditions)new LinqConditions<Node>(){

            public boolean condition(Node item) {
                return true;
            }

            public int compare(Node o1, Node o2) {
                int index1 = propertiesMetaData.getAttributeByName(o1.getNodeName()).getIndex();
                int index2 = propertiesMetaData.getAttributeByName(o2.getNodeName()).getIndex();
                return index1 - index2;
            }
        });
    }

    public static Node sortObjectAttributes(Node obj, CfgDescriptionClass metadata) {
        Document deltaDoc = XmlObjectUpdateHelper.sortChildrenForNewObject(obj, metadata);
        Element deltaRoot = deltaDoc.getDocumentElement();
        Node rootObj = deltaDoc.importNode(obj, false);
        Node childItem = deltaRoot.getFirstChild();
        while (childItem != null) {
            rootObj.appendChild(childItem);
            childItem = deltaRoot.getFirstChild();
        }
        deltaDoc.getDocumentElement().appendChild(rootObj);
        return rootObj;
    }

    protected static Node selectNodeByXPath(Node base, String path) {
        Node ret = null;
        try {
            ret = (Node)xpath.evaluate(path, base, XPathConstants.NODE);
        }
        catch (Exception e) {
            log.error((Object)"Internal exception", (Throwable)e);
        }
        return ret;
    }

    public static Document sortChildrenForNewObject(Node data, CfgDescriptionClass metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata");
        }
        Collection allProps = metadata.getAttributes();
        Document tempDeltaDoc = documentBuilder.newDocument();
        tempDeltaDoc.appendChild(tempDeltaDoc.createElementNS("", "tempRoot"));
        Element rootDeltaNode = tempDeltaDoc.getDocumentElement();
        for (CfgDescriptionAttribute propInfo : allProps) {
            Node nodeTemp = null;
            Node childNodePtr = XmlObjectUpdateHelper.selectNodeByXPath(data, "cfg:" + propInfo.getName());
            if (childNodePtr == null) continue;
            Node childNode = childNodePtr;
            if (propInfo.isCfgType(CfgTypeMask.Structure) && propInfo.isCfgType(CfgTypeMask.List)) {
                CfgDescriptionAttributeReferenceClass attrStruct = (CfgDescriptionAttributeReferenceClass)propInfo;
                if (childNode.getChildNodes().getLength() > 0) {
                    nodeTemp = tempDeltaDoc.createElementNS(CFG_NS, childNode.getNodeName());
                }
                for (int i = 0; i < childNode.getChildNodes().getLength(); ++i) {
                    Node oldChildNode = childNode.getChildNodes().item(i);
                    Document sortedChild = XmlObjectUpdateHelper.sortChildrenForNewObject(oldChildNode, attrStruct.getCfgClass());
                    Node newChildNode = nodeTemp.appendChild(tempDeltaDoc.createElementNS(CFG_NS, oldChildNode.getNodeName()));
                    NodeList childs2cp = sortedChild.getDocumentElement().getChildNodes();
                    for (int j = 0; j < childs2cp.getLength(); ++j) {
                        newChildNode.appendChild(tempDeltaDoc.importNode(childs2cp.item(j), true));
                    }
                }
            } else if (propInfo.isCfgType(CfgTypeMask.Reference) && propInfo.isCfgType(CfgTypeMask.Structure)) {
                CfgDescriptionAttributeReferenceClass attrRefClass = (CfgDescriptionAttributeReferenceClass)propInfo;
                Document sortedStructure = XmlObjectUpdateHelper.sortChildrenForNewObject(childNode, attrRefClass.getCfgClass());
                if (sortedStructure == null || sortedStructure.getDocumentElement() == null || !sortedStructure.getDocumentElement().hasChildNodes()) break;
                Node childItem = sortedStructure.getDocumentElement().getFirstChild();
                if (childItem != null) {
                    nodeTemp = tempDeltaDoc.createElementNS(CFG_NS, childNode.getNodeName());
                    while (childItem != null) {
                        nodeTemp.appendChild(tempDeltaDoc.importNode(childItem, true));
                        childItem = childItem.getNextSibling();
                    }
                }
            } else {
                nodeTemp = tempDeltaDoc.importNode(childNode, true);
            }
            if (nodeTemp == null) continue;
            rootDeltaNode.appendChild(nodeTemp);
        }
        Collection<Node> newSortedNodes = XmlObjectUpdateHelper.sortObjectAttributesInternal(rootDeltaNode, metadata);
        Document deltaDoc = documentBuilder.newDocument();
        Element deltaRootNode = deltaDoc.createElementNS(CFG_NS, "ConfData");
        deltaDoc.appendChild(deltaRootNode);
        for (Node sortedNode : newSortedNodes) {
            if (sortedNode == null) continue;
            Node importNode = deltaDoc.importNode(sortedNode, true);
            deltaRootNode.appendChild(importNode);
        }
        return deltaDoc;
    }

    public static Document createDeltaForNewObject(CfgObject cfgObject) throws ConfigException {
        String objectName = cfgObject.getData().getNodeName();
        Document deltaDoc = documentBuilder.newDocument();
        Element rootNode = deltaDoc.createElementNS(CFG_NS, "ConfData");
        rootNode.appendChild(deltaDoc.createElementNS(CFG_NS, objectName));
        deltaDoc.appendChild(rootNode);
        Document tempDoc = XmlObjectUpdateHelper.sortChildrenForNewObject(cfgObject.getData(), cfgObject.getMetaData());
        NodeList itemsSrc = tempDoc.getDocumentElement().getChildNodes();
        Node nodeTgt = deltaDoc.getDocumentElement().getChildNodes().item(0);
        for (int i = 0; i < itemsSrc.getLength(); ++i) {
            nodeTgt.appendChild(deltaDoc.importNode(itemsSrc.item(i), true));
        }
        return deltaDoc;
    }

    static {
        log = Log.getLogger(ConfService.class);
        try {
            CFG_NS = ConfServerProtocol.PROTOCOL_DESCRIPTION.getNS();
            documentBuilder = XmlFactories.newDocumentBuilderNS();
            xpath = XmlFactories.newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                public String getNamespaceURI(String prefix) {
                    String uri = prefix.equals("cfg") || prefix.equals("") ? CFG_NS : null;
                    return uri;
                }

                public Iterator getPrefixes(String val) {
                    return null;
                }

                public String getPrefix(String uri) {
                    return null;
                }
            });
        }
        catch (ParserConfigurationException e) {
            log.fatalError((Object)"Can't initialize XML engine", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

