/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.timer.impl;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.threading.InvokerFactory;
import com.genesyslab.platform.commons.threading.ThreadHeartbeatCounter;
import com.genesyslab.platform.commons.timer.Scheduler;
import com.genesyslab.platform.commons.timer.TimerAction;
import com.genesyslab.platform.commons.timer.TimerActionTicket;
import java.util.Timer;

public class SchedulerImpl
implements Scheduler {
    private static Timer timer = null;
    private static ThreadHeartbeatCounter monitor = null;
    private static final ILogger log = Log.getLogger(SchedulerImpl.class);

    public SchedulerImpl() {
        SchedulerImpl.initialize();
    }

    protected static synchronized void initialize() {
        if (timer != null) {
            return;
        }
        timer = new Timer(true);
        timer.schedule(new java.util.TimerTask(){

            public void run() {
                try {
                    Thread.currentThread().setName("PSDK.Timer");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 1L);
        timer.schedule(new java.util.TimerTask(){

            public void run() {
                try {
                    InvokerFactory.doReleaseUnusedInvokers();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 500L, 700L);
        try {
            monitor = ThreadHeartbeatCounter.createThreadHeartbeatCounter((String)"PSDKTimer", (int)1);
        }
        catch (Exception e) {
            log.error((Object)"Exception while creating thread monitor", (Throwable)e);
        }
        if (monitor != null) {
            timer.schedule(new java.util.TimerTask(){

                public void run() {
                    monitor.initialize();
                    timer.schedule(new java.util.TimerTask(){

                        public void run() {
                            monitor.alive();
                        }
                    }, 10L, 500L);
                }
            }, 10L);
        }
    }

    protected static synchronized void doSchedule(TimerTask task, long delay, long period, boolean retry) {
        boolean doRetry = retry;
        if (timer == null) {
            SchedulerImpl.initialize();
            doRetry = false;
        }
        try {
            if (period > 0L) {
                timer.schedule((java.util.TimerTask)task, delay, period);
            } else {
                timer.schedule((java.util.TimerTask)task, delay);
            }
        }
        catch (IllegalStateException ise) {
            if (doRetry) {
                log.warn((Object)"Exception while task scheduling, recreating Timer", (Throwable)ise);
                SchedulerImpl.dispose();
                SchedulerImpl.initialize();
                SchedulerImpl.doSchedule(task, delay, period, false);
            }
            throw ise;
        }
    }

    protected static synchronized void dispose() {
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
        if (monitor != null) {
            monitor.unregister();
            monitor = null;
        }
    }

    public TimerActionTicket schedule(long delay, TimerAction action) {
        if (log.isDebug()) {
            log.debug((Object)("Scheduling delayed action: " + action + "; delay:" + delay));
        }
        TimerTask task = new TimerTask(action);
        TimerTicketImpl ticket = new TimerTicketImpl(task, action);
        SchedulerImpl.doSchedule(task, delay, 0L, true);
        return ticket;
    }

    public TimerActionTicket schedule(long delay, long period, TimerAction action) {
        if (log.isDebug()) {
            log.debug((Object)("Scheduling repeating action: " + action + "; delay:" + delay + "; period: " + period));
        }
        TimerTask task = new TimerTask(action);
        TimerTicketImpl ticket = new TimerTicketImpl(task, action);
        SchedulerImpl.doSchedule(task, delay, period, true);
        return ticket;
    }

    public void shutdown() {
        SchedulerImpl.dispose();
    }

    private static class TimerTicketImpl
    implements TimerActionTicket {
        private TimerTask task;
        private TimerAction action;

        public TimerTicketImpl(TimerTask task, TimerAction action) {
            this.task = task;
            this.action = action;
        }

        public void cancel() {
            if (this.task != null) {
                if (log.isDebug()) {
                    log.debugFormat("Canceling ticket ''{0}''", (Object)this.action.toString());
                }
                this.task.cancel();
                this.task = null;
            }
        }
    }

    private static class TimerTask
    extends java.util.TimerTask {
        private TimerAction action;

        public TimerTask(TimerAction action) {
            this.action = action;
        }

        public void run() {
            try {
                if (this.action != null) {
                    this.action.onTimer();
                }
            }
            catch (Throwable e) {
                log.warn((Object)"Exception in TimerAction", e);
            }
        }
    }
}

