/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.connection.ConnectionHandler;
import com.genesyslab.platform.commons.connection.ConnectionManager;
import com.genesyslab.platform.commons.connection.ConnectionState;
import com.genesyslab.platform.commons.connection.MessagePackager;
import com.genesyslab.platform.commons.connection.StartTLSSupport;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.interceptor.Interceptor;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.AbstractChannel;
import com.genesyslab.platform.commons.protocol.ChannelErrorEvent;
import com.genesyslab.platform.commons.protocol.ChannelManager;
import com.genesyslab.platform.commons.protocol.ChannelNotClosedException;
import com.genesyslab.platform.commons.protocol.ChannelReceiverInitializationException;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.EndpointSupport;
import com.genesyslab.platform.commons.protocol.InputChannel;
import com.genesyslab.platform.commons.protocol.InterceptorSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.MessageHandler;
import com.genesyslab.platform.commons.protocol.MessageReceiver;
import com.genesyslab.platform.commons.protocol.MessageReceiverManagement;
import com.genesyslab.platform.commons.protocol.MessageReceiverSupport;
import com.genesyslab.platform.commons.protocol.OutputChannel;
import com.genesyslab.platform.commons.protocol.OutputChannelListener;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolDescriptionSupport;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.QueueMessageReceiver;
import com.genesyslab.platform.commons.protocol.RegistrationException;
import com.genesyslab.platform.commons.protocol.runtime.CodecSupport;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolMessagePackagerImpl;
import com.genesyslab.platform.commons.protocol.runtime.ToStringHelper;
import com.genesyslab.platform.commons.protocol.runtime.UpdatableProtocolId;
import com.genesyslab.platform.commons.protocol.runtime.license.LicenseRestriction;
import com.genesyslab.platform.commons.protocol.runtime.license.LicenseRestrictionCollection;
import com.genesyslab.platform.commons.protocol.runtime.license.RestrictionManager;
import com.genesyslab.platform.commons.protocol.runtime.license.SendMessagePermission;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.threading.Slot;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplexChannel
extends AbstractChannel
implements InputChannel,
OutputChannel,
InterceptorSupport,
MessageReceiverManagement,
ProtocolDescriptionSupport {
    private static final ILogger log = Log.getLogger(DuplexChannel.class);
    private static final ILogger dataLogger = Log.getDataLogger();
    private Slot<ConnectionClosedEvent> closeSync;
    private List<OutputChannelListener> outputChannelListeners = new CopyOnWriteArrayList<OutputChannelListener>();
    private Connection connection;
    private ProtocolFactory protocolFactory;
    private MessageReceiverSupport receiver;
    private boolean externalReceiver = false;
    private MessageHandler messagesHandler = null;
    private final LicenseRestrictionCollection licenseRestriction = new LicenseRestrictionCollection();
    private Object protocolData;
    ChannelManager manager = null;

    public DuplexChannel(Endpoint endpoint, ProtocolFactory protocolFactory) {
        this(endpoint, protocolFactory, 30000L);
    }

    public DuplexChannel(Endpoint endpoint, ProtocolFactory protocolFactory, long timeout) {
        this(endpoint, protocolFactory, timeout, true);
    }

    protected DuplexChannel(Connection conn, ProtocolFactory factory, long timout) {
        this(new Endpoint(conn.getUri(), conn.getHost(), conn.getPort()), factory, timout, false);
        this.connection = conn;
        this.setupConnection(null);
    }

    private DuplexChannel(Endpoint endpoint, ProtocolFactory protocolFactory, long timeout, boolean resetReciever) {
        super(timeout, endpoint);
        this.protocolFactory = protocolFactory;
        if (resetReciever) {
            this.resetReceiver();
        }
    }

    public int getProtocolId() {
        return this.getChannelId();
    }

    @Override
    public synchronized void open() throws RegistrationException, ProtocolException, IllegalStateException, InterruptedException {
        this.open(this.getTimeout());
    }

    @Override
    public synchronized void open(long timeout) throws RegistrationException, ProtocolException, ChannelNotClosedException, InterruptedException {
        this.throwNullEndpoint();
        this.throwNotClosed();
        Slot<Object> openSync = this.initiateOpen();
        this.completeOpen(timeout, openSync);
    }

    @Override
    public synchronized void beginOpen() throws ProtocolException {
        this.throwNullEndpoint();
        this.throwNotClosed();
        Slot<Object> openSync = this.initiateOpen();
        AsyncOpener opener = new AsyncOpener(openSync);
        this.getInvoker().invoke((Runnable)opener);
    }

    @Override
    public synchronized void close() throws ProtocolException, InterruptedException, IllegalStateException {
        this.close(this.getTimeout());
    }

    @Override
    public synchronized void close(long timeout) throws ProtocolException, InterruptedException, IllegalStateException {
        this.throwNullEndpoint();
        this.throwNotOpenedOnClose();
        this.doClose(timeout);
    }

    @Override
    public synchronized void beginClose() throws IllegalStateException {
        this.throwNullEndpoint();
        this.throwNotOpenedOnClose();
        this.doBeginClose();
    }

    public InetSocketAddress getLocalEndPoint() {
        if (this.connection != null) {
            return this.connection.getLocalEndPoint();
        }
        return null;
    }

    public InetSocketAddress getRemoteEndPoint() {
        if (this.connection != null) {
            return this.connection.getRemoteEndPoint();
        }
        return null;
    }

    public Message receive() throws InterruptedException {
        return this.receive(this.getTimeout());
    }

    public Message receive(long timeout) throws InterruptedException {
        if (this.messagesHandler != null) {
            throw new ChannelReceiverInitializationException("receive() can't be used with MessagesHandler initialized");
        }
        return this.getInternalReceiver().receive(timeout);
    }

    @Override
    public void send(Message message) throws ProtocolException, IllegalStateException {
        this.throwNotOpenedOnSend();
        this.doSend(message);
    }

    @Override
    public void addListener(OutputChannelListener listener) {
        if (this.outputChannelListeners.contains(listener)) {
            return;
        }
        this.outputChannelListeners.add(listener);
    }

    @Override
    public void removeListener(OutputChannelListener listener) {
        this.outputChannelListeners.remove(listener);
    }

    private void notifyOnSend(Message message) {
        for (OutputChannelListener l : this.outputChannelListeners) {
            try {
                l.onSend(this, message);
            }
            catch (Exception e) {
                log.error((Object)"Unexpected exception caught from onSend listener", (Throwable)e);
            }
        }
    }

    @Override
    public int getInputSize() {
        return this.receiver.getInputSize();
    }

    @Override
    public void setInputSize(int inputSize) {
        this.getInternalReceiver().setInputSize(inputSize);
    }

    @Override
    public void releaseReceivers() {
        this.getInternalReceiver().releaseReceivers();
    }

    @Override
    public Interceptor getInterceptor() {
        if (this.getConfiguration() == null) {
            return null;
        }
        if (this.connection == null) {
            return null;
        }
        return this.connection.getInterceptor();
    }

    @Override
    public void clearInput() {
        this.receiver.clearInput();
    }

    @Override
    public void setReceiver(MessageReceiverSupport receiver) {
        if (this.messagesHandler != null) {
            throw new ChannelReceiverInitializationException("Protocol already has MessageHandler initialized");
        }
        this.throwNotClosed();
        this.externalReceiver = true;
        this.doSetReceiver(receiver);
    }

    @Override
    public void setMessageHandler(MessageHandler msgHandler) {
        if (this.externalReceiver) {
            throw new ChannelReceiverInitializationException("Protocol already has external Receiver initialized");
        }
        this.throwNotClosed();
        this.messagesHandler = msgHandler;
    }

    @Override
    public void resetReceiver() {
        this.throwNotClosed();
        this.externalReceiver = false;
        QueueMessageReceiver internalReceiver = new QueueMessageReceiver(128, true);
        this.doSetReceiver(internalReceiver);
    }

    @Override
    @Deprecated
    public void setConnectionInvoker(AsyncInvoker connectionInvoker) {
        this.throwNotClosed();
        super.setConnectionInvoker(connectionInvoker);
    }

    @Override
    public ProtocolDescription getProtocolDescription() {
        if (this.protocolFactory == null) {
            return null;
        }
        return this.protocolFactory.getProtocolDescription();
    }

    public String toString() {
        return super.toString() + "@{" + this.getEndpoint() + "}";
    }

    protected void setProtocolData(Object protocolData) {
        this.protocolData = protocolData;
        this.initPackager(this.connection, protocolData);
    }

    protected void initPackager(Connection connection, Object protocolData) {
        MessagePackager packager;
        if (connection != null && (packager = connection.getMessagePackager()) instanceof CodecSupport) {
            CodecSupport codecSupport = (CodecSupport)packager;
            codecSupport.setProtocolData(protocolData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.connection != null && this.connection.getConnectionState() != ConnectionState.CLOSED) {
                if (log.isWarn()) {
                    log.warn((Object)("Forcing connection close in finalizer. Its a channel usage error - connections should be closed explicitly. Channel: " + this + "; Connection: " + this.connection));
                }
                this.connection.forceClose();
            }
        }
        finally {
            super.finalize();
        }
    }

    protected ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    protected void doSend(Message message) throws ProtocolException {
        this.throwNull(message, "message");
        this.onSend(message);
        if (this.isMessageAllowed(message)) {
            if (log.isDebug()) {
                log.debug((Object)("Sending message to '" + this.getProtocolDescription() + "@" + this.getEndpoint() + "' message: " + ToStringHelper.toString(message, true, true)));
            }
            if (dataLogger.isDebug()) {
                dataLogger.debugFormat("Sending message to {0}/{1} message: {2}", (Object)new Object[]{this.getProtocolDescription(), this.getEndpoint(), message.toString(true, false)});
            }
            try {
                if (message instanceof EndpointSupport) {
                    ((EndpointSupport)((Object)message)).setEndpoint(this.getEndpoint());
                }
                if (message instanceof UpdatableProtocolId) {
                    ((UpdatableProtocolId)((Object)message)).setProtocolId(this.getProtocolId());
                }
                this.connection.getMessagePackager().sendMessage((Object)message);
            }
            catch (PlatformException e) {
                throw new ProtocolException("Exception sending message", e);
            }
            if (this.manager != null) {
                this.manager.incMessagesSentNumber();
            }
        }
    }

    protected final boolean isMessageAllowed(Message message) throws ProtocolException {
        LicenseRestriction restriction = this.getRestriction();
        if (restriction == null) {
            return true;
        }
        boolean allowed = restriction.isAllowed(new SendMessagePermission(message));
        if (!allowed) {
            if (log.isDebug()) {
                log.debugFormat("Message ''{0}'' is not allowed to be sent", (Object)message.messageName());
            }
            ChannelErrorEvent errEvent = new ChannelErrorEvent(this, (Throwable)((Object)new ProtocolException("message is not allowed to be sent")));
            this.getInvoker().invoke((Runnable)(AbstractChannel)this.new AbstractChannel.AsyncErrorNotifier(errEvent));
        }
        return allowed;
    }

    protected LicenseRestriction getDefaultRestriction() {
        return this.licenseRestriction;
    }

    protected void doClose(long closeTimeout) throws ProtocolException, InterruptedException {
        this.initiateClose();
        this.completeClose(closeTimeout);
    }

    protected void doBeginClose() {
        this.initiateClose();
        this.getInvoker().invoke((Runnable)new AsyncCloser());
    }

    protected void onOpen() throws ProtocolException {
        this.setState(ChannelState.Opened);
    }

    protected void onSend(Message message) throws ProtocolException {
        this.notifyOnSend(message);
    }

    protected void onClose(ConnectionClosedEvent event) {
        this.setState(ChannelState.Closed, event);
    }

    protected void onReceiveMessage(Message msg) {
        if (this.messagesHandler != null) {
            this.getInvoker().invoke((Runnable)new AsyncMessageNotifier(msg, this.messagesHandler));
        } else {
            this.receiver.processMessage(msg);
        }
    }

    protected Connection createConnection(Endpoint endpoint) {
        return ConnectionManager.createConnection((String)endpoint.getHost(), (int)endpoint.getPort(), this.connectionContext());
    }

    protected <N> N waitForObject(Slot<N> syncObject, long timeout) throws InterruptedException {
        Object openResult = timeout < 0L ? syncObject.take() : syncObject.poll(timeout);
        return (N)openResult;
    }

    protected <N> void notifyWithObject(Slot<N> syncObject, N notification) throws InterruptedException {
        syncObject.put(notification);
    }

    protected <N> boolean triggerWithObject(Slot<N> syncObject, N notification) throws InterruptedException {
        return syncObject.offer(notification, 0L);
    }

    protected ProtocolException getTimeoutException(String operation, long timeout) {
        String msg = "Timeout on channel (" + timeout + " ms). Operation: " + operation;
        log.debug((Object)msg);
        return new ProtocolException(msg);
    }

    protected void closeOpening(ConnectionClosedEvent event) {
    }

    private MessageReceiver<Message> getInternalReceiver() {
        if (this.externalReceiver) {
            throw new ChannelReceiverInitializationException("External receiver is set, use its methods instead");
        }
        return this.receiver;
    }

    private LicenseRestriction getRestriction() {
        LicenseRestriction restriction = RestrictionManager.getRestriction(new ProtocolDescription("not.used.so.far", "*"));
        if (restriction == null) {
            restriction = this.getDefaultRestriction();
        }
        return restriction;
    }

    private void doSetReceiver(MessageReceiverSupport receiver) {
        this.removeChannelListener(this.receiver);
        this.receiver = receiver;
        this.addChannelListener(receiver);
    }

    private Slot<Object> initiateOpen() throws ProtocolException {
        this.throwNullEndpoint();
        Endpoint endpoint = this.getEndpoint();
        if (log.isDebug()) {
            log.debug((Object)("Opening channel '" + endpoint));
        }
        this.setState(ChannelState.Opening);
        if (this.connection != null) {
            this.connection.configure(null);
        }
        this.connection = this.createConnection(endpoint);
        this.assignConnectionInvoker(this.connection);
        this.applyConfiguration();
        if (this.protocolData != null) {
            this.initPackager(this.connection, this.protocolData);
        }
        Slot openSync = new Slot();
        this.setupConnection((Slot<Object>)openSync);
        try {
            this.connection.open();
        }
        catch (RuntimeException e) {
            this.setState(ChannelState.Closed, e);
            throw e;
        }
        catch (Exception e) {
            this.setState(ChannelState.Closed, e);
            throw new ProtocolException("Problems opening connection", e);
        }
        return openSync;
    }

    @Override
    protected void applyConfiguration() {
        ConnectionConfiguration config = this.getConfiguration();
        if (config != null && this.connection != null) {
            this.connection.configure(config);
        }
    }

    private void setState(ChannelState state, Throwable reason) {
        this.setState(state, new ConnectionClosedEvent((Object)this.connection, reason));
    }

    private void completeOpen(long connectTimeout, Slot<Object> openSync) throws ProtocolException, InterruptedException {
        this.waitForOpen(connectTimeout, openSync);
        if (log.isDebug()) {
            log.debug((Object)("Channel is opened '" + this.getEndpoint()));
        }
        try {
            this.onOpen();
        }
        catch (ProtocolException e) {
            this.setState(ChannelState.Closed, (Throwable)((Object)e));
            if (this.connection != null && this.connection.getConnectionState() != ConnectionState.CLOSED) {
                this.connection.forceClose();
                this.onClose(new ConnectionClosedEvent((Object)this, (Throwable)((Object)e)));
            }
            throw e;
        }
        Object openSyncState = openSync.peek();
        if (openSyncState != null && openSyncState instanceof Throwable) {
            this.setState(ChannelState.Closed, new ConnectionClosedEvent((Object)this, (Throwable)openSyncState));
            throw new ProtocolException("Error opening connection", (Throwable)openSyncState);
        }
    }

    private void initiateClose() {
        if (this.connection == null) {
            log.error((Object)"Connection is null in close operation");
            return;
        }
        if (log.isDebug()) {
            log.debug((Object)("Closing channel '" + this.getEndpoint()));
        }
        this.closeSync = new Slot();
        this.setState(ChannelState.Closing);
        this.connection.close();
    }

    private void completeClose(long closeTimeout) throws ProtocolException, InterruptedException {
        if (this.connection.getConnectionState() == ConnectionState.CLOSED) {
            log.debug((Object)"Connection is closed, no need to waitResponse");
            closeTimeout = 0L;
        }
        ConnectionClosedEvent event = this.waitForClose(closeTimeout);
        if (log.isDebug()) {
            log.debug((Object)("Channel is closed: '" + this.getEndpoint()));
        }
        if (event == null && closeTimeout > 0L) {
            this.getInvoker().invoke((Runnable)(AbstractChannel)this.new AbstractChannel.AsyncErrorNotifier((Throwable)((Object)new ProtocolException("timeout closing channel"))));
        }
        this.onClose(event);
    }

    private void setupConnection(Slot<Object> openSync) {
        DuplexChannelConnHandler handler = new DuplexChannelConnHandler(openSync, this.getEndpoint());
        this.connection.setConnectionHandler((ConnectionHandler)handler);
        ProtocolMessagePackagerImpl packager = new ProtocolMessagePackagerImpl(this.protocolFactory, this.getConfiguration(), handler, new PackagerErrorHandler());
        this.connection.setMessagePackager((MessagePackager)packager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOpen(long timeout, Slot<Object> openSync) throws ProtocolException, InterruptedException {
        Object openResult = this.waitForObject(openSync, timeout);
        if (openResult == null) {
            ProtocolException e = null;
            try {
                if (this.connection != null) {
                    this.connection.setConnectionHandler(null);
                    this.connection.close();
                }
                e = this.getTimeoutException("open", timeout);
                this.setState(ChannelState.Closed, (Throwable)((Object)e));
            }
            finally {
                if (e != null) {
                    throw e;
                }
            }
        }
        if (openResult instanceof Throwable) {
            this.setState(ChannelState.Closed, new ConnectionClosedEvent((Object)this, (Throwable)openResult));
            throw new ProtocolException("Error opening connection", (Throwable)openResult);
        }
    }

    private ConnectionClosedEvent waitForClose(long timeout) throws ProtocolException, InterruptedException {
        ConnectionClosedEvent waitResult = this.waitForObject(this.closeSync, timeout);
        if (waitResult == null) {
            this.getTimeoutException("close", timeout);
        }
        if (waitResult instanceof Throwable) {
            throw new ProtocolException("Error closing connection", (Throwable)waitResult);
        }
        ConnectionClosedEvent result = null;
        if (waitResult instanceof ConnectionClosedEvent) {
            result = waitResult;
        }
        return result;
    }

    protected boolean upgradeConnection() {
        if (this.connection instanceof StartTLSSupport) {
            try {
                ((StartTLSSupport)this.connection).startTLS();
                return true;
            }
            catch (GeneralSecurityException e) {
                log.debug((Object)"Failed to start TLS", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected boolean downgradeConnection() {
        if (this.connection instanceof StartTLSSupport) {
            try {
                ((StartTLSSupport)this.connection).stopTLS();
                return true;
            }
            catch (Exception e) {
                log.debug((Object)"Failed to stop TLS", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected boolean stopReading() {
        if (this.connection instanceof StartTLSSupport) {
            try {
                return ((StartTLSSupport)this.connection).stopReading();
            }
            catch (Exception e) {
                log.debug((Object)"Failed to stop reading from channel", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected boolean resumeReading() {
        if (this.connection instanceof StartTLSSupport) {
            try {
                return ((StartTLSSupport)this.connection).resumeReading();
            }
            catch (Exception e) {
                log.debug((Object)"Failed to resume reading from channel", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private class PackagerErrorHandler
    implements ProtocolMessagePackagerImpl.ErrorHandler {
        private PackagerErrorHandler() {
        }

        public void handleError(ProtocolException e) {
            ChannelErrorEvent event = new ChannelErrorEvent(DuplexChannel.this, (Throwable)((Object)e));
            DuplexChannel.this.getInvoker().invoke((Runnable)(AbstractChannel)DuplexChannel.this.new AbstractChannel.AsyncErrorNotifier(event));
        }
    }

    private class AsyncMessageNotifier
    implements Runnable {
        private final Message message;
        private final MessageHandler handler;

        public AsyncMessageNotifier(Message message, MessageHandler msgHandler) {
            this.message = message;
            this.handler = msgHandler;
        }

        public void run() {
            this.handler.onMessage(this.message);
        }
    }

    private class AsyncCloser
    implements Runnable {
        private AsyncCloser() {
        }

        public void run() {
            try {
                DuplexChannel.this.completeClose(DuplexChannel.this.getTimeout());
            }
            catch (ProtocolException e) {
                log.debug((Object)"Failed to complete close process", (Throwable)((Object)e));
                (AbstractChannel)DuplexChannel.this.new AbstractChannel.AsyncErrorNotifier((Throwable)((Object)e)).run();
            }
            catch (InterruptedException e) {
                log.debug((Object)"Interrupted in close", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncOpener
    implements Runnable {
        private Slot<Object> openSync;

        public AsyncOpener(Slot<Object> sync) {
            this.openSync = sync;
        }

        @Override
        public void run() {
            try {
                DuplexChannel.this.completeOpen(DuplexChannel.this.getTimeout(), (Slot<Object>)this.openSync);
            }
            catch (ProtocolException e) {
                log.debug((Object)"Failed to complete open process", (Throwable)((Object)e));
                DuplexChannel.this.setState(ChannelState.Closed, new ConnectionClosedEvent((Object)DuplexChannel.this.connection, (Throwable)((Object)e)));
            }
            catch (InterruptedException e) {
                log.debug((Object)"Interrupted in open", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DuplexChannelConnHandler
    implements ConnectionHandler,
    ProtocolMessagePackagerImpl.MessageHandler {
        private final Slot<Object> openSync;
        private final Endpoint endpoint;

        public DuplexChannelConnHandler(Slot<Object> sync, Endpoint endpoint) {
            this.openSync = sync;
            this.endpoint = endpoint;
        }

        public void onConnectionEstablished() {
            try {
                DuplexChannel.this.notifyWithObject(this.openSync, new Object());
            }
            catch (InterruptedException ignore) {
                log.debug((Object)"Thread interrupted waiting for the connection");
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void onMessage(Message message) {
            this.handleMessage(message);
        }

        public void onConnectionClosed(ConnectionClosedEvent event) {
            block8: {
                DuplexChannel.this.connection.setConnectionHandler(null);
                try {
                    ChannelState state = DuplexChannel.this.getState();
                    if (state == ChannelState.Opening) {
                        Object cause = event.getCause();
                        if (cause == null) {
                            cause = new ProtocolException("Unexpected close while opening connection");
                        }
                        DuplexChannel.this.notifyWithObject(this.openSync, cause);
                        DuplexChannel.this.closeOpening(event);
                        break block8;
                    }
                    if (state == ChannelState.Closing) {
                        try {
                            if (DuplexChannel.this.closeSync != null) {
                                DuplexChannel.this.closeSync.put((Object)event);
                            }
                            break block8;
                        }
                        catch (InterruptedException e) {
                            log.debug((Object)"Thread interrupted waiting for the close", (Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                        break block8;
                    }
                    DuplexChannel.this.setState(ChannelState.Closed, event);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"Thread interrupted waiting for close", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void handleMessage(Message message) {
            log.debugFormat("Handling message: {0}", (Object)message);
            if (dataLogger.isDebug()) {
                dataLogger.debugFormat("Handling message: {0}", (Object)message.toString(true, false));
            }
            if (message instanceof EndpointSupport) {
                ((EndpointSupport)((Object)message)).setEndpoint(this.endpoint);
            }
            if (message instanceof UpdatableProtocolId) {
                ((UpdatableProtocolId)((Object)message)).setProtocolId(DuplexChannel.this.getProtocolId());
            }
            if (DuplexChannel.this.manager != null) {
                DuplexChannel.this.manager.incMessagesReceivedNumber();
            }
            DuplexChannel.this.onReceiveMessage(message);
            if (log.isDebug()) {
                log.debug((Object)("Complete message handling: " + message.messageId()));
            }
        }
    }
}

