/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionAcceptor;
import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.connection.ConnectionListener;
import com.genesyslab.platform.commons.connection.ConnectionManager;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.KeyValueConfiguration;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.AbstractChannel;
import com.genesyslab.platform.commons.protocol.Channel;
import com.genesyslab.platform.commons.protocol.ChannelClosedEvent;
import com.genesyslab.platform.commons.protocol.ChannelErrorEvent;
import com.genesyslab.platform.commons.protocol.ChannelListener;
import com.genesyslab.platform.commons.protocol.ChannelNotClosedException;
import com.genesyslab.platform.commons.protocol.ChannelNotOpenedException;
import com.genesyslab.platform.commons.protocol.ChannelReceiverInitializationException;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.ConfigurationSupport;
import com.genesyslab.platform.commons.protocol.DuplexChannel;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.EndpointSupport;
import com.genesyslab.platform.commons.protocol.Listener;
import com.genesyslab.platform.commons.protocol.ListenerHelper;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.OutputChannel;
import com.genesyslab.platform.commons.protocol.OutputChannelListener;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolDescriptionSupport;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.QueueRequestReceiver;
import com.genesyslab.platform.commons.protocol.RequestContext;
import com.genesyslab.platform.commons.protocol.RequestReceiver;
import com.genesyslab.platform.commons.protocol.RequestReceiverManagement;
import com.genesyslab.platform.commons.protocol.RequestReceiverSupport;
import com.genesyslab.platform.commons.protocol.ResponseChannel;
import com.genesyslab.platform.commons.protocol.ServerChannelListener;
import com.genesyslab.platform.commons.protocol.ServerChannelManager;
import com.genesyslab.platform.commons.protocol.runtime.channel.ClientRequestHandlerImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerChannel
extends AbstractChannel
implements OutputChannel,
ResponseChannel,
RequestReceiver,
EndpointSupport,
ConfigurationSupport,
ProtocolDescriptionSupport,
RequestReceiverManagement {
    private RequestReceiverSupport receiver = new QueueRequestReceiver(128);
    private boolean externalReceiver = false;
    private ConnectionAcceptor acceptor;
    private ProtocolFactory protocolFactory;
    private Collection<OutputChannel> channels = new CopyOnWriteArrayList<OutputChannel>();
    private List<OutputChannelListener> outputChannelListeners = new CopyOnWriteArrayList<OutputChannelListener>();
    private ServerChannelManager manager;
    private static final ILogger log = Log.getLogger(ServerChannel.class);

    public ServerChannel(Endpoint endpoint, ProtocolFactory protocolFactory) {
        this(endpoint, 30000L, protocolFactory);
    }

    public ServerChannel(Endpoint endpoint, long timeout, ProtocolFactory protocolFactory) {
        super(timeout, endpoint);
        this.protocolFactory = protocolFactory;
        this.manager = ServerChannelManager.createManager(this);
        this.manager.initialize();
    }

    @Override
    public void open() throws ProtocolException, InterruptedException, ChannelNotClosedException {
        this.throwNotClosed();
        this.setState(ChannelState.Opening);
        this.manager.register();
        this.acceptor = this.createAcceptor();
        try {
            this.acceptor.startAccepting();
        }
        catch (IOException e) {
            throw new ProtocolException("Failed to start acceptor", e);
        }
        this.setState(ChannelState.Opened);
    }

    @Override
    public void open(long timeout) throws ProtocolException, InterruptedException, ChannelNotClosedException {
        this.open();
    }

    @Override
    public void close() throws ProtocolException, InterruptedException, IllegalStateException {
        this.doCloseListener();
        this.closeClientChannels();
    }

    @Override
    public void close(long timeout) throws ProtocolException, InterruptedException, IllegalStateException {
        this.close();
    }

    public void closeListener() throws ProtocolException, InterruptedException, IllegalStateException {
        this.doCloseListener();
        if (this.channels.isEmpty()) {
            this.manager.unregister();
        }
    }

    public void closeClientChannels() throws InterruptedException {
        for (OutputChannel channel : this.channels) {
            try {
                if (channel.getState() != ChannelState.Opened) continue;
                channel.close();
            }
            catch (ProtocolException e) {
                if (log.isWarn()) {
                    log.warn((Object)("Problems closing " + channel), (Throwable)((Object)e));
                }
                this.fireErrorEvent(new ChannelErrorEvent(channel, (Throwable)((Object)e)));
            }
        }
        this.channels.clear();
        if (this.getState() != ChannelState.Opened) {
            this.manager.unregister();
        }
    }

    @Override
    public void send(Message message) throws ProtocolException {
        this.sendToChannelsExcept(this.channels, message, null);
    }

    @Override
    public void addListener(OutputChannelListener listener) {
        if (this.outputChannelListeners.contains(listener)) {
            return;
        }
        this.outputChannelListeners.add(listener);
        for (OutputChannel ch : this.channels) {
            ch.addListener(listener);
        }
    }

    @Override
    public void removeListener(OutputChannelListener listener) {
        this.outputChannelListeners.remove(listener);
        for (OutputChannel ch : this.channels) {
            ch.removeListener(listener);
        }
    }

    public void sendToChannelsExcept(Message message, OutputChannel except) throws ProtocolException {
        this.sendToChannelsExcept(this.channels, message, except);
    }

    @Override
    public void beginOpen() throws ProtocolException {
        try {
            this.open();
        }
        catch (InterruptedException e) {
            log.warn((Object)"Interrupted in ServerSocket open()", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void beginClose() {
        try {
            this.close();
        }
        catch (InterruptedException e) {
            log.warn((Object)"Interrupted in ServerSocket open()", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ProtocolException e) {
            log.warn((Object)"Failed to close", (Throwable)((Object)e));
            this.fireErrorEvent((Throwable)((Object)e));
        }
    }

    @Override
    public RequestContext receiveRequest() throws InterruptedException {
        return this.receiveRequest(this.getTimeout());
    }

    @Override
    public RequestContext receiveRequest(long timeout) throws InterruptedException {
        if (this.getState() != ChannelState.Opened && this.channels.isEmpty()) {
            throw new ChannelNotOpenedException("No opened connections to receive requests");
        }
        return this.getInternalReceiver().receiveRequest(timeout);
    }

    public Collection<? extends Channel> getChannels() {
        return this.channels;
    }

    protected ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    protected void modifyNewChannel(DuplexChannel channel) {
        String protocolName;
        channel.setMessageHandler(new ClientRequestHandlerImpl(this.receiver, channel, this, this.protocolFactory));
        channel.addChannelListener(new ClientChannelListener());
        for (OutputChannelListener l : this.outputChannelListeners) {
            channel.addListener(l);
        }
        ConnectionConfiguration config = this.getConfiguration();
        if (null == config) {
            config = new KeyValueConfiguration(new KeyValueCollection());
        }
        if (null == (protocolName = config.getOption("protocol"))) {
            config.setOption("protocol", "addp");
        }
        config.setOption("x-addp-active", "false");
        channel.configure(config);
        channel.applyConfiguration();
    }

    protected void sendToChannelsExcept(Collection<OutputChannel> channels, Message message, OutputChannel except) throws ProtocolException {
        for (OutputChannel channel : channels) {
            if (channel == except) continue;
            try {
                channel.send(message);
            }
            catch (ProtocolException e) {
                if (log.isWarn()) {
                    log.warn((Object)("Problems sending to " + channel), (Throwable)((Object)e));
                }
                this.fireErrorEvent(new ChannelErrorEvent(channel, (Throwable)((Object)e)));
            }
        }
    }

    @Override
    public ProtocolDescription getProtocolDescription() {
        if (this.protocolFactory == null) {
            return null;
        }
        return this.protocolFactory.getProtocolDescription();
    }

    private ConnectionAcceptor createAcceptor() {
        this.throwNullEndpoint();
        Endpoint endpoint = this.getEndpoint();
        return ConnectionManager.createAcceptor((String)endpoint.getHost(), (int)endpoint.getPort(), (ConnectionListener)new ServerChannelConnectionListener(), this.connectionContext());
    }

    private void doCloseListener() {
        this.setState(ChannelState.Closing);
        this.acceptor.close();
        this.setState(ChannelState.Closed, new ConnectionClosedEvent((Object)this.acceptor, null));
    }

    private void handleNewConnection(Connection conn) {
        log.debugFormat("Handling new connection ''{0}''", (Object)conn);
        DuplexChannel channel = new DuplexChannel(conn, this.protocolFactory, this.getTimeout());
        channel.manager = this.manager;
        conn.setContext(channel.connectionContext());
        this.channels.add(channel);
        this.modifyNewChannel(channel);
        channel.setState(ChannelState.Opened);
        this.fireNewChannel(channel);
        this.manager.incClientsAcceptedNumber();
    }

    private void fireNewChannel(DuplexChannel channel) {
        if (log.isDebug()) {
            log.debug((Object)"Firing 'onClientChannelOpened'");
        }
        this.getInvoker().invoke((Runnable)new NewChanelVisitor(channel));
    }

    public Message receive() throws InterruptedException, IllegalStateException {
        return this.receive(this.getTimeout());
    }

    public Message receive(long timeout) throws InterruptedException, IllegalStateException {
        RequestContext context = this.receiveRequest(timeout);
        if (context == null) {
            return null;
        }
        return context.getRequestMessage();
    }

    @Override
    public void clearInput() {
        this.receiver.clearInput();
    }

    @Override
    public int getInputSize() {
        return this.receiver.getInputSize();
    }

    @Override
    public void setInputSize(int inputSize) {
        this.getInternalReceiver().setInputSize(inputSize);
    }

    @Override
    public void releaseReceivers() {
        this.getInternalReceiver().releaseReceivers();
    }

    @Override
    protected void applyConfiguration() {
    }

    @Override
    public void setReceiver(RequestReceiverSupport receiver) {
        this.throwNotClosed();
        this.externalReceiver = true;
        this.doSetReceiver(receiver);
    }

    @Override
    public void resetReceiver() {
        this.throwNotClosed();
        this.externalReceiver = false;
        QueueRequestReceiver internalReceiver = new QueueRequestReceiver(128);
        this.doSetReceiver(internalReceiver);
    }

    private RequestReceiver getInternalReceiver() {
        if (this.externalReceiver) {
            throw new ChannelReceiverInitializationException("External receiver is set, use its methods instead");
        }
        return this.receiver;
    }

    private void doSetReceiver(RequestReceiverSupport receiver) {
        this.removeChannelListener(this.receiver);
        this.receiver = receiver;
        this.addChannelListener(receiver);
    }

    private class ClosedChanelVisitor
    implements ListenerHelper.NotificationVisitor {
        private ChannelClosedEvent event;

        public ClosedChanelVisitor(ChannelClosedEvent event) {
            this.event = event;
        }

        public void visitListener(Listener listener) {
            if (listener instanceof ServerChannelListener) {
                ServerChannelListener chL = (ServerChannelListener)listener;
                chL.onClientChannelClosed(this.event);
            }
        }
    }

    private class ClientChannelListener
    implements ChannelListener {
        private ClientChannelListener() {
        }

        public void onChannelOpened(EventObject event) {
        }

        public void onChannelClosed(ChannelClosedEvent event) {
            ListenerHelper helper = ServerChannel.this.getListenerHelper();
            helper.notifyListeners(new ClosedChanelVisitor(event));
            helper.removeListener(this);
            ServerChannel.this.channels.remove(event.getSource());
            if (ServerChannel.this.channels.isEmpty() && ServerChannel.this.getState() != ChannelState.Opened) {
                ServerChannel.this.releaseReceivers();
                ServerChannel.this.manager.unregister();
            }
        }

        public void onChannelError(ChannelErrorEvent event) {
        }
    }

    private class NewChanelVisitor
    implements ListenerHelper.NotificationVisitor,
    Runnable {
        private OutputChannel newChannel;

        public NewChanelVisitor(OutputChannel channel) {
            this.newChannel = channel;
        }

        public void visitListener(Listener listener) {
            if (listener instanceof ServerChannelListener) {
                ServerChannelListener chL = (ServerChannelListener)listener;
                chL.onClientChannelOpened(this.newChannel);
            }
        }

        public void run() {
            ServerChannel.this.getListenerHelper().notifyListeners(this);
        }
    }

    private class ServerChannelConnectionListener
    implements ConnectionListener {
        private ServerChannelConnectionListener() {
        }

        public void onNewConnection(Connection conn) {
            ServerChannel.this.handleNewConnection(conn);
        }
    }
}

