/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.auth;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.auth.AcceptKerberosTicketAction;
import com.genesyslab.platform.commons.protocol.auth.AuthTicket;
import com.genesyslab.platform.commons.protocol.auth.AuthTicketData;
import com.genesyslab.platform.commons.protocol.auth.KerberosUtil;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.File;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosTicketAcceptor {
    private static final ILogger log = Log.getLogger(KerberosTicketAcceptor.class);
    private String servicePrincipalName;
    private String keyTableFilePath;
    private Map<String, String> kerberosOptions;
    private Subject subject;
    private Krb5LoginModule loginModule;

    public KerberosTicketAcceptor(Subject subject, String servicePrincipalName, String keyTableFilePath) throws LoginException {
        Subject subject2 = this.subject = null == subject ? new Subject() : subject;
        if (null == servicePrincipalName) {
            throw new IllegalArgumentException("servicePrincipalName must not be null");
        }
        if (0 == servicePrincipalName.length()) {
            throw new IllegalArgumentException("servicePrincipalName must not be empty");
        }
        this.servicePrincipalName = servicePrincipalName;
        if (null == keyTableFilePath) {
            throw new IllegalArgumentException("keyTableFilePath must not be null");
        }
        this.keyTableFilePath = keyTableFilePath;
        File keyTableFile = new File(keyTableFilePath);
        if (!keyTableFile.exists()) {
            throw new IllegalArgumentException("Could not find file specified by keyTableFilePath, resolved path is: " + keyTableFile.getAbsolutePath());
        }
        this.kerberosOptions = this.createKerberosOptions(servicePrincipalName, keyTableFilePath);
        this.login();
    }

    private void login() throws LoginException {
        this.loginModule = new Krb5LoginModule();
        this.loginModule.initialize(this.subject, null, null, this.kerberosOptions);
        this.loginModule.login();
        this.loginModule.commit();
    }

    private Map<String, String> createKerberosOptions(String servicePrincipalName, String keyTableFilePath) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("principal", servicePrincipalName);
        result.put("doNotPrompt", "true");
        result.put("useTicketCache", "false");
        result.put("useKeyTab", "true");
        result.put("keyTab", keyTableFilePath);
        result.put("storeKey", "true");
        result.put("isInitiator", "false");
        return result;
    }

    public String getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    public String getKeyTablePath() {
        return this.keyTableFilePath;
    }

    public Map<String, String> getKerberosOptions() {
        return new HashMap<String, String>(this.kerberosOptions);
    }

    public AuthTicket acceptTicket(AuthTicket ticket) throws GeneralSecurityException {
        if (null == ticket) {
            return null;
        }
        if (null != ticket.getServicePrincipalName() && !this.servicePrincipalName.equals(ticket.getServicePrincipalName())) {
            log.warn((Object)("Error accepting Kerberos ticket: ticket.servicePrincipalName (" + ticket.getServicePrincipalName() + ") does not match acceptor's (" + this.servicePrincipalName + ")"));
            return null;
        }
        if (null == ticket.getTicketBytes()) {
            log.warn((Object)"Error accepting Kerberos ticket: ticket.ticketBytes is null");
            return null;
        }
        if (0 == ticket.getTicketBytes().length) {
            log.warn((Object)"Error accepting Kerberos ticket: ticket.ticketBytes is empty");
            return null;
        }
        AcceptKerberosTicketAction action = new AcceptKerberosTicketAction(ticket.getTicketBytes(), this.servicePrincipalName);
        String userPrincipalName = null;
        try {
            userPrincipalName = Subject.doAsPrivileged(this.subject, action, null);
        }
        catch (PrivilegedActionException e) {
            log.error((Object)"Error accepting Kerberos ticket", (Throwable)e);
        }
        if (null == userPrincipalName) {
            return null;
        }
        KerberosTicket kt = KerberosUtil.getKerberosTicket(this.subject, this.servicePrincipalName);
        if (null == kt) {
            return new AuthTicketData(ticket.getTicketBytes(), this.servicePrincipalName, userPrincipalName, ticket.getUseGSS());
        }
        return new AuthTicketData(ticket.getTicketBytes(), this.servicePrincipalName, userPrincipalName, kt.getAuthTime(), kt.getStartTime(), kt.getEndTime(), kt.getRenewTill(), ticket.getUseGSS());
    }
}

