/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.auth.asn1;

import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.auth.asn1.ApplicationAttribute;
import com.genesyslab.platform.commons.protocol.auth.asn1.Attribute;
import com.genesyslab.platform.commons.protocol.auth.asn1.ContextAttribute;
import com.genesyslab.platform.commons.protocol.auth.asn1.PrivateAttribute;
import com.genesyslab.platform.commons.protocol.auth.asn1.UniversalAttribute;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributeBase
implements Attribute {
    private byte[] data;
    private int startIndex;
    private int codeLength;
    private int lengthLength;
    private int length;
    private int dataLength;
    private int dataIndex;
    private boolean complex;
    private List<Attribute> children;

    AttributeBase(byte[] data, int index) throws ProtocolException {
        this.data = data;
        this.checkIndex(index);
        this.startIndex = index;
        this.complex = (data[index] & 0x20) == 32;
        this.codeLength = this.parseCodeLength(index);
        this.lengthLength = this.parseLengthLength(index + this.codeLength);
        this.dataLength = this.parseDataLength(index + this.codeLength, this.lengthLength);
        this.length = this.codeLength + this.lengthLength + this.dataLength;
        this.dataIndex = index + this.codeLength + this.lengthLength;
        int nextStart = this.startIndex + this.length;
        if (this.dataIndex + this.dataLength != this.startIndex + this.length) {
            throw new ProtocolException("Error parsing ASN.1 message");
        }
        this.checkIndex(nextStart - 1);
        if (this.complex) {
            Attribute child;
            this.children = new ArrayList<Attribute>();
            for (int childIndex = this.dataIndex; childIndex < nextStart; childIndex += child.getLength()) {
                child = AttributeBase.parseChild(data, childIndex);
                this.children.add(child);
            }
        }
    }

    static Attribute parseChild(byte[] data, int index) throws ProtocolException {
        byte type = (byte)(data[index] >> 6 & 3);
        switch (type) {
            case 0: {
                return new UniversalAttribute(data, index);
            }
            case 1: {
                return new ApplicationAttribute(data, index);
            }
            case 2: {
                return new ContextAttribute(data, index);
            }
            case 3: {
                return new PrivateAttribute(data, index);
            }
        }
        throw new ProtocolException("Error parsing ASN.1 message");
    }

    private int parseDataLength(int index, int length) throws ProtocolException {
        this.checkIndex(index);
        if (length == 1) {
            return this.data[index];
        }
        ++index;
        --length;
        int result = 0;
        while (length > 0) {
            result <<= 8;
            result += this.data[index] & 0xFF;
            --length;
            this.checkIndex(++index);
        }
        return result;
    }

    private int parseLengthLength(int index) throws ProtocolException {
        this.checkIndex(index);
        int length = 1;
        if ((byte)(this.data[index] & 0x80) == 0) {
            return length;
        }
        return length + (this.data[index] & 0x7F);
    }

    private int parseCodeLength(int index) throws ProtocolException {
        this.checkIndex(index);
        int length = 1;
        byte b = (byte)(this.data[index] & 0x1F);
        if (b < 31) {
            return length;
        }
        do {
            this.checkIndex(++index);
            ++length;
        } while ((this.data[index] & 0x80) != 0);
        return length;
    }

    private void checkIndex(int index) throws ProtocolException {
        if (index >= this.data.length) {
            throw new ProtocolException("Error parsing ASN.1 message");
        }
    }

    @Override
    public byte[] getAttributeBytes() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.data, this.startIndex, result, 0, this.length);
        return result;
    }

    @Override
    public byte[] getDataBytes() {
        byte[] result = new byte[this.dataLength];
        System.arraycopy(this.data, this.dataIndex, result, 0, this.dataLength);
        return result;
    }

    @Override
    public List<Attribute> getChildren() {
        return this.children;
    }

    @Override
    public int getCodeLength() {
        return this.codeLength;
    }

    @Override
    public int getLengthLength() {
        return this.lengthLength;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public boolean isComplex() {
        return this.complex;
    }
}

