/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime.channel;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.runtime.channel.GrowingBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueueSupport<T> {
    private final ILogger log = Log.getLogger(QueueSupport.class);
    private final Object overflowGuard = new Object();
    private BlockingQueue<T> queue;
    private QueueOverflowHandler<T> overflowHandler;
    private AtomicInteger blockedReceiversCnt = new AtomicInteger(0);
    private T fake;
    private static final int DEF_MAX_CAPACITY = 4096;
    private int maxCapacity = 4096;

    public QueueSupport(BlockingQueue<T> queue, T fake) {
        this.queue = queue;
        this.fake = fake;
        int cap = queue.remainingCapacity();
        if (cap > this.maxCapacity) {
            this.maxCapacity = cap;
        }
    }

    public void setOverflowHandler(QueueOverflowHandler<T> overflowHandler) {
        this.overflowHandler = overflowHandler;
    }

    public void drainQueue() {
        try {
            this.queue.clear();
        }
        catch (UnsupportedOperationException e) {
            try {
                T msg = this.queue.poll(0L, TimeUnit.MILLISECONDS);
                while (msg != null) {
                    msg = this.queue.poll(0L, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e2) {
                this.log.debug((Object)"Interrupted clearing queue");
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueObject(T obj, long enqueTimeout) {
        block9: {
            try {
                boolean isPut = this.queue.offer(obj, enqueTimeout, TimeUnit.MILLISECONDS);
                if (isPut) break block9;
                Object object = this.overflowGuard;
                synchronized (object) {
                    if (!this.queue.offer(obj, 0L, TimeUnit.MILLISECONDS)) {
                        if (this.overflowHandler != null) {
                            this.overflowHandler.handleOverflow(obj);
                        } else {
                            this.removeOldest(obj);
                            this.log.warn((Object)"Input queue overflow! Some messages are lost");
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                if (this.log.isDebug()) {
                    this.log.debug((Object)"Interuupted while putting message to queue", (Throwable)e);
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T dequeObject(long timeout) throws InterruptedException {
        T obj = null;
        this.blockedReceiversCnt.incrementAndGet();
        try {
            obj = timeout < 0L ? (T)this.queue.take() : (T)this.queue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        finally {
            this.blockedReceiversCnt.decrementAndGet();
        }
        if (obj == this.fake) {
            return null;
        }
        return obj;
    }

    public void releaseReceivers() {
        try {
            int cnt = this.blockedReceiversCnt.get();
            while (cnt-- > 0) {
                this.queue.offer(this.fake, 20L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            this.log.debug((Object)"Interrupted while releasing receivers");
            Thread.currentThread().interrupt();
        }
    }

    public int getCapacity() {
        return this.queue.size();
    }

    public void setCapacity(int capacity) {
        if (capacity < 4) {
            capacity = 4;
        }
        if (capacity > this.maxCapacity) {
            capacity = this.maxCapacity;
        }
        if (this.queue instanceof GrowingBlockingQueue) {
            ((GrowingBlockingQueue)this.queue).growQueue(capacity);
        }
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public BlockingQueue getQueue() {
        return this.queue;
    }

    public Object removeOldest(T obj) throws InterruptedException {
        T latest;
        boolean isPut;
        do {
            latest = this.queue.poll(0L, TimeUnit.MILLISECONDS);
        } while (!(isPut = this.queue.offer(obj, 0L, TimeUnit.MILLISECONDS)));
        return latest;
    }

    public void growQueue(T obj) throws InterruptedException {
        int capacity = this.queue.size();
        if (capacity >= this.maxCapacity) {
            this.log.warn((Object)"Maximum queue size reached, removing the oldest elements");
            this.removeOldest(obj);
            return;
        }
        int newCapacity = capacity * 2;
        if (newCapacity > this.maxCapacity) {
            newCapacity = this.maxCapacity;
        }
        this.setCapacity(newCapacity);
        boolean isPut = this.queue.offer(obj, 0L, TimeUnit.MILLISECONDS);
        if (!isPut) {
            this.log.warn((Object)"Can't put to increased queue, removing the oldest elements");
            this.removeOldest(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface QueueOverflowHandler<T> {
        public void handleOverflow(T var1) throws InterruptedException;
    }
}

