/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.protocol.ConfigurationSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.TKVCodec;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;

public class XkvToKvCodec
implements AttributeTypeCodec,
ConfigurationSupport,
EncodingSupport {
    private TKVCodec kvCodec = new TKVCodec();

    public ConnectionConfiguration getConfiguration() {
        return this.kvCodec.getConfiguration();
    }

    public void configure(ConnectionConfiguration config) {
        this.kvCodec.configure(config);
    }

    public void setStringAttributesEncoding(String strEncoding) {
        this.kvCodec.setStringAttributesEncoding(strEncoding);
    }

    public String getNS() {
        return null;
    }

    public Object decodeFromConnection(Object value, AttributeDescription ai) throws CodecException {
        if (value instanceof byte[]) {
            return XKVSerializer.deserialize((byte[])value, this.kvCodec.getStringAttributesEncoding());
        }
        return null;
    }

    public void setProtocolData(Object protocolData) {
    }

    public void setMessage(Message message) {
    }

    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        if (customTypeObject instanceof KeyValueCollection) {
            byte[] bytes = XKVSerializer.getBytes((KeyValueCollection)customTypeObject, this.kvCodec.getStringAttributesEncoding());
            return transport.onAttribute(transportState, id, bytes);
        }
        return null;
    }

    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        if (!(customTypeObject instanceof KeyValueCollection)) {
            throw new CodecException("customTypeObject is not valid");
        }
        this.kvCodec.encodeToXml(customTypeObject, attributeElement);
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription ai) throws CodecException {
        return this.kvCodec.decodeFromXml(attributeElement, ai);
    }

    public String getLogType() {
        return "kvlist";
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) {
        if (customTypeObject instanceof KeyValueCollection) {
            buf.append(((KeyValueCollection)customTypeObject).toString());
        }
    }

    protected static class XKVSerializer {
        private static int[] VLP_MAX = new int[]{126, 16383, 0x1FFFFF, 0x10000000, Integer.MAX_VALUE};
        private static final int STRING_SIGNATURE = 0;
        private static final int INT_SIGNATURE = 1;
        private static final int BINARY_SIGNATURE = 2;
        private static final int LIST_SIGNATURE = 3;
        private static final int UTF_SIGNATURE = 5;
        private static final int LONG_SIGNATURE = 6;
        private static final int FLOAT_SIGNATURE = 7;
        private static final int TERMINATOR = 237;
        private static final int MAX_VLP_SIZE = 5;

        protected XKVSerializer() {
        }

        public static byte[] getBytes(KeyValueCollection list) throws CodecException {
            return XKVSerializer.getBytes(list, null);
        }

        public static byte[] getBytes(KeyValueCollection list, String encoding) throws CodecException {
            byte[] b = new byte[XKVSerializer.getListSize(list, encoding)];
            XKVSerializer.pack(list, b, encoding);
            return b;
        }

        private static int getListSize(KeyValueCollection list, String encoding) throws CodecException {
            int len = 3;
            for (Object obj : list) {
                KeyValuePair pair = (KeyValuePair)obj;
                Object val = pair.getValue();
                if (val == null) continue;
                String key = pair.getStringKey();
                ++len;
                len += XKVSerializer.keySize(key, encoding);
                len += XKVSerializer.valueSize(val, encoding);
            }
            return len;
        }

        private static int keySize(String s, String encoding) throws CodecException {
            byte[] bytes;
            if (encoding != null) {
                try {
                    bytes = s.getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new CodecException("Error calculating string size", e);
                }
            } else {
                bytes = s.getBytes();
            }
            int i = bytes.length;
            return XKVSerializer.VLPSize(i) + i + 1;
        }

        private static int valueSize(Object obj, String encoding) throws CodecException {
            if (obj instanceof byte[]) {
                int valLength = ((byte[])obj).length;
                return XKVSerializer.VLPSize(valLength) + valLength;
            }
            if (obj instanceof Integer) {
                return XKVSerializer.VLPSize((Integer)obj);
            }
            if (obj instanceof Long) {
                return 8;
            }
            if (obj instanceof String) {
                return XKVSerializer.keySize((String)obj, encoding);
            }
            if (obj instanceof KeyValueCollection) {
                int valLength = XKVSerializer.getListSize((KeyValueCollection)obj, encoding);
                return valLength + 5;
            }
            throw new CodecException("unexpected pair type");
        }

        private static int VLPSize(int N) {
            int i;
            if (N < 0) {
                return 1 + XKVSerializer.VLPSize(-N);
            }
            for (i = 0; i < 5 && N > VLP_MAX[i]; ++i) {
            }
            return i + 1;
        }

        private static void pack(KeyValueCollection list, byte[] b, String enc) throws CodecException {
            int k = 0;
            b[k++] = -59;
            b[k++] = 96;
            for (Object obj : list) {
                KeyValuePair pair = (KeyValuePair)obj;
                Object val = pair.getValue();
                if (val == null) continue;
                String key = pair.getStringKey();
                k += XKVSerializer.writeHead(val, b, k);
                k += XKVSerializer.writeKey(key, b, k, enc);
                k += XKVSerializer.writeValue(val, b, k, enc);
            }
            b[k] = -19;
        }

        private static int writeHead(Object val, byte[] b, int index) throws CodecException {
            b[index] = (byte)XKVSerializer.typeFlags(val);
            return 1;
        }

        private static int getPairTypeSignature(Object val) throws CodecException {
            if (val instanceof byte[]) {
                return 2;
            }
            if (val instanceof Integer) {
                return 1;
            }
            if (val instanceof Long) {
                return 6;
            }
            if (val instanceof String) {
                return 0;
            }
            if (val instanceof KeyValueCollection) {
                return 3;
            }
            throw new CodecException("unexpected pair type");
        }

        private static int typeFlags(Object val) throws CodecException {
            int tf = XKVSerializer.getPairTypeSignature(val) & 0xF;
            return tf += 0;
        }

        private static int writeKey(String key, byte[] b, int k, String enc) throws CodecException {
            return XKVSerializer.XkvPackString(b, k, key, enc);
        }

        private static int writeValue(Object val, byte[] b, int k, String enc) throws CodecException {
            if (val instanceof String) {
                return XKVSerializer.XkvPackString(b, k, (String)val, enc);
            }
            if (val instanceof Integer) {
                return XKVSerializer.putVLP(b, k, (Integer)val);
            }
            if (val instanceof byte[]) {
                byte[] bytes = (byte[])val;
                return XKVSerializer.putBytes(bytes, b, k);
            }
            if (val instanceof KeyValueCollection) {
                byte[] bytes = XKVSerializer.getBytes((KeyValueCollection)val, enc);
                return XKVSerializer.putBytes(bytes, b, k);
            }
            if (val instanceof Long) {
                return XKVSerializer.putLong(b, k, (Long)val);
            }
            throw new CodecException("unexpected pair type");
        }

        private static int XkvPackString(byte[] b, int offset, String s, String enc) throws CodecException {
            try {
                byte[] bytes = enc == null ? s.getBytes() : s.getBytes(enc);
                int bytesLength = bytes.length;
                int len = XKVSerializer.putVLP(b, offset, bytesLength);
                System.arraycopy(bytes, 0, b, offset + len, bytesLength);
                b[offset + len + bytesLength] = 0;
                return len + bytesLength + 1;
            }
            catch (UnsupportedEncodingException e) {
                throw new CodecException("Error packing", e);
            }
        }

        private static int putVLP(byte[] b, int offset, int N) {
            if (N < 0) {
                b[offset] = -1;
                return XKVSerializer.putVLP(b, offset + 1, -N) + 1;
            }
            int lN = N;
            int len = XKVSerializer.VLPSize(lN);
            int i = len - 1;
            b[offset + i] = (byte)(0x80 | lN & 0x7F);
            for (i = len - 2; i >= 0; --i) {
                b[offset + i] = (byte)((lN >>= 7) & 0x7F);
            }
            return len;
        }

        private static int putLong(byte[] b, int k, long value) {
            int j = 0;
            int i = 7;
            while (i >= 0) {
                b[k + i] = (byte)(value >> j * 8 & 0xFFL);
                --i;
                ++j;
            }
            return 8;
        }

        private static int putBytes(byte[] src, byte[] dst, int k) {
            int bLen = src.length;
            int vlpLen = XKVSerializer.putVLP(dst, k, bLen);
            System.arraycopy(src, 0, dst, k + vlpLen, bLen);
            return vlpLen + bLen;
        }

        public static KeyValueCollection deserialize(byte[] b) throws CodecException {
            return XKVSerializer.deserialize(b, null);
        }

        public static KeyValueCollection deserialize(byte[] b, String encoding) throws CodecException {
            String sErr = "Deserialize: packed data incorrect or corrupt";
            if (b[0] != -59 || b[1] != 96) {
                throw new CodecException(sErr);
            }
            int k = 2;
            String s = null;
            Object key = null;
            Object value = null;
            KeyValueCollection kvList = new KeyValueCollection();
            try {
                while (k < b.length && b[k] != -19) {
                    int N;
                    int len;
                    int type;
                    if (((type = b[k++]) & 0x80) != 0) {
                        type &= 0x7F;
                    }
                    int kType = XKVSerializer.extractKeyType(type);
                    switch (kType) {
                        case 0: {
                            len = XKVSerializer.getVLP(b, k);
                            k = XKVSerializer.skipVLP(b, k);
                            if (b[k + len] != 0) {
                                throw new Exception(sErr);
                            }
                            int keyLen = 0;
                            while (b[k + keyLen] != 0) {
                                ++keyLen;
                            }
                            s = XKVSerializer.getString(b, k, keyLen, encoding);
                            key = s;
                            k += len + 1;
                            break;
                        }
                        case 1: {
                            N = XKVSerializer.getVLP(b, k);
                            k = XKVSerializer.skipVLP(b, k);
                            key = N;
                            break;
                        }
                        default: {
                            throw new Exception(sErr);
                        }
                    }
                    int utype = XKVSerializer.extractValueType(type);
                    switch (utype) {
                        case 5: {
                            len = XKVSerializer.getVLP(b, k);
                            k = XKVSerializer.skipVLP(b, k);
                            if (b[k + len] != 0) {
                                throw new Exception(sErr);
                            }
                            s = XKVSerializer.getString(b, k, len, encoding);
                            value = s;
                            k += len + 1;
                            break;
                        }
                        case 0: {
                            len = XKVSerializer.getVLP(b, k);
                            k = XKVSerializer.skipVLP(b, k);
                            if (b[k + len] != 0) {
                                throw new Exception(sErr);
                            }
                            s = XKVSerializer.getString(b, k, len, encoding);
                            value = s;
                            k += len + 1;
                            break;
                        }
                        case 1: {
                            N = XKVSerializer.getVLP(b, k);
                            k = XKVSerializer.skipVLP(b, k);
                            value = N;
                            break;
                        }
                        case 2: {
                            int i;
                            len = XKVSerializer.getVLP(b, k);
                            k = XKVSerializer.skipVLP(b, k);
                            byte[] bVal = new byte[len];
                            for (i = 0; i < len; ++i) {
                                bVal[i] = b[k + i];
                            }
                            value = bVal;
                            k += len;
                            break;
                        }
                        case 3: {
                            int i;
                            len = XKVSerializer.getVLP(b, k);
                            k = XKVSerializer.skipVLP(b, k);
                            byte[] bVal = new byte[len];
                            for (i = 0; i < len; ++i) {
                                bVal[i] = b[k + i];
                            }
                            value = XKVSerializer.deserialize(bVal, encoding);
                            k += len;
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 6: {
                            value = XKVSerializer.getLong(b, k);
                            k += 8;
                            break;
                        }
                        case 7: {
                            len = XKVSerializer.getVLP(b, k);
                            k = XKVSerializer.skipVLP(b, k);
                            s = XKVSerializer.getString(b, k, len, encoding);
                            value = s;
                            k += len + 1;
                            break;
                        }
                        default: {
                            throw new Exception(sErr);
                        }
                    }
                    kvList.addObject(XKVSerializer.getAttributeName(key), value);
                }
            }
            catch (Exception e) {
                throw new CodecException(sErr, e);
            }
            return kvList;
        }

        private static int extractKeyType(int n) {
            return (n & 0xF0) >> 4;
        }

        private static int extractValueType(int type) {
            return type & 0xF;
        }

        private static String getAttributeName(Object key) {
            String strKey = "";
            strKey = key instanceof String ? (String)key : key.toString();
            return strKey.toUpperCase();
        }

        private static String getString(byte[] buf, int ptr, int len, String enc) throws CodecException {
            try {
                if (enc != null) {
                    return new String(buf, ptr, len, enc);
                }
                return new String(buf, ptr, len);
            }
            catch (UnsupportedEncodingException e) {
                throw new CodecException("Error unpacking string value", e);
            }
        }

        private static int getShort(byte[] buf, int ptr) {
            return (0xFF00 & buf[ptr] << 8) + (0xFF & buf[ptr + 1]);
        }

        private static int getInt(byte[] buf, int ptr) {
            return (0xFF000000 & buf[ptr] << 24) + (0xFF0000 & buf[ptr + 1] << 16) + (0xFF00 & buf[ptr + 2] << 8) + (0xFF & buf[ptr + 3]);
        }

        private static long getLong(byte[] buf, int pointer) {
            long l = (long)(buf[pointer] & 0xFF) << 56 | (long)(buf[pointer + 1] & 0xFF) << 48 | (long)(buf[pointer + 2] & 0xFF) << 40 | (long)(buf[pointer + 3] & 0xFF) << 32 | (long)(buf[pointer + 4] & 0xFF) << 24 | (long)(buf[pointer + 5] & 0xFF) << 16 | (long)(buf[pointer + 6] & 0xFF) << 8 | (long)(buf[pointer + 7] & 0xFF);
            return l;
        }

        private static int skipVLP(byte[] b, int k) {
            int N = 0;
            if (b[k] == -1) {
                return XKVSerializer.skipVLP(b, k + 1);
            }
            int kn = k;
            do {
                N = N << 7 | b[kn] & 0x7F;
            } while ((b[kn++] & 0x80) == 0);
            return kn;
        }

        private static int getVLP(byte[] b, int k) {
            int N = 0;
            if (b[k] == -1) {
                N = XKVSerializer.getVLP(b, k + 1);
                N = -N;
                return N;
            }
            int kn = k;
            do {
                N = N << 7 | b[kn] & 0x7F;
            } while ((b[kn++] & 0x80) == 0);
            return N;
        }
    }
}

