/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol;

import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ClientChannel;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.IntReferenceBuilder;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.ReferenceBuilder;
import com.genesyslab.platform.commons.protocol.RegistrationException;
import com.genesyslab.platform.management.protocol.ApplicationExecutionMode;
import com.genesyslab.platform.management.protocol.ApplicationStatus;
import com.genesyslab.platform.management.protocol.LocalControlAgentProtocolHandshakeOptions;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventInitHeartbeats;
import com.genesyslab.platform.management.protocol.localcontrolagent.runtime.LocalControlAgentInternalProtocolFactory;
import com.genesyslab.platform.management.protocol.localcontrolagent.runtime.channel.EventApplicationRegistered;
import com.genesyslab.platform.management.protocol.localcontrolagent.runtime.channel.RequestRegisterApplication;
import com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime.LcaUdpHeartbeatInternalProtocol;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;

@ProtocolDescription.Tag(sdkName="Management", protocolName="LocalControlAgent")
public final class LocalControlAgentProtocol
extends ClientChannel
implements LocalControlAgentProtocolHandshakeOptions {
    private static final String DEFAULT_PASSWORD = "rcc";
    private int clientId = 0;
    private String clientName = "";
    private Integer status = null;
    private ApplicationExecutionMode executionMode = ApplicationExecutionMode.Primary;
    private Integer applicationType;
    private int processId;
    private LcaUdpHeartbeatInternalProtocol heartbeatProtocol = null;
    private static final ILogger log = Log.getLogger(LocalControlAgentProtocol.class);

    public LocalControlAgentProtocol(Endpoint endpoint) throws ProtocolException {
        super(endpoint, (ProtocolFactory)new LocalControlAgentInternalProtocolFactory(), (ReferenceBuilder)new IntReferenceBuilder());
        try {
            if (!InetAddress.getByName(endpoint.getHost()).isLoopbackAddress()) {
                throw new ProtocolException("Only loopback (localhost or ::1) connection is supported");
            }
        }
        catch (UnknownHostException e) {
            throw new ProtocolException("Unknown host.", (Throwable)e);
        }
        this.status = ApplicationStatus.Initializing.asInteger();
        this.processId = LocalControlAgentProtocol.getJvmProcessId();
    }

    public LocalControlAgentProtocol(int lcaPort) throws ProtocolException {
        this(new Endpoint("lca", "localhost", lcaPort));
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setControlStatus(Integer appStatus) {
        this.status = appStatus;
    }

    public Integer getControlStatus() {
        return this.status;
    }

    public void setExecutionMode(ApplicationExecutionMode execMode) {
        this.executionMode = execMode;
    }

    public ApplicationExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public int getClientId() {
        return this.clientId;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public Integer getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(Integer applicationType) {
        this.applicationType = applicationType;
    }

    protected void onOpen() throws ProtocolException {
        this.setRegistrationHandler((ClientChannel.RegistrationHandler)new LCARegistrationHandler(this));
        super.onOpen();
    }

    protected void onClose(ConnectionClosedEvent event) {
        if (this.heartbeatProtocol != null) {
            try {
                this.heartbeatProtocol.close();
            }
            catch (Exception e) {
                log.warn((Object)"Exception closing heartbeat connection", (Throwable)e);
            }
            this.heartbeatProtocol = null;
        }
        super.onClose(event);
    }

    protected void onReceiveMessage(Message event) {
        if (event instanceof EventInitHeartbeats) {
            EventInitHeartbeats initHB = (EventInitHeartbeats)event;
            if (this.heartbeatProtocol == null) {
                this.heartbeatProtocol = new LcaUdpHeartbeatInternalProtocol(this);
            }
            this.heartbeatProtocol.heartbeatUpdateParameters(this.getProcessId(), initHB.getHeartbeatPeriod(), this.getEndpoint().getHost(), initHB.getHeartbeatPort());
            super.onReceiveMessage(event);
        } else {
            super.onReceiveMessage(event);
        }
    }

    private static int getJvmProcessId() {
        int res = -1;
        try {
            String jvmid = ManagementFactory.getRuntimeMXBean().getName();
            int pos = jvmid.indexOf(64);
            if (pos > 0) {
                res = Integer.parseInt(jvmid.substring(0, pos));
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Exception while getting JVM PID", e);
        }
        return res;
    }

    private class LCARegistrationHandler
    extends ClientChannel.SimpleRegistrationHandler {
        private LocalControlAgentProtocol channel;

        public LCARegistrationHandler(LocalControlAgentProtocol ch) {
            super((ClientChannel)LocalControlAgentProtocol.this);
            this.channel = null;
            this.channel = ch;
        }

        protected boolean isResponseAccepted(Message responce) throws RegistrationException {
            ILogger log = Log.getLogger(LocalControlAgentProtocol.class);
            if (responce instanceof EventApplicationRegistered) {
                this.channel.clientId = ((EventApplicationRegistered)responce).getControlObjectId();
                if (LocalControlAgentProtocol.this.processId == -1) {
                    LocalControlAgentProtocol.this.processId = ((EventApplicationRegistered)responce).getProcessId();
                }
                log.infoFormat("Successful registration: {0}", (Object)responce);
                return true;
            }
            log.warnFormat("Unexpected message registering client: {0}", (Object)responce);
            return false;
        }

        public Message getRegistrationMessage() {
            RequestRegisterApplication requestMessage = RequestRegisterApplication.create();
            requestMessage.setReferenceId(7777);
            if (LocalControlAgentProtocol.this.status != null) {
                requestMessage.setControlStatus(LocalControlAgentProtocol.this.status);
            }
            if (LocalControlAgentProtocol.this.applicationType != null) {
                requestMessage.setApplicationType(LocalControlAgentProtocol.this.applicationType);
            }
            requestMessage.setPassword(LocalControlAgentProtocol.DEFAULT_PASSWORD);
            requestMessage.setProcessId(LocalControlAgentProtocol.this.processId);
            requestMessage.setControlObjectId(LocalControlAgentProtocol.this.clientId);
            requestMessage.setExecutionMode(LocalControlAgentProtocol.this.executionMode);
            if (LocalControlAgentProtocol.this.clientName != null && LocalControlAgentProtocol.this.clientName.length() != 0) {
                requestMessage.setApplicationName(LocalControlAgentProtocol.this.clientName);
            }
            return requestMessage;
        }
    }
}

