/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.ClientChannel;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.EndpointSupport;
import com.genesyslab.platform.commons.protocol.IntReferenceBuilder;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.ReferenceBuilder;
import com.genesyslab.platform.commons.protocol.RegistrationException;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.UpdatableProtocolId;
import com.genesyslab.platform.management.protocol.MessageServerProtocolHandshakeOptions;
import com.genesyslab.platform.management.protocol.messageserver.KeyFlags;
import com.genesyslab.platform.management.protocol.messageserver.MessageKey;
import com.genesyslab.platform.management.protocol.messageserver.MessagePriority;
import com.genesyslab.platform.management.protocol.messageserver.MessageTypes;
import com.genesyslab.platform.management.protocol.messageserver.events.EventError;
import com.genesyslab.platform.management.protocol.messageserver.events.EventLogMessage;
import com.genesyslab.platform.management.protocol.messageserver.events.EventSubscription;
import com.genesyslab.platform.management.protocol.messageserver.requests.RequestLogMessage;
import com.genesyslab.platform.management.protocol.messageserver.runtime.MessageProtocolInnerMessageParser;
import com.genesyslab.platform.management.protocol.messageserver.runtime.MessageProtocolTransportImpl;
import com.genesyslab.platform.management.protocol.messageserver.runtime.MessageServerCustomInternalProtocolFactory;
import com.genesyslab.platform.management.protocol.messageserver.runtime.channel.EventConnected;
import com.genesyslab.platform.management.protocol.messageserver.runtime.channel.RequestConnect;
import java.util.Date;

@ProtocolDescription.Tag(sdkName="Management", protocolName="MessageServer")
public final class MessageServerProtocol
extends ClientChannel
implements MessageServerProtocolHandshakeOptions {
    private MessageProtocolTransportImpl transport = new MessageProtocolTransportImpl();
    private String clientHost;
    private static final ILogger log = Log.getLogger(MessageServerProtocol.class);

    public MessageServerProtocol(Endpoint endpoint) {
        this(endpoint, 30000L);
    }

    public MessageServerProtocol(Endpoint endpoint, long timeout) {
        super(endpoint, (ProtocolFactory)new MessageServerCustomInternalProtocolFactory(), (ReferenceBuilder)new IntReferenceBuilder(), timeout);
    }

    public int getClientId() {
        if (this.transport.getClientId() != null) {
            return this.transport.getClientId();
        }
        return 0;
    }

    public void setClientId(int clientId) {
        this.transport.setClientId(clientId);
    }

    public void setClientId(Integer clientId) {
        this.transport.setClientId(clientId);
    }

    public String getClientName() {
        return this.transport.getClientName();
    }

    public void setClientName(String clientName) {
        this.transport.setClientName(clientName);
    }

    public int getClientType() {
        return this.transport.getClientType();
    }

    public void setClientType(int clientType) {
        this.transport.setClientType(clientType);
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String host) {
        if (host == null) {
            throw new NullPointerException("client host shouldn't be null");
        }
        this.clientHost = host;
    }

    protected void onSend(Message message) throws ProtocolException {
        if (message instanceof RequestLogMessage) {
            RequestLogMessage logMessage = (RequestLogMessage)message;
            if (this.transport.getClientId() == null) {
                throw new ProtocolException("ClientId must be specified for MessageServerProtocol");
            }
            if (logMessage.getEntryText() == null) {
                throw new ProtocolException("EntryText property must be specified in RequestLogMessage");
            }
            if (logMessage.getEntryId() == null) {
                throw new ProtocolException("EntryId property must be specified in RequestLogMessage");
            }
            if (logMessage.getClientHost() == null) {
                if (this.clientHost != null) {
                    logMessage.setClientHost(this.clientHost);
                } else {
                    throw new ProtocolException("ClientHost property must be specified either in RequestLogMessage or in MessageServerProtocol");
                }
            }
            if (logMessage.getTime() == null) {
                logMessage.setTime(new Date());
            }
        }
        super.onSend(message);
    }

    protected void onReceiveMessage(Message message) {
        byte[] data;
        EventSubscription evSubscr;
        Message messageReplacement = null;
        if (message instanceof EventSubscription && (evSubscr = (EventSubscription)message).getMessageType() == MessageTypes.RequestLogMessage && (data = evSubscr.getAttachedData()) != null && data.length > 0) {
            MessageProtocolInnerMessageParser mp = new MessageProtocolInnerMessageParser((ProtocolFactory)new AbstractProtocolFactory(){

                public Message createMessage(int id) {
                    return EventLogMessage.create();
                }

                public Message createMessage(int id, String name) {
                    return EventLogMessage.create();
                }

                public String getMessageName(int id) {
                    return "EventLogMessage";
                }

                public ProtocolDescription getProtocolDescription() {
                    return MessageServerProtocol.this.getProtocolFactory().getProtocolDescription();
                }

                public String getProtocolVersion() {
                    return MessageServerProtocol.this.getProtocolFactory().getProtocolVersion();
                }
            }, this.getConfiguration());
            try {
                messageReplacement = mp.parse(data);
                this.setupOuterFields(message, messageReplacement);
                log.debugFormat("Internal message was successfully extracted:\n{0}", (Object)messageReplacement);
            }
            catch (PlatformException e) {
                log.warn((Object)"Exception on inner LogMessage unpack", (Throwable)e);
                this.fireErrorEvent(e);
            }
        }
        if (messageReplacement != null) {
            super.onReceiveMessage(messageReplacement);
        } else {
            super.onReceiveMessage(message);
        }
    }

    private void setupOuterFields(Message msgOuter, Message msgInner) {
        if (msgInner instanceof UpdatableProtocolId) {
            ((UpdatableProtocolId)msgInner).setProtocolId(this.getProtocolId());
        }
        if (msgInner instanceof EndpointSupport) {
            ((EndpointSupport)msgInner).setEndpoint(this.getEndpoint());
        }
        if (msgOuter instanceof DataSupport && msgInner instanceof DataSupport) {
            DataSupport dsO = (DataSupport)msgOuter;
            DataSupport dsI = (DataSupport)msgInner;
            this.copyAttribute(dsO, dsI, "MessageGuid1");
            this.copyAttribute(dsO, dsI, "MessageGuid2");
            this.copyAttribute(dsO, dsI, "MessageGuid3");
            this.copyAttribute(dsO, dsI, "MessageGuid4");
        }
    }

    private void copyAttribute(DataSupport msgFrom, DataSupport msgTo, String attrName) {
        Object value = msgFrom.attributes().get(attrName);
        if (value != null && msgTo.getMetaData().getAttributeDescription((Object)attrName) != null) {
            msgTo.attributes().put(attrName, value);
        }
    }

    protected Connection createConnection(Endpoint endpoint) {
        Connection connection = super.createConnection(endpoint);
        connection.setMessageTransport((MessageTransport)this.transport);
        return connection;
    }

    protected void onOpen() throws ProtocolException {
        this.setRegistrationHandler((ClientChannel.RegistrationHandler)new MSRegHandler());
        super.onOpen();
    }

    private class MSRegHandler
    extends ClientChannel.SimpleRegistrationHandler {
        private MSRegHandler() {
            super((ClientChannel)MessageServerProtocol.this);
        }

        protected boolean isResponseAccepted(Message response) throws RegistrationException {
            if (response instanceof EventConnected) {
                return true;
            }
            if (response instanceof EventError) {
                throw new RegistrationException("Registration failed", response);
            }
            return false;
        }

        public Message getRegistrationMessage() {
            String host = MessageServerProtocol.this.getEndpoint().getHost();
            Integer port = MessageServerProtocol.this.getEndpoint().getPort();
            Integer flags = KeyFlags.Integer.ordinal() | KeyFlags.String.ordinal();
            RequestConnect req = RequestConnect.create();
            req.setPriority(MessagePriority.Normal);
            MessageKey msgKey = MessageKey.create();
            msgKey.setKeyFlags(flags);
            msgKey.setKeyInteger(port);
            msgKey.setKeyLong(0);
            msgKey.setKeyString(host);
            req.setMessageKey(msgKey);
            return req;
        }
    }
}

