/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.localcontrolagent;

import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventChangeExecutionMode;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventHostUnderControl;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventInitHeartbeats;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventNoControllingSCS;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventSuspendApplication;
import com.genesyslab.platform.management.protocol.localcontrolagent.requests.RequestSCSConnectionStatus;
import com.genesyslab.platform.management.protocol.localcontrolagent.requests.RequestUpdateStatus;
import com.genesyslab.platform.management.protocol.localcontrolagent.responses.ResponseExecutionModeChanged;

public class LocalControlAgentProtocolFactory
extends AbstractProtocolFactory {
    public static final ProtocolDescription PROTOCOL_DESCRIPTION = new ProtocolDescription("Management", "LocalControlAgent");

    public ProtocolDescription getProtocolDescription() {
        return PROTOCOL_DESCRIPTION;
    }

    public String getProtocolVersion() {
        return "7.6.000";
    }

    protected Message createRequest(int id) {
        switch (id) {
            case 5: {
                return ResponseExecutionModeChanged.create();
            }
            case 30: {
                return RequestUpdateStatus.create();
            }
            case 43: {
                return RequestSCSConnectionStatus.create();
            }
        }
        return null;
    }

    protected Message createEvent(int id) {
        switch (id) {
            case 12: {
                return EventChangeExecutionMode.create();
            }
            case 32: {
                return EventSuspendApplication.create();
            }
            case 40: {
                return EventInitHeartbeats.create();
            }
            case 41: {
                return EventHostUnderControl.create();
            }
            case 42: {
                return EventNoControllingSCS.create();
            }
        }
        return null;
    }

    protected String getEventMessageName(int id) {
        switch (id) {
            case 12: {
                return "EventChangeExecutionMode";
            }
            case 32: {
                return "EventSuspendApplication";
            }
            case 40: {
                return "EventInitHeartbeats";
            }
            case 41: {
                return "EventHostUnderControl";
            }
            case 42: {
                return "EventNoControllingSCS";
            }
        }
        return "";
    }

    protected String getRequestMessageName(int id) {
        switch (id) {
            case 5: {
                return "ResponseExecutionModeChanged";
            }
            case 30: {
                return "RequestUpdateStatus";
            }
            case 43: {
                return "RequestSCSConnectionStatus";
            }
        }
        return "";
    }

    public String getMessageName(int id) {
        String name = this.getEventMessageName(id);
        if (name != null && !name.equals("")) {
            return name;
        }
        name = this.getRequestMessageName(id);
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Protocol doesn't support message #" + id);
        }
        return name;
    }

    public Message createMessage(int id) {
        Message message = this.createEvent(id);
        if (message != null) {
            return message;
        }
        message = this.createRequest(id);
        if (message != null) {
            return message;
        }
        throw new IllegalArgumentException("Protocol doesn't support message #" + id);
    }

    public Message createMessage(int id, String name) {
        if (name == null || name.equals("")) {
            return this.createMessage(id);
        }
        Message message = null;
        message = name.startsWith("Event") ? this.createEvent(id) : this.createRequest(id);
        if (message == null) {
            throw new IllegalArgumentException("Protocol doesn't support message #" + id);
        }
        return message;
    }
}

