/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime;

import com.genesyslab.platform.commons.management.PSDKManagementFactory;
import com.genesyslab.platform.commons.threading.ThreadHeartbeatCounterMBean;
import com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime.ThreadInfoList;
import com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime.ThreadLiveInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegateMBean;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadsHeartbeatsCollector {
    private static final int THREAD_FLAG_STATE_ACTIVE = 1;
    private static final int THREAD_FLAG_STATE_DELETED = 2;
    private static final int STAT_DELETE_COUNTER_VALUE = 3;
    private final boolean monitorAllServers;
    private Map<String, ThreadLiveInfo> prevThreadsStatuses = null;

    ThreadsHeartbeatsCollector(boolean monitorAllServers) {
        this.monitorAllServers = monitorAllServers;
    }

    private void findThreadHeartbeatCounters(MBeanServer mbServer, Map<String, ThreadLiveInfo> threadsStatuses) {
        ObjectName objNameMask;
        try {
            objNameMask = new ObjectName("com.genesyslab.platform:type=ThreadHeartbeatMonitor,*");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Exception while creating mbean name mask", e);
        }
        Iterator<ObjectName> i$ = mbServer.queryNames(objNameMask, null).iterator();
        while (i$.hasNext()) {
            String serverId;
            ObjectName mbeanName;
            ObjectName objName = mbeanName = i$.next();
            ThreadHeartbeatCounterMBean mbean = null;
            try {
                mbean = MBeanServerInvocationHandler.newProxyInstance(mbServer, objName, ThreadHeartbeatCounterMBean.class, false);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while creating proxy for mbean", e);
            }
            if (mbean == null || mbean.getThreadSystemId() <= 0L) continue;
            String threadUniqName = mbean.getLogicalName();
            if (this.monitorAllServers && (serverId = this.getMBServerId(mbServer)) != null && !serverId.equals("")) {
                threadUniqName = threadUniqName + "." + serverId;
            }
            ThreadLiveInfo info = new ThreadLiveInfo(mbean.getThreadSystemId(), threadUniqName, mbean.getThreadClass());
            info.setHeartbeatCounter(mbean.getHeartbeatCounter());
            if (mbean.isActive()) {
                info.setFlag(1);
            }
            threadsStatuses.put(threadUniqName, info);
        }
    }

    private String getMBServerId(MBeanServer mbServer) {
        MBeanServerDelegateMBean mbsD = null;
        try {
            mbsD = MBeanServerInvocationHandler.newProxyInstance(mbServer, new ObjectName("JMImplementation:type=MBeanServerDelegate"), MBeanServerDelegateMBean.class, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mbsD != null) {
            return mbsD.getMBeanServerId();
        }
        return null;
    }

    ThreadInfoList updateThreadInfoList() {
        HashMap<String, ThreadLiveInfo> threadsStatuses = new HashMap<String, ThreadLiveInfo>();
        if (this.monitorAllServers) {
            for (MBeanServer mbs : MBeanServerFactory.findMBeanServer(null)) {
                if (!(mbs instanceof MBeanServer)) continue;
                this.findThreadHeartbeatCounters(mbs, threadsStatuses);
            }
        } else {
            this.findThreadHeartbeatCounters(PSDKManagementFactory.getPSDKMBeanServer(), threadsStatuses);
        }
        if (this.prevThreadsStatuses != null) {
            for (ThreadLiveInfo oldInfo : this.prevThreadsStatuses.values()) {
                if (threadsStatuses.containsKey(oldInfo.getLogicID())) continue;
                if (oldInfo.checkFlag(2)) {
                    oldInfo.setDeleteCounter(oldInfo.getDeleteCounter() - 1);
                    if (oldInfo.getDeleteCounter() <= 0) continue;
                    threadsStatuses.put(oldInfo.getLogicID(), oldInfo);
                    continue;
                }
                oldInfo.setFlag(2);
                oldInfo.setDeleteCounter(3);
                threadsStatuses.put(oldInfo.getLogicID(), oldInfo);
            }
        }
        this.prevThreadsStatuses = threadsStatuses;
        ThreadInfoList result = new ThreadInfoList();
        result.addAll(threadsStatuses.values());
        return result;
    }
}

