/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.NoDataCodec;
import com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime.ThreadInfoList;
import com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime.ThreadLiveInfo;
import javax.xml.transform.Result;
import javax.xml.transform.Source;

public class ThreadInfoListCodec
extends NoDataCodec
implements AttributeTypeCodec {
    private static final int THREAD_LIVE_INFO_SIZE = 80;
    private static final int MAX_LOGICAL_ID_LEN = 64;

    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        if (customTypeObject instanceof ThreadInfoList) {
            ThreadInfoList list = (ThreadInfoList)customTypeObject;
            int num = list.size();
            byte[] bytes = new byte[num * 80];
            for (int i = 0; i < num; ++i) {
                ThreadLiveInfo info = (ThreadLiveInfo)list.get(i);
                int pos0 = i * 80;
                this.setIntValue(bytes, pos0, (int)info.getOsID());
                this.setIntValue(bytes, pos0 + 4, info.getThreadClass());
                this.setIntValue(bytes, pos0 + 8, info.getHeartbeatCounter());
                this.setIntValue(bytes, pos0 + 12, info.getFlags());
                byte[] name = info.getLogicID().getBytes();
                int namelen = name.length;
                if (namelen > 64) {
                    namelen = 64;
                }
                System.arraycopy(name, 0, bytes, pos0 + 16, namelen);
            }
            transport.onAttribute(transportState, "3", num);
            return transport.onAttribute(transportState, id, bytes);
        }
        return transportState;
    }

    public Object decodeFromConnection(Object value, AttributeDescription attributeDescription) throws PlatformException {
        throw new RuntimeException("Not implemented");
    }

    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        throw new RuntimeException("Not implemented");
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription attributeDescription) throws CodecException {
        throw new RuntimeException("Not implemented");
    }

    public String getLogType() {
        return "ThreadInfoList";
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) throws CodecException {
        if (customTypeObject instanceof ThreadInfoList) {
            ThreadInfoList list = (ThreadInfoList)customTypeObject;
            buf.append("ThreadInfoList {\n");
            for (ThreadLiveInfo info : list) {
                buf.append("\t\t").append(info).append("\n");
            }
            buf.append("\t}");
        }
    }

    private void setIntValue(byte[] pack, int pos, int value) {
        int i = pos;
        pack[i++] = (byte)((value & 0xFFFFFFFF) >> 24 & 0xFF);
        pack[i++] = (byte)((value & 0xFFFFFF) >> 16 & 0xFF);
        pack[i++] = (byte)((value & 0xFFFF) >> 8 & 0xFF);
        pack[i++] = (byte)(value & 0xFF);
    }
}

