/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.messageserver.runtime;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.impl.CommonMessageTransportImpl;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.connection.impl.PackedMessage;
import com.genesyslab.platform.commons.connection.impl.WritePoint;
import com.genesyslab.platform.management.protocol.messageserver.KeyFlags;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;

public class MessageProtocolTransportImpl
extends CommonMessageTransportImpl {
    private static final String INNER_MESSAGE_PREFIX = "inner.";
    private static final int INNER_MESSAGE_PREFIX_LEN = "inner.".length();
    private static final int MESSAGE_HEADER_ATTR_ID = 13;
    private static final String INNER_BYTES_ATTR_ID = "15";
    private static final String INNER_LEN_ATTR_ID = "16";
    private static final MessageFormat HEADER_FORMAT = new MessageFormat("{0,date,HH:mm:ss.SSS} Trc {1,number,00000} ");
    private Integer clientId = null;
    private int clientType = 0;
    private String clientName;
    private final Random random = new Random();

    public Integer getClientId() {
        return this.clientId;
    }

    public void setClientId(Integer clientId) {
        this.clientId = clientId;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public int getClientType() {
        return this.clientType;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    public Object onNewMessage(Object state, int messageId) {
        return new State(messageId, EncodingSupport.DEFAULT_ENCODING);
    }

    public Object onAttribute(Object state, String id, byte[] value) throws PlatformException {
        PackedMessage message = this.chooseMessage(state, id);
        this.packBinary(message, id, value);
        return state;
    }

    public Object onAttribute(Object state, String id, int value) throws PlatformException {
        State myState = (State)state;
        if ("inner.5".equals(id)) {
            myState.setId(new Integer(value));
        } else if ("inner.4".equals(id)) {
            myState.setEntryOrigin(new Integer(value));
        } else {
            PackedMessage message = this.chooseMessage(state, id);
            this.packInt(message, id, value);
        }
        return state;
    }

    public Object onAttribute(Object state, String id, long value) throws PlatformException {
        PackedMessage message = this.chooseMessage(state, id);
        this.packLong(message, id, value);
        return state;
    }

    public Object onAttribute(Object state, String id, String value) throws PlatformException {
        PackedMessage message = this.chooseMessage(state, id);
        this.packString(message, id, value);
        return state;
    }

    public Object onMessageEnd(Object state) throws PlatformException {
        State myState = (State)state;
        PackedMessage outer = myState.getOuterMessage();
        this.createGuid(outer);
        this.storeTimeGenerated(outer);
        Integer entryOrigin = myState.getEntryOrigin();
        if (myState.getMessageId() == 1101) {
            outer.addIntAttrib(7, KeyFlags.Integer.ordinal() | KeyFlags.UnsignedLong.ordinal());
            outer.addIntAttrib(8, this.clientId != null ? this.clientId : 0);
            int entryId = myState.getId();
            outer.addIntAttrib(9, entryId);
            if (entryId >= 10000) {
                entryOrigin = new Integer(this.clientType);
            }
        }
        if (entryOrigin != null) {
            myState.getInnerMessage().addIntAttrib(4, entryOrigin.intValue());
        }
        if (myState.isInnerMessagePresent()) {
            PackedMessage inner = myState.getInnerMessage();
            this.storeMessageHeaderAndId(myState, inner);
            this.storeProtocolAttributes(inner);
            this.packInnerMessage(outer, inner);
        }
        return super.onMessageEnd((Object)outer);
    }

    private void storeTimeGenerated(PackedMessage message) {
        long milis = System.currentTimeMillis();
        message.addLongAttrib(12, milis /= 1000L);
    }

    protected int asIntId(String id) throws PlatformException {
        String myId = id;
        if (id != null && id.startsWith(INNER_MESSAGE_PREFIX)) {
            myId = id.substring(INNER_MESSAGE_PREFIX_LEN);
        }
        return super.asIntId(myId);
    }

    private void createGuid(PackedMessage message) {
        message.addIntAttrib(0, this.random.nextInt());
        message.addIntAttrib(1, (int)((short)this.random.nextInt()));
        message.addIntAttrib(2, (int)((short)this.random.nextInt()));
        byte[] guid4 = new byte[10];
        this.random.nextBytes(guid4);
        guid4[0] = 0;
        guid4[1] = 10;
        message.addBinaryAttrib(3, guid4);
    }

    private void packInnerMessage(PackedMessage outer, PackedMessage inner) throws PlatformException {
        byte[] innerBytes = this.getBytes(inner);
        super.onAttribute((Object)outer, INNER_LEN_ATTR_ID, innerBytes.length);
        super.onAttribute((Object)outer, INNER_BYTES_ATTR_ID, innerBytes);
    }

    private void storeMessageHeaderAndId(State myState, PackedMessage inner) throws PlatformException {
        Integer id = myState.getId();
        if (id == null) {
            throw new PlatformException("Id of internal message is required");
        }
        String messageHeader = HEADER_FORMAT.format(new Object[]{new Date(), id}, new StringBuffer(), (FieldPosition)null).toString();
        inner.addStringAttrib(13, messageHeader);
        int msgId = id;
        inner.setMessageId(msgId);
        inner.addIntAttrib(5, msgId);
    }

    private void storeProtocolAttributes(PackedMessage message) throws PlatformException {
        super.onAttribute((Object)message, "14", this.clientId != null ? this.clientId : 0);
        super.onAttribute((Object)message, INNER_BYTES_ATTR_ID, this.clientType);
        if (this.clientName != null) {
            super.onAttribute((Object)message, "8", this.clientName);
        }
    }

    private byte[] getBytes(PackedMessage inner) {
        ByteArrayWritePoint endpoint = new ByteArrayWritePoint();
        try {
            inner.writeTo((WritePoint)endpoint);
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] innerBytes = endpoint.getBytes();
        int size = innerBytes.length - 4;
        byte[] bytes = new byte[size];
        System.arraycopy(innerBytes, 4, bytes, 0, size);
        return bytes;
    }

    private PackedMessage chooseMessage(Object state, String id) {
        State myState = (State)state;
        if (id != null && id.startsWith(INNER_MESSAGE_PREFIX)) {
            return myState.getInnerMessage();
        }
        return myState.getOuterMessage();
    }

    static {
        ((DateFormat)HEADER_FORMAT.getFormats()[0]).setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private static class ByteArrayWritePoint
    implements WritePoint {
        private ByteArrayOutputStream bytes = new ByteArrayOutputStream();

        private ByteArrayWritePoint() {
        }

        public void write(byte[] bytes) {
            this.write(bytes, 0, bytes.length);
        }

        public void write(byte[] bytes, int offset, int len) {
            this.bytes.write(bytes, offset, len);
        }

        public byte[] getBytes() {
            return this.bytes.toByteArray();
        }
    }

    private static class State {
        private PackedMessage outerMessage;
        private PackedMessage innerMessage;
        private Integer id;
        private int messageId;
        private Integer entryOrigin = null;
        private String stringAttributesEncoding;

        public State(int outerMessageId, String stringAttributesEncoding) {
            this.messageId = outerMessageId;
            this.stringAttributesEncoding = stringAttributesEncoding;
            this.outerMessage = new PackedMessage(outerMessageId, stringAttributesEncoding);
        }

        public int getMessageId() {
            return this.messageId;
        }

        public PackedMessage getOuterMessage() {
            return this.outerMessage;
        }

        public PackedMessage getInnerMessage() {
            if (this.innerMessage == null) {
                this.innerMessage = new PackedMessage(this.stringAttributesEncoding);
            }
            return this.innerMessage;
        }

        public boolean isInnerMessagePresent() {
            return this.innerMessage != null;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Integer getEntryOrigin() {
            return this.entryOrigin;
        }

        public void setEntryOrigin(Integer val) {
            this.entryOrigin = val;
        }
    }
}

