/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.solutioncontrolserver;

import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.events.EventAlarmInfo;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.events.EventCustomInfo;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.events.EventEnvironmentInfo;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.events.EventError;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.events.EventInfo;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.events.EventXResponse;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.RequestRetrieveEnvironment;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.RequestSubscribe;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.RequestUnsubscribe;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.RequestXRequest;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.alarms.RequestActivateApplicationAlarm;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.alarms.RequestDeactivateAlarm;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.alarms.RequestDeactivateAlarms;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.alarms.RequestDeactivateApplicationAlarm;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.alarms.RequestDeactivateApplicationAlarms;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.alarms.RequestGetActiveAlarms;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.applications.RequestChangeExecutionMode;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.applications.RequestCustomCommand;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.applications.RequestGetApplicationInfo;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.applications.RequestStartApplication;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.applications.RequestStopAllApplications;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.applications.RequestStopApplication;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.applications.RequestStopApplicationGracefully;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.hosts.RequestGetHostInfo;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.solutions.RequestGetSolutionInfo;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.solutions.RequestStartSolution;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.solutions.RequestStopSolution;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.requests.solutions.RequestStopSolutionGracefully;

public class SolutionControlServerProtocolFactory
extends AbstractProtocolFactory {
    public static final ProtocolDescription PROTOCOL_DESCRIPTION = new ProtocolDescription("Management", "SolutionControlServer");

    public ProtocolDescription getProtocolDescription() {
        return PROTOCOL_DESCRIPTION;
    }

    public String getProtocolVersion() {
        return "7.6.000";
    }

    protected Message createRequest(int id) {
        switch (id) {
            case 1: {
                return RequestStartApplication.create();
            }
            case 2: {
                return RequestStopApplication.create();
            }
            case 3: {
                return RequestStartSolution.create();
            }
            case 4: {
                return RequestStopSolution.create();
            }
            case 5: {
                return RequestGetActiveAlarms.create();
            }
            case 6: {
                return RequestActivateApplicationAlarm.create();
            }
            case 7: {
                return RequestDeactivateApplicationAlarm.create();
            }
            case 8: {
                return RequestDeactivateApplicationAlarms.create();
            }
            case 9: {
                return RequestDeactivateAlarm.create();
            }
            case 10: {
                return RequestDeactivateAlarms.create();
            }
            case 11: {
                return RequestGetSolutionInfo.create();
            }
            case 12: {
                return RequestGetApplicationInfo.create();
            }
            case 13: {
                return RequestGetHostInfo.create();
            }
            case 14: {
                return RequestChangeExecutionMode.create();
            }
            case 15: {
                return RequestSubscribe.create();
            }
            case 16: {
                return RequestUnsubscribe.create();
            }
            case 21: {
                return RequestXRequest.create();
            }
            case 22: {
                return RequestStopAllApplications.create();
            }
            case 24: {
                return RequestStopApplicationGracefully.create();
            }
            case 25: {
                return RequestStopSolutionGracefully.create();
            }
            case 26: {
                return RequestCustomCommand.create();
            }
            case 27: {
                return RequestRetrieveEnvironment.create();
            }
        }
        return null;
    }

    protected Message createEvent(int id) {
        switch (id) {
            case 1: {
                return EventInfo.create();
            }
            case 3: {
                return EventAlarmInfo.create();
            }
            case 4: {
                return EventError.create();
            }
            case 9: {
                return EventXResponse.create();
            }
            case 10: {
                return EventCustomInfo.create();
            }
            case 11: {
                return EventEnvironmentInfo.create();
            }
        }
        return null;
    }

    protected String getEventMessageName(int id) {
        switch (id) {
            case 1: {
                return "EventInfo";
            }
            case 3: {
                return "EventAlarmInfo";
            }
            case 4: {
                return "EventError";
            }
            case 9: {
                return "EventXResponse";
            }
            case 10: {
                return "EventCustomInfo";
            }
            case 11: {
                return "EventEnvironmentInfo";
            }
        }
        return "";
    }

    protected String getRequestMessageName(int id) {
        switch (id) {
            case 1: {
                return "RequestStartApplication";
            }
            case 2: {
                return "RequestStopApplication";
            }
            case 3: {
                return "RequestStartSolution";
            }
            case 4: {
                return "RequestStopSolution";
            }
            case 5: {
                return "RequestGetActiveAlarms";
            }
            case 6: {
                return "RequestActivateApplicationAlarm";
            }
            case 7: {
                return "RequestDeactivateApplicationAlarm";
            }
            case 8: {
                return "RequestDeactivateApplicationAlarms";
            }
            case 9: {
                return "RequestDeactivateAlarm";
            }
            case 10: {
                return "RequestDeactivateAlarms";
            }
            case 11: {
                return "RequestGetSolutionInfo";
            }
            case 12: {
                return "RequestGetApplicationInfo";
            }
            case 13: {
                return "RequestGetHostInfo";
            }
            case 14: {
                return "RequestChangeExecutionMode";
            }
            case 15: {
                return "RequestSubscribe";
            }
            case 16: {
                return "RequestUnsubscribe";
            }
            case 21: {
                return "RequestXRequest";
            }
            case 22: {
                return "RequestStopAllApplications";
            }
            case 24: {
                return "RequestStopApplicationGracefully";
            }
            case 25: {
                return "RequestStopSolutionGracefully";
            }
            case 26: {
                return "RequestCustomCommand";
            }
            case 27: {
                return "RequestRetrieveEnvironment";
            }
        }
        return "";
    }

    public String getMessageName(int id) {
        String name = this.getEventMessageName(id);
        if (name != null && !name.equals("")) {
            return name;
        }
        name = this.getRequestMessageName(id);
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Protocol doesn't support message #" + id);
        }
        return name;
    }

    public Message createMessage(int id) {
        Message message = this.createEvent(id);
        if (message != null) {
            return message;
        }
        message = this.createRequest(id);
        if (message != null) {
            return message;
        }
        throw new IllegalArgumentException("Protocol doesn't support message #" + id);
    }

    public Message createMessage(int id, String name) {
        if (name == null || name.equals("")) {
            return this.createMessage(id);
        }
        Message message = null;
        message = name.startsWith("Event") ? this.createEvent(id) : this.createRequest(id);
        if (message == null) {
            throw new IllegalArgumentException("Protocol doesn't support message #" + id);
        }
        return message;
    }
}

