/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.solutioncontrolserver.runtime.channel;

import com.genesyslab.platform.management.protocol.solutioncontrolserver.AlarmDescription;

public class AlarmDescriptionDeserializer {
    private static final int KVTypeString = 0;
    private static final int KVTypeInt = 1;
    private static final String errDesc = "Deserialize: packed data incorrect or corrupt";

    private AlarmDescriptionDeserializer() {
    }

    public static AlarmDescription deserialize(byte[] b) throws IllegalArgumentException {
        if (b[0] != -59 || b[1] != 96) {
            throw new IllegalArgumentException(errDesc);
        }
        int k = 2;
        AlarmDescription alarmDesc = new AlarmDescription();
        while (k < b.length && b[k] != -19) {
            Object value;
            int N;
            Object key;
            String s;
            int len;
            int type;
            if (((type = b[k++]) & 0x80) != 0) {
                type &= 0x7F;
            }
            int kType = AlarmDescriptionDeserializer.extractKeyType(type);
            switch (kType) {
                case 0: {
                    len = AlarmDescriptionDeserializer.getVLP(b, k);
                    k = AlarmDescriptionDeserializer.skipVLP(b, k);
                    if (b[k + len] != 0) {
                        throw new IllegalArgumentException(errDesc);
                    }
                    int keyLen = 0;
                    while (b[k + keyLen] != 0) {
                        ++keyLen;
                    }
                    s = new String(b, k, keyLen);
                    key = s;
                    k += len + 1;
                    break;
                }
                case 1: {
                    N = AlarmDescriptionDeserializer.getVLP(b, k);
                    k = AlarmDescriptionDeserializer.skipVLP(b, k);
                    key = new Integer(N);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(errDesc);
                }
            }
            int utype = AlarmDescriptionDeserializer.extractValueType(type);
            switch (utype) {
                case 0: {
                    len = AlarmDescriptionDeserializer.getVLP(b, k);
                    k = AlarmDescriptionDeserializer.skipVLP(b, k);
                    if (b[k + len] != 0) {
                        throw new IllegalArgumentException(errDesc);
                    }
                    s = new String(b, k, len);
                    value = s;
                    k += len + 1;
                    break;
                }
                case 1: {
                    N = AlarmDescriptionDeserializer.getVLP(b, k);
                    k = AlarmDescriptionDeserializer.skipVLP(b, k);
                    value = new Integer(N);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(errDesc);
                }
            }
            alarmDesc.set(AlarmDescriptionDeserializer.GetAttributeName(key), value);
        }
        return alarmDesc;
    }

    private static int extractKeyType(int n) {
        return (n & 0xF0) >> 4;
    }

    private static int extractValueType(int type) {
        return type & 0xF;
    }

    private static String GetAttributeName(Object key) {
        String strKey = key instanceof String ? (String)key : key.toString();
        return strKey.toUpperCase();
    }

    private static int skipVLP(byte[] b, int k) {
        int N = 0;
        if (b[k] == -1) {
            k = AlarmDescriptionDeserializer.skipVLP(b, k + 1);
            return k;
        }
        do {
            N = N << 7 | b[k] & 0x7F;
        } while ((b[k++] & 0x80) == 0);
        return k;
    }

    private static int getVLP(byte[] b, int k) {
        int N = 0;
        if (b[k] == -1) {
            N = AlarmDescriptionDeserializer.getVLP(b, k + 1);
            N = -N;
            return N;
        }
        do {
            N = N << 7 | b[k] & 0x7F;
        } while ((b[k++] & 0x80) == 0);
        return N;
    }

    public static byte[] getBytes(AlarmDescription ad) {
        return null;
    }
}

