/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections;

import com.genesyslab.platform.commons.collections.Pair;
import com.genesyslab.platform.commons.collections.UTFValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class KVList
implements Cloneable,
Serializable,
Collection {
    protected transient PairList storage = new VectorPairListImpl();
    private Comparator comparator;

    public void addBinary(String key, byte[] data) {
        Pair pair = this.createPair(key);
        pair.setBinaryValue(data);
        this.storage.add(pair);
    }

    public void addInt(String key, int value) {
        Pair pair = this.createPair(key);
        pair.setIntValue(value);
        this.storage.add(pair);
    }

    public void addInt(String key, Integer value) {
        Pair pair = this.createPair(key);
        pair.setIntValue(value);
        this.storage.add(pair);
    }

    public void addString(String key, String value) {
        Pair pair = this.createPair(key);
        pair.setStringValue(value);
        this.storage.add(pair);
    }

    public void addUTFString(String key, String value) {
        Pair pair = this.createPair(key);
        pair.setUTF16Value(value);
        this.storage.add(pair);
    }

    public void addUTFString(String key, UTFValue value) {
        Pair pair = this.createPair(key);
        pair.setUTF16Value(value);
        this.storage.add(pair);
    }

    public void addObject(String key, Object value) throws IllegalArgumentException {
        Pair pair = null;
        if (value instanceof String) {
            pair = this.createPair(key);
            pair.setStringValue((String)value);
        } else if (value instanceof Integer) {
            pair = this.createPair(key);
            pair.setIntValue((Integer)value);
        } else if (value instanceof byte[]) {
            pair = this.createPair(key);
            pair.setBinaryValue((byte[])value);
        } else if (value instanceof UTFValue) {
            pair = this.createPair(key);
            pair.setUTF16Value((UTFValue)value);
        }
        if (pair == null) {
            if (value == null) {
                throw new NullPointerException("Null values are not supported");
            }
            throw new IllegalArgumentException("unsupported value type: " + value.getClass());
        }
        this.storage.add(pair);
    }

    public byte[] getBinary(String key) {
        Pair pair = this.storage.findPair(key);
        if (pair == null) {
            return null;
        }
        return pair.getBinaryValue();
    }

    public Integer getInt(String key) {
        Pair pair = this.storage.findPair(key);
        if (pair == null) {
            return null;
        }
        return pair.getIntValue();
    }

    public String getString(String key) {
        Pair pair = this.storage.findPair(key);
        if (pair == null) {
            return null;
        }
        return pair.getStringValue();
    }

    public void clear() {
        this.storage.clear();
    }

    public int length() {
        return this.storage.length();
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public Enumeration getEnumeration() {
        return this.storage.getEnumeration();
    }

    public Enumeration getEnumeration(String key) {
        return this.getPairEnumeration(key);
    }

    public Object clone() throws CloneNotSupportedException {
        KVList cp = (KVList)super.clone();
        cp.storage = (PairList)this.storage.clone();
        return cp;
    }

    public boolean equals(Object obj) {
        if (obj instanceof KVList) {
            return this.storage.equals(((KVList)obj).storage);
        }
        return false;
    }

    public int hashCode() {
        return this.storage.hashCode();
    }

    public String toString() {
        return super.toString() + ": " + this.storage.toString();
    }

    public int size() {
        return this.storage.length();
    }

    public Object[] toArray() {
        return this.storage.asCollection().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.storage.asCollection().toArray(a);
    }

    public boolean add(Object o) {
        this.throwNotPair(o);
        this.storage.add((Pair)o);
        return true;
    }

    public boolean contains(Object o) {
        return this.storage.asCollection().contains(o);
    }

    public boolean containsKey(Object key) {
        return this.storage.findPair(key) != null;
    }

    public boolean remove(Object o) {
        return this.storage.asCollection().remove(o);
    }

    public boolean addAll(Collection c) {
        if (c == this) {
            throw new IllegalArgumentException("can't addAll self");
        }
        boolean res = true;
        for (Object obj : c) {
            res &= this.add(obj);
        }
        return res;
    }

    public boolean containsAll(Collection c) {
        return this.storage.asCollection().containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.storage.asCollection().removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.storage.asCollection().retainAll(c);
    }

    public Iterator iterator() {
        return this.storage.asCollection().iterator();
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    protected Enumeration getPairEnumeration(Object key) {
        return this.storage.getPairEnumeration(key);
    }

    protected Pair removePair(Object key) {
        return this.storage.remove(key);
    }

    protected abstract Pair createPair(Object var1);

    protected abstract void throwNotPair(Object var1);

    private boolean equalPairKeys(Pair p1, Pair p2) {
        if (p1 == null || p2 == null) {
            return false;
        }
        if (p1 == p2) {
            return true;
        }
        return this.equalPairKeys(p1, p2.key);
    }

    private boolean equalPairKeys(Pair pair, Object key) {
        if (pair == null || key == null) {
            return false;
        }
        if (pair.key == key) {
            return true;
        }
        if (this.comparator == null) {
            return pair.key.equals(key);
        }
        return this.comparator.compare(pair.key, key) == 0;
    }

    private class VectorPairListImpl
    implements PairList {
        private Vector v = new Vector();

        private VectorPairListImpl() {
        }

        public void add(Pair pair) {
            this.v.addElement(pair);
        }

        public Pair findPair(Object key) {
            int index = this.indexOf(key);
            if (index < 0) {
                return null;
            }
            return this.get(index);
        }

        private int indexOf(Object key) {
            int size = this.v.size();
            for (int i = 0; i < size; ++i) {
                Pair pair = (Pair)this.v.elementAt(i);
                if (!KVList.this.equalPairKeys(pair, key)) continue;
                return i;
            }
            return -1;
        }

        public Pair remove(Object key) {
            int index = this.indexOf(key);
            if (index < 0) {
                return null;
            }
            return this.remove(index);
        }

        public Pair remove(int index) {
            Pair pair = (Pair)this.v.elementAt(index);
            this.v.removeElementAt(index);
            return pair;
        }

        public void clear() {
            this.v.clear();
        }

        public Enumeration getEnumeration() {
            return this.v.elements();
        }

        public Enumeration getPairEnumeration(Object key) {
            return new PairEnumeration(key);
        }

        public Object clone() throws CloneNotSupportedException {
            VectorPairListImpl cp = (VectorPairListImpl)super.clone();
            cp.v = (Vector)this.v.clone();
            int size = this.v.size();
            for (int i = 0; i < size; ++i) {
                Pair pair = (Pair)this.v.elementAt(i);
                cp.v.setElementAt(pair.clone(), i);
            }
            return cp;
        }

        public boolean equals(Object obj) {
            if (obj instanceof VectorPairListImpl) {
                return this.v.equals(((VectorPairListImpl)obj).v);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Vector v;
            Vector vector = v = this.v;
            synchronized (vector) {
                if (KVList.this.size() == 0) {
                    return 0;
                }
                int index = 0;
                int hashCode = 1;
                for (Object obj : v) {
                    int h0 = obj.hashCode() ^ index++;
                    int i = index & 0x1F;
                    hashCode = 31 * hashCode + (h0 << i | -h0 >>> i);
                }
                return hashCode;
            }
        }

        public boolean addAfter(Pair pair, Pair where) {
            int size = this.v.size();
            int index = this.indexOf(where.key);
            if (index < 0) {
                return false;
            }
            if (index + 1 == size) {
                this.add(pair);
            } else {
                this.insert(pair, index + 1);
            }
            return true;
        }

        public boolean addBefore(Pair pair, Pair where) {
            int index = this.indexOf(where.key);
            if (index < 0) {
                return false;
            }
            this.insert(pair, index);
            return true;
        }

        public int length() {
            return this.v.size();
        }

        public boolean isEmpty() {
            return this.v.isEmpty();
        }

        public void insert(Pair pair, int index) {
            this.v.insertElementAt(pair, index);
        }

        public Pair get(int index) {
            return (Pair)this.v.elementAt(index);
        }

        public Collection asCollection() {
            return this.v;
        }

        public String toString() {
            return this.v.toString();
        }

        private class PairEnumeration
        implements Enumeration {
            private Object key;
            private int currIndex = 0;
            private int size;

            public PairEnumeration(Object key) {
                this.key = key;
                this.size = VectorPairListImpl.this.v.size();
            }

            public boolean hasMoreElements() {
                while (this.currIndex < this.size) {
                    Pair pair = (Pair)VectorPairListImpl.this.v.get(this.currIndex);
                    if (KVList.this.equalPairKeys(pair, this.key)) {
                        return true;
                    }
                    ++this.currIndex;
                }
                return false;
            }

            public Object nextElement() {
                while (this.currIndex < this.size) {
                    Pair pair = (Pair)VectorPairListImpl.this.v.get(this.currIndex++);
                    if (!KVList.this.equalPairKeys(pair, this.key)) continue;
                    return pair;
                }
                throw new NoSuchElementException("no more elements in list");
            }
        }
    }

    public static interface PairList
    extends Cloneable {
        public void add(Pair var1);

        public Pair findPair(Object var1);

        public Pair remove(Object var1);

        public Pair remove(int var1);

        public void clear();

        public Object clone() throws CloneNotSupportedException;

        public Enumeration getEnumeration();

        public Enumeration getPairEnumeration(Object var1);

        public boolean addAfter(Pair var1, Pair var2);

        public boolean addBefore(Pair var1, Pair var2);

        public int length();

        public boolean isEmpty();

        public void insert(Pair var1, int var2);

        public Pair get(int var1);

        public Collection asCollection();
    }
}

