/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections.runtime.processor;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.processor.KeyValueAbstractOutputFilter;
import com.genesyslab.platform.commons.collections.processor.KeyValuePrinterContext;

public class PrefixPostfixFilter
extends KeyValueAbstractOutputFilter {
    public static final String KEY_PREFIX_STRING = "key-prefix-string";
    public static final String KEY_POSTFIX_STRING = "key-postfix-string";
    public static final String VALUE_PREFIX_STRING = "value-prefix-string";
    public static final String VALUE_POSTFIX_STRING = "value-postfix-string";
    private String keyPrefixString = "<#";
    private String keyPostfixString = "";
    private String valuePrefixString = "";
    private String valuePostfixString = "#>";

    public void configure(KeyValueCollection options) {
        super.configure(options);
        if (options != null) {
            if (options.containsKey(KEY_PREFIX_STRING)) {
                this.keyPrefixString = options.getString(KEY_PREFIX_STRING);
            }
            if (options.containsKey(KEY_POSTFIX_STRING)) {
                this.keyPostfixString = options.getString(KEY_POSTFIX_STRING);
            }
            if (options.containsKey(VALUE_PREFIX_STRING)) {
                this.valuePrefixString = options.getString(VALUE_PREFIX_STRING);
            }
            if (options.containsKey(VALUE_POSTFIX_STRING)) {
                this.valuePostfixString = options.getString(VALUE_POSTFIX_STRING);
            }
        }
    }

    protected void doAppendPairKey(StringBuffer buf, String key, Object value, KeyValuePrinterContext context) {
        buf.append(this.keyPrefixString).append('\'').append(key).append('\'').append(this.keyPostfixString);
        this.doAppendPairKeyType(buf, key, value, context);
    }

    protected String doAppendPairValue(StringBuffer buf, String key, Object value, KeyValuePrinterContext context) {
        buf.append(this.valuePrefixString);
        super.doAppendPairValue(buf, key, value, context);
        return this.valuePostfixString;
    }
}

