/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections.runtime.processor;

import com.genesyslab.platform.commons.collections.processor.KeyValueIndenter;

public class TabIndenter
implements KeyValueIndenter {
    private static ThreadLocal<Integer> curIndent = new ThreadLocal();

    protected int getCurIndent() {
        Integer curInd = curIndent.get();
        if (curInd != null) {
            return curInd;
        }
        return 0;
    }

    protected void setCurIndent(int curInd) {
        if (curInd > 0) {
            curIndent.set(new Integer(curInd));
        } else {
            curIndent.set(null);
        }
    }

    public int increaseIndent() {
        int currentIndent = this.getCurIndent();
        this.setCurIndent(++currentIndent);
        return currentIndent;
    }

    public int decreaseIndent() {
        int currentIndent = this.getCurIndent();
        if (currentIndent == 0) {
            throw new IllegalStateException("Indent can't be decreased");
        }
        this.setCurIndent(--currentIndent);
        return currentIndent;
    }

    public void appendIndent(StringBuffer buf) {
        buf.append('\n');
        int currentIndent = this.getCurIndent();
        for (int i = 0; i < currentIndent; ++i) {
            buf.append('\t');
        }
    }
}

