<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xs="http://www.w3.org/2001/XMLSchema">

  <xsl:param name="protocolVersion"/>
  <xsl:param name="protocolId"/>
  <xsl:param name="useNs"/>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="$useNs = false">
        <xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema"  attributeFormDefault="unqualified" elementFormDefault="qualified" >
          <xsl:apply-templates select="/cfglibschema"/>
        </xs:schema>
      </xsl:when>
      <xsl:otherwise>
        <xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" targetNamespace="http://schemas.genesyslab.com/Protocols/Configuration/ConfServer/2005/" xmlns="http://schemas.genesyslab.com/Protocols/Configuration/ConfServer/2005/" attributeFormDefault="unqualified" elementFormDefault="qualified" >
          <xsl:apply-templates select="/cfglibschema"/>
        </xs:schema>
      </xsl:otherwise>
    </xsl:choose>
 </xsl:template>
      
    <xsl:template match="/cfglibschema">
      <xs:annotation>
        <xs:appinfo>
          <xsl:value-of select="$protocolVersion" />
        </xs:appinfo>
      </xs:annotation>

      <xsl:for-each select = "type_info[@class = 'object']" >
        <xsl:comment>
          <xsl:text>  ++++++++++++++++++++++++++++++  </xsl:text>
        </xsl:comment>
        <xsl:comment>
          <xsl:text>  :: object: </xsl:text>
          <xsl:value-of select="@name" />
          <xsl:text>  ::  </xsl:text>
        </xsl:comment>
        <xsl:comment>
          <xsl:text>  ++++++++++++++++++++++++++++++  </xsl:text>
        </xsl:comment>
        <xs:element>
          <xsl:attribute name="id">
            <xsl:value-of select="@id"/>
          </xsl:attribute>
          <xsl:attribute name="name">
            <xsl:value-of select="@name" />
          </xsl:attribute>
          <xs:annotation>
            <xs:appinfo source="type">
              <xsl:value-of select="@class" />
            </xs:appinfo>
            <xs:appinfo source="ObjectTypeId">
              <xsl:value-of select="count(preceding::type_info[@class = 'object'])+1"/>
            </xs:appinfo>
          </xs:annotation>
          <xs:complexType>
            <xs:sequence>
              <xsl:for-each select = "attribute">
                <xsl:variable name="minProtocolId">
                  <xsl:value-of select="@minVersion" />
                </xsl:variable>
                <xsl:choose>
                  <xsl:when test="$minProtocolId and $minProtocolId &gt; $protocolId"></xsl:when>
                  <xsl:otherwise>
                    <xsl:variable name="propertyType">
                      <xsl:value-of select="@style" />
                    </xsl:variable>
                    <xsl:choose>
                      <xsl:when test="$propertyType = 'objlist'">
                        <xsl:call-template name='objlist'></xsl:call-template>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'pobject' or $propertyType = 'object'">
                        <xs:element>
                          <xsl:attribute name = "ref">
                            <xsl:value-of select="@ref" />
                          </xsl:attribute>
                          <xsl:attribute name = "minOccurs">0</xsl:attribute>
                          <xsl:attribute name = "maxOccurs">1</xsl:attribute>
                          <xs:annotation>
                            <xs:appinfo source="CfgObjectProperty">
                              <xsl:value-of select="@libid" />
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:element>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'dbidlist'">
                        <xsl:call-template name="dbidlist"></xsl:call-template>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'intlist'">
                        <xsl:attribute name = "name">
                          <xsl:value-of select="@name" />
                        </xsl:attribute>
                        <xsl:call-template name="intlist"></xsl:call-template>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'kvlist'">
                        <xsl:call-template name="kvlist"></xsl:call-template>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:call-template name="primitive"></xsl:call-template>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:for-each>
            </xs:sequence>
          </xs:complexType>
        </xs:element>
      </xsl:for-each>

      <!-- structures -->
      <xsl:for-each select = "type_info[@class = 'structure']" >
        <xsl:comment>
          <xsl:text>  ++++++++++++++++++++++++++++++  </xsl:text>
        </xsl:comment>
        <xsl:comment>
          <xsl:text>  :: structure </xsl:text>
          <xsl:value-of select="@name" />
          <xsl:text>  ::  </xsl:text>
        </xsl:comment>
        <xsl:comment>
          <xsl:text>  ++++++++++++++++++++++++++++++  </xsl:text>
        </xsl:comment>
        <xs:element>
          <xsl:attribute name="name">
            <xsl:value-of select="@name" />
          </xsl:attribute>
          <xs:annotation>
            <xs:appinfo source="type">
              <xsl:value-of select="@class" />
            </xs:appinfo>
          </xs:annotation>
          <xs:complexType>
            <xs:sequence>
              <xsl:for-each select = "attribute">
                <xsl:variable name="minProtocolId">
                  <xsl:value-of select="@minVersion" />
                </xsl:variable>
                <xsl:choose>
                  <xsl:when test="$minProtocolId and $minProtocolId &gt; $protocolId"></xsl:when>
                  <xsl:otherwise>
                    <xsl:variable name="propertyType">
                      <xsl:value-of select="@style" />
                    </xsl:variable>
                    <xsl:choose>
                      <xsl:when test="$propertyType = 'objlist'">
                        <xsl:call-template name='objlist'></xsl:call-template>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'pobject' or $propertyType = 'object'">
                        <xs:element>
                          <xsl:attribute name = "ref">
                            <xsl:value-of select="@ref" />
                          </xsl:attribute>
                          <xsl:attribute name = "minOccurs">0</xsl:attribute>
                          <xsl:attribute name = "maxOccurs">1</xsl:attribute>
                          <xs:annotation>
                            <xs:appinfo source="CfgObjectProperty">
                              <xsl:value-of select="@libid" />
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:element>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'dbidlist'">
                        <xsl:call-template name="dbidlist"></xsl:call-template>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'intlist'">
                        <xsl:attribute name = "name">
                          <xsl:value-of select="@name" />
                        </xsl:attribute>
                        <xsl:call-template name="intlist"></xsl:call-template>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'kvlist'">
                        <xsl:call-template name="kvlist"></xsl:call-template>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:call-template name="primitive"></xsl:call-template>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:for-each>
            </xs:sequence>
          </xs:complexType>
        </xs:element>
      </xsl:for-each>

      <!-- deltas -->
      <xsl:for-each select = "type_info[@class = 'delta']" >
        <xsl:comment>
          <xsl:text>  ++++++++++++++++++++++++++++++  </xsl:text>
        </xsl:comment>
        <xsl:comment>
          <xsl:text>  :: delta </xsl:text>
          <xsl:value-of select="@name" />
          <xsl:text>  ::  </xsl:text>
        </xsl:comment>
        <xsl:comment>
          <xsl:text>  ++++++++++++++++++++++++++++++  </xsl:text>
        </xsl:comment>
        <xs:element>
          <xsl:attribute name="name">
            <xsl:value-of select="@name" />
          </xsl:attribute>
          <xs:annotation>
            <xs:appinfo source="type">
              <xsl:value-of select="@class" />
            </xs:appinfo>
          </xs:annotation>
          <xs:complexType>
            <xs:sequence>
              <xsl:for-each select = "attribute">
                <xsl:variable name="minProtocolId">
                  <xsl:value-of select="@minVersion" />
                </xsl:variable>
                <xsl:choose>
                  <xsl:when test="$minProtocolId and $minProtocolId &gt; $protocolId"></xsl:when>
                  <xsl:otherwise>
                    <xsl:variable name="propertyType">
                      <xsl:value-of select="@style" />
                    </xsl:variable>
                    <xsl:choose>
                      <xsl:when test="$propertyType = 'objlist'">
                        <xsl:call-template name='objlist'></xsl:call-template>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'pobject' or $propertyType = 'object'">
                        <xs:element>
                          <xsl:attribute name = "ref">
                            <xsl:value-of select="@ref" />
                          </xsl:attribute>
                          <xsl:attribute name = "minOccurs">0</xsl:attribute>
                          <xsl:attribute name = "maxOccurs">1</xsl:attribute>
                          <xs:annotation>
                            <xs:appinfo source="CfgObjectProperty">
                              <xsl:value-of select="@libid" />
                            </xs:appinfo>
                          </xs:annotation>
                        </xs:element>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'dbidlist'">
                        <xsl:call-template name="dbidlist"></xsl:call-template>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'intlist'">
                        <xsl:call-template name="intlist"></xsl:call-template>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'kvlist'">
                        <xsl:call-template name="kvlist"></xsl:call-template>
                      </xsl:when>
                      <xsl:when test="$propertyType = 'strlist'">
                        <xsl:call-template name="strlist"></xsl:call-template>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:call-template name="primitive"></xsl:call-template>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:for-each>
            </xs:sequence>
          </xs:complexType>
        </xs:element>
      </xsl:for-each>

      <!-- CfgIDs -->
      <xsl:for-each select = "type_info[@alias = 'CfgID']" >
        <xsl:comment>
          <xsl:text>  ++++++++++++++++++++++++++++++  </xsl:text>
        </xsl:comment>
        <xsl:comment>
          <xsl:text>  :: alias: </xsl:text>
          <xsl:value-of select="@name" />
          <xsl:text>  ::  </xsl:text>
        </xsl:comment>
        <xsl:comment>
          <xsl:text>  ++++++++++++++++++++++++++++++  </xsl:text>
        </xsl:comment>
        <xs:element>
          <xsl:attribute name = "name">
            <xsl:value-of select="@name" />
          </xsl:attribute>
          <xs:annotation>
            <xs:appinfo source="type">structure</xs:appinfo>
          </xs:annotation>
          <xs:complexType>
            <xs:sequence>
              <xsl:for-each select = "attribute">
                <xsl:variable name="attrName">
                  <xsl:value-of select="@name" />
                </xsl:variable>
                <xs:element>
                  <xsl:attribute name = "name">
                    <xsl:value-of select="$attrName" />
                  </xsl:attribute>
                  <xsl:attribute name = "minOccurs">0</xsl:attribute>
                  <xsl:attribute name = "maxOccurs">1</xsl:attribute>
                  <xsl:choose>
                    <xsl:when test="$attrName = 'CSID'">
                      <xs:annotation>
                        <xs:appinfo source="key">true</xs:appinfo>
                        <xs:appinfo source="CfgObjectProperty">CFGCSID</xs:appinfo>
                      </xs:annotation>
                    </xsl:when>
                    <xsl:when test="$attrName = 'DBID'">
                      <xs:annotation>
                        <xs:appinfo source="key">true</xs:appinfo>
                        <xs:appinfo source="CfgObjectProperty">CFGDBID</xs:appinfo>
                      </xs:annotation>
                    </xsl:when>
                    <xsl:when test="$attrName = 'type'">
                      <xs:annotation>
                        <xs:appinfo source="key">true</xs:appinfo>
                        <xs:appinfo source="CfgObjectProperty">CFGObjectType</xs:appinfo>
                        <xs:appinfo source="CfgEnumType">CfgObjectType</xs:appinfo>
                      </xs:annotation>
                    </xsl:when>
                  </xsl:choose>
                  <xs:complexType>
                    <xs:attribute>
                      <xsl:attribute name="name">value</xsl:attribute>
                      <xsl:attribute name="use">optional</xsl:attribute>
                      <xsl:attribute name="type">
                        <xsl:call-template name="ConvertTypes">
                          <xsl:with-param name="inputType" select="@style"/>
                        </xsl:call-template>
                      </xsl:attribute>
                    </xs:attribute>
                  </xs:complexType>
                </xs:element>
              </xsl:for-each>
            </xs:sequence>
          </xs:complexType>
        </xs:element>
      </xsl:for-each>

      <!-- CfgRemovalEvent -->
      <xsl:for-each select = "type_info[@name = 'CfgRemovalEvent']" >
        <xsl:comment>
          <xsl:text>  ++++++++++++++++++++++++++++++  </xsl:text>
        </xsl:comment>
        <xsl:comment>
          <xsl:text>  :: alias: </xsl:text>
          <xsl:value-of select="@name" />
          <xsl:text>  ::  </xsl:text>
        </xsl:comment>
        <xsl:comment>
          <xsl:text>  ++++++++++++++++++++++++++++++  </xsl:text>
        </xsl:comment>
        <xs:element>
          <xsl:attribute name = "name">
            <xsl:value-of select="@name" />
          </xsl:attribute>
          <xs:annotation>
            <xs:appinfo source="type">structure</xs:appinfo>
          </xs:annotation>
          <xs:complexType>
            <xs:sequence>
              <xsl:for-each select = "attribute">
                <xsl:variable name="attrName">
                  <xsl:value-of select="@name" />
                </xsl:variable>
                <xs:element>
                  <xsl:attribute name = "name">
                    <xsl:value-of select="$attrName" />
                  </xsl:attribute>
                  <xsl:attribute name = "minOccurs">0</xsl:attribute>
                  <xsl:attribute name = "maxOccurs">1</xsl:attribute>
                  <xsl:choose>
                    <xsl:when test="$attrName = 'logEventID'">
                      <xs:annotation>
                        <xs:appinfo source="CfgObjectProperty">CFGLogEventID</xs:appinfo>
                      </xs:annotation>
                    </xsl:when>
                    <xsl:when test="$attrName = 'selectionMode'">
                      <xs:annotation>
                        <xs:appinfo source="CfgObjectProperty">CFGSelectionMode</xs:appinfo>
                        <xs:appinfo source="CfgEnumType">CfgSelectionMode</xs:appinfo>
                      </xs:annotation>
                    </xsl:when>
                    <xsl:when test="$attrName = 'appType'">
                      <xs:annotation>
                        <xs:appinfo source="CfgObjectProperty">CFGAppType</xs:appinfo>
                        <xs:appinfo source="CfgEnumType">CfgAppType</xs:appinfo>
                      </xs:annotation>
                    </xsl:when>
                    <xsl:when test="$attrName = 'appDBID'">
                      <xs:annotation>
                        <xs:appinfo source="CfgObjectProperty">CFGAppDBID</xs:appinfo>
                        <xs:appinfo source="CfgObjectType">CFGApplication</xs:appinfo>
                      </xs:annotation>
                    </xsl:when>
                  </xsl:choose>
                  <xs:complexType>
                    <xs:attribute>
                      <xsl:attribute name="name">value</xsl:attribute>
                      <xsl:attribute name="use">optional</xsl:attribute>
                      <xsl:attribute name="type">
                        <xsl:call-template name="ConvertTypes">
                          <xsl:with-param name="inputType" select="@style"/>
                        </xsl:call-template>
                      </xsl:attribute>
                    </xs:attribute>
                  </xs:complexType>
                </xs:element>
              </xsl:for-each>
            </xs:sequence>
          </xs:complexType>
        </xs:element>
      </xsl:for-each>

      <!-- schema references -->
      <xsl:for-each select = "type_info[@class = 'schema']" >
        <xsl:comment>
          <xsl:text>  ++++++++++++++++++++++++++++++  </xsl:text>
        </xsl:comment>
        <xsl:comment>
          <xsl:text>  :: schema </xsl:text>
          <xsl:value-of select="@name" />
          <xsl:text>  ::  </xsl:text>
        </xsl:comment>
        <xsl:comment>
          <xsl:text>  ++++++++++++++++++++++++++++++  </xsl:text>
        </xsl:comment>
        <xs:element>
          <xsl:attribute name="name">
            <xsl:value-of select="@name" />
          </xsl:attribute>
          <xs:annotation>
            <xs:appinfo source="type">
              <xsl:value-of select="@class" />
            </xs:appinfo>
          </xs:annotation>
          <xs:complexType>
            <xs:sequence>
              <xsl:for-each select = "attribute">
                <xsl:variable name="propertyType">
                  <xsl:value-of select="@style" />
                </xsl:variable>
                <xsl:choose>
                  <xsl:when test="$propertyType = 'objhash' or $propertyType = 'pobjhash' or $propertyType = 'objlist'">
                    <xsl:call-template name='objlist'></xsl:call-template>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="primitive"></xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:for-each>
            </xs:sequence>
          </xs:complexType>
        </xs:element>
      </xsl:for-each>

      <!-- list_pair: reference -->
      <xsl:comment>
        <xsl:text>  ..........................  </xsl:text>
      </xsl:comment>
      <xsl:comment>
        <xsl:text>  ++  list_pair reference ++  </xsl:text>
      </xsl:comment>
      <xsl:comment>
        <xsl:text>  ..........................  </xsl:text>
      </xsl:comment>
      <xs:element name="list_pair">
        <xs:complexType>
          <xs:choice maxOccurs="unbounded">
            <xs:element name="str_pair" minOccurs="0" maxOccurs="unbounded">
              <xs:complexType>
                <xs:attribute name="key" type="xs:string" />
                <xs:attribute name="value" type="xs:string" />
              </xs:complexType>
            </xs:element>
            <xs:element name="int_pair" minOccurs="0" maxOccurs="unbounded">
              <xs:complexType>
                <xs:attribute name="key" type="xs:string" />
                <xs:attribute name="value" type="xs:int" />
              </xs:complexType>
            </xs:element>
            <xs:element name="bin_pair" minOccurs="0" maxOccurs="unbounded">
              <xs:complexType>
                <xs:attribute name="key" type="xs:string" />
                <xs:attribute name="value" type="xs:hexBinary" />
              </xs:complexType>
            </xs:element>
            <xs:element ref="list_pair" minOccurs="0" maxOccurs="unbounded" />
          </xs:choice>
          <xs:attribute name="key" type="xs:string" />
        </xs:complexType>
      </xs:element>


      <!-- strlist: references -->
      <xsl:comment>
        <xsl:text>  ..........................  </xsl:text>
      </xsl:comment>
      <xsl:comment>
        <xsl:text>  ++  strlist references ++  </xsl:text>
      </xsl:comment>
      <xsl:comment>
        <xsl:text>  ..........................  </xsl:text>
      </xsl:comment>
      <xs:element name="connID">
        <xs:complexType>
          <xs:attribute>
            <xsl:attribute name="name">value</xsl:attribute>
            <xsl:attribute name="use">optional</xsl:attribute>
            <xsl:attribute name="type">xs:string</xsl:attribute>
          </xs:attribute>
        </xs:complexType>
      </xs:element>

      <xs:element name="name">
        <xs:complexType>
          <xs:attribute>
            <xsl:attribute name="name">value</xsl:attribute>
            <xsl:attribute name="use">optional</xsl:attribute>
            <xsl:attribute name="type">xs:string</xsl:attribute>
          </xs:attribute>
        </xs:complexType>
      </xs:element>
    
  </xsl:template>

  <!-- ++++++++++++++++++++++++++ Templates +++++++++++++++++++++++++++++++++++++++++++ -->

  <!--  objlist  -->
  <xsl:template name="objlist">
    <xs:element>
      <xsl:attribute name = "name">
        <xsl:value-of select="@name" />
      </xsl:attribute>
      <xsl:attribute name = "minOccurs">0</xsl:attribute>
      <xsl:attribute name = "maxOccurs">1</xsl:attribute>
      <xs:annotation>
        <xs:appinfo source="CfgObjectProperty">
          <xsl:value-of select="@libid" />
        </xs:appinfo>
      </xs:annotation>
      <xs:complexType>
        <xs:sequence>
          <xs:element>
            <xsl:attribute name = "ref">
              <xsl:value-of select="@ref" />
            </xsl:attribute>
            <xsl:attribute name = "minOccurs">0</xsl:attribute>
            <xsl:attribute name = "maxOccurs">unbounded</xsl:attribute>
          </xs:element>
        </xs:sequence>
      </xs:complexType>
    </xs:element>
  </xsl:template>

  <!--  kvlist  -->
  <xsl:template name="kvlist">
    <xs:element>
      <xsl:attribute name = "name">
        <xsl:value-of select="@name" />
      </xsl:attribute>
      <xsl:attribute name = "minOccurs">0</xsl:attribute>
      <xsl:attribute name = "maxOccurs">1</xsl:attribute>
      <xs:annotation>
        <xs:appinfo source="CfgObjectProperty">
          <xsl:value-of select="@libid" />
        </xs:appinfo>
      </xs:annotation>
      <xs:complexType>
        <xs:sequence maxOccurs="unbounded">
          <xs:element ref="list_pair" />
        </xs:sequence>
      </xs:complexType>
    </xs:element>
  </xsl:template>


  <!--  dbidlist  -->
  <xsl:template name="dbidlist">
    <xs:element>
      <xsl:attribute name = "name">
        <xsl:value-of select="@name" />
      </xsl:attribute>
      <xsl:attribute name = "minOccurs">0</xsl:attribute>
      <xsl:attribute name = "maxOccurs">1</xsl:attribute>
      <xs:annotation>
        <xs:appinfo source="CfgObjectProperty">
          <xsl:value-of select="@libid" />
        </xs:appinfo>
        <xsl:if test="@linkType">
          <xs:appinfo source="CfgObjectType">
            <xsl:value-of select="@linkType" />
          </xs:appinfo>
        </xsl:if>
      </xs:annotation>
      <xs:complexType>
        <xs:sequence>
          <xs:element name="DBID" minOccurs="0" maxOccurs="unbounded">
            <xs:annotation>
              <xs:appinfo source="CfgObjectProperty">CFGDBID</xs:appinfo>
            </xs:annotation>
            <xs:complexType>
              <xs:attribute name="value" type="xs:unsignedLong" />
            </xs:complexType>
          </xs:element>
        </xs:sequence>
      </xs:complexType>
    </xs:element>
  </xsl:template>

  <!--  intlist  -->
  <xsl:template name="intlist">
    <xs:element>
      <xsl:attribute name = "name">
        <xsl:value-of select="@name" />
      </xsl:attribute>
      <xsl:attribute name = "minOccurs">0</xsl:attribute>
      <xsl:attribute name = "maxOccurs">1</xsl:attribute>
      <xs:annotation>
        <xs:appinfo source="CfgObjectProperty">
          <xsl:value-of select="@libid" />
        </xs:appinfo>
      </xs:annotation>
      <xs:complexType>
        <xs:sequence>
          <xs:element name="IntID" minOccurs="0" maxOccurs="unbounded">
            <xs:complexType>
              <xs:attribute name="value" type="xs:int" />
            </xs:complexType>
          </xs:element>
        </xs:sequence>
      </xs:complexType>
    </xs:element>
  </xsl:template>

  <!--  strlist  -->
  <xsl:template name="strlist">
    <xs:element>
      <xsl:attribute name = "name">
        <xsl:value-of select="@name" />
      </xsl:attribute>
      <xsl:attribute name = "minOccurs">0</xsl:attribute>
      <xsl:attribute name = "maxOccurs">1</xsl:attribute>
      <xs:annotation>
        <xs:appinfo source="CfgObjectProperty">
          <xsl:value-of select="@libid" />
        </xs:appinfo>
      </xs:annotation>
      <xs:complexType>
        <xs:sequence>
          <xs:element>
            <xsl:attribute name = "ref">
              <xsl:value-of select="@ref" />
            </xsl:attribute>
          </xs:element>
        </xs:sequence>
      </xs:complexType>
    </xs:element>
  </xsl:template>

  <!--  primitive  -->
  <xsl:template name="primitive">
    <xs:element>
      <xsl:attribute name = "name">
        <xsl:value-of select="@name" />
      </xsl:attribute>
      <xsl:attribute name = "minOccurs">0</xsl:attribute>
      <xsl:attribute name = "maxOccurs">1</xsl:attribute>
      <xs:annotation>
        <xsl:variable name="key">
          <xsl:value-of select="@key" />
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="$key != ''">
            <xs:appinfo source="key">true</xs:appinfo>
          </xsl:when>
          <xsl:otherwise />
        </xsl:choose>
        <xs:appinfo source="CfgObjectProperty">
          <xsl:value-of select="@libid" />
        </xs:appinfo>
        <xsl:if test="@linkType">
          <xs:appinfo source="CfgObjectType">
            <xsl:value-of select="@linkType" />
          </xs:appinfo>
        </xsl:if>
        <xsl:variable name="enum">
          <xsl:value-of select="@ref" />
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="$enum != ''">
            <xs:appinfo source="CfgEnumType">
              <xsl:value-of select="@ref" />
            </xs:appinfo>
            <xsl:if test="@default">
              <xs:appinfo source="default">
                <xsl:value-of select="@default" />
              </xs:appinfo>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:if test="@default">
              <xs:appinfo source="default">
                <xsl:value-of select="@default" />
              </xs:appinfo>
            </xsl:if>
          </xsl:otherwise>
        </xsl:choose>
      </xs:annotation>
      <xs:complexType>
        <xs:attribute>
          <xsl:attribute name="name">value</xsl:attribute>
          <xsl:attribute name="use">optional</xsl:attribute>
          <xsl:attribute name="type">
            <xsl:call-template name="ConvertTypes">
              <xsl:with-param name="inputType" select="@style"/>
            </xsl:call-template>
          </xsl:attribute>
        </xs:attribute>
      </xs:complexType>
    </xs:element>
  </xsl:template>

  <!--  type mapping  -->
  <xsl:template name="ConvertTypes">
    <xsl:param name="inputType"/>
    <xsl:choose>
      <xsl:when test="$inputType='int'">xs:int</xsl:when>
      <xsl:when test="$inputType='string'">xs:string</xsl:when>
      <xsl:when test="$inputType='gstring'">xs:string</xsl:when>
      <xsl:when test="$inputType='ulong'">xs:unsignedLong</xsl:when>
      <xsl:when test="$inputType='long'">xs:long</xsl:when>
      <xsl:when test="$inputType='time'">xs:long</xsl:when>
      <xsl:when test="$inputType='pobject'">xs:string</xsl:when>
      <!--  temp -->
      <xsl:otherwise>
        <xsl:value-of select="$inputType"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


</xsl:stylesheet>



