package sample;


import com.genesyslab.platform.applicationblocks.com.*;
import com.genesyslab.platform.applicationblocks.com.objects.CfgApplication;
import com.genesyslab.platform.applicationblocks.com.queries.CfgApplicationQuery;
import com.genesyslab.platform.commons.protocol.*;
import com.genesyslab.platform.configuration.protocol.ConfServerProtocol;
import com.genesyslab.platform.configuration.protocol.types.CfgAppType;

/** 
* This class is used to access configuration server data. 
*/
public class ConfigurationAccessor {

	  private String cfgHost;
	  private int cfgPort;
	  private String userName;
	  private String password;
	  private String clientName;
	  private Integer clientType;
      private IConfService confService;

   /**
    * Creates a new instance of the Configuration Server protocol
    * and sets all of the attributes required for its use.
    */
 	private ConfServerProtocol GetProtocol(){
  		Endpoint desc = new Endpoint(cfgHost, cfgPort);
	
  		ConfServerProtocol confProtocol = new ConfServerProtocol(desc);
		     
  		confProtocol.setClientApplicationType(clientType); 
  		confProtocol.setClientName(clientName);
  		confProtocol.setUserName(userName);
  		confProtocol.setUserPassword(password);
	
  		return confProtocol;
     }

     /**
     * Returns the current state of the configuration server channel.  Should be
     * used to determine whether a connection is opened.
     */
     public ChannelState getChannelState()   {

             ConfServerProtocol protocol =
                 (ConfServerProtocol)confService.getProtocol();
                
              return protocol == null ?
                 ChannelState.Closed :
                 protocol.getState();            
     }
   
     /**
     * Used to open the connection to the Configuration Server specified
     * in the App.config file for this application
     */
      public void Connect() throws Exception{
            ConfServerProtocol protocol = GetProtocol();

         confService = ConfServiceFactory.createConfService(protocol);
         try  {
             protocol.open();
         }
         catch (Exception ex)  {
             throw new Exception("Cannot connect to the configuration server (" + ex.getMessage() + ").");
         }

         
     }

     /**
      * Should be called before working with Configuration Server.  This method
      * reads the necessary configuration information from the App.config and 
      * sets the appropriate properties.
     */
     public void Initialize(String host, int port, String UserName, String UserPwd, String clientName) throws Exception {	  	
	  		
    	 cfgHost =host;
    	 cfgPort =port;         
         userName = UserName;
         password = UserPwd;
         this.clientName = clientName;
         clientType = CfgAppType.CFGGenericServer.ordinal();
     }
        
     /**
     * Closes connection with configuration server
     */
     public void Disconnect() throws Exception{
         if (confService != null) {
        	 
             Protocol protocol = confService.getProtocol();
			 if (protocol != null && protocol.getState()!=ChannelState.Closed)
                 protocol.close();
             
			 ConfServiceFactory.releaseConfService(confService);

         }
      }

     /**
     * Retrieves an application by name.
     * @param appName application name as seen in configuration server
     * @return CfgApplication object describing the retrieved application, or null if not found
     */
     public CfgApplication RetrieveApplication(String appName) throws Exception    {
         CfgApplicationQuery query = new CfgApplicationQuery();

         query.setName(appName);
                       
         return confService.retrieveObject(CfgApplication.class, query);

     }
}

