/*
 * Decompiled with CFR 0.152.
 */
package com.bssc.java.help;

import com.sun.java.help.impl.ViewAwareComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.help.JHelpContentViewer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class RelatedTopics
extends JButton
implements ActionListener,
ViewAwareComponent {
    private View myView;
    private Font font;
    private SimpleAttributeSet textAttribs;
    private static final String buttonPropertyPrefix = "Button.";
    private RelatedTopicsView popupView;
    private static Component container = null;
    private int viewerHeight = 0;
    private int viewerWidth = 0;
    private int viewerX = 0;
    private int viewerY = 0;
    private String viewerName = "";
    private int viewerActivator = 0;
    private Icon viewerIcon;
    private Topics topics;
    private SelectionListener selectionListener = new SelectionListener();
    private static final boolean debug = false;

    public RelatedTopics() {
        this.setText("Related Topics");
        this.setMargin(new Insets(0, 0, 0, 0));
        this.createLinkButton();
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MyBasicComboPopup myBasicComboPopup = null;
        JComboBox<String> jComboBox = null;
        if (this.popupView == null) {
            jComboBox = new JComboBox<String>();
            int n = 0;
            while (n < this.topics.getTopicCount()) {
                jComboBox.addItem(this.topics.getTopicString(n));
                ++n;
            }
            jComboBox.setSelectedIndex(-1);
            jComboBox.addActionListener(this.selectionListener);
            jComboBox.setRenderer(new PopupCellRenderer(jComboBox));
            myBasicComboPopup = new MyBasicComboPopup(jComboBox);
            this.popupView = new RelatedTopicsView(myBasicComboPopup, jComboBox);
            this.popupView.popup.setFont(this.font);
            this.popupView.popup.setBorder(this.popupView.border);
            this.popupView.combobox.setFont(this.font);
        }
        this.togglePopup();
    }

    private void createLinkButton() {
        LookAndFeel.installBorder(this, "Button.border");
        this.setBorderPainted(true);
        this.setFocusPainted(true);
        this.setAlignmentY(0.5f);
        this.setContentAreaFilled(true);
        this.setBackground(UIManager.getColor("Button.background"));
        this.textAttribs = new SimpleAttributeSet();
        if (this.textAttribs != null && this.textAttribs.isDefined(StyleConstants.Foreground)) {
            this.setForeground((Color)this.textAttribs.getAttribute(StyleConstants.Foreground));
        } else {
            this.setForeground(UIManager.getColor("Button.foreground"));
        }
        this.invalidate();
    }

    private static void debug(String string) {
        System.err.println("Related Topics: " + string);
    }

    private Dialog getDialog() {
        Container container = RelatedTopics.container.getParent();
        while (container != null && !(container instanceof Dialog) && !(container instanceof Window)) {
            container = container.getParent();
        }
        if (container instanceof Dialog) {
            return (Dialog)container;
        }
        return null;
    }

    private Point getPopupPos(Dimension dimension, int n, int n2) {
        Point point = this.getLocationOnScreen();
        Toolkit toolkit = this.getToolkit();
        if (point.y + n2 + dimension.height > toolkit.getScreenSize().height) {
            n2 = n2 + point.y - dimension.height > 0 ? (n2 -= dimension.height) : 1 - point.y;
        }
        if (point.x + n + dimension.width > toolkit.getScreenSize().width) {
            n = n + point.x - dimension.width > 0 ? (n -= dimension.width) : 1 - point.x;
        }
        return new Point(n, n2);
    }

    public String getTopicList() {
        return this.topics.topicList;
    }

    public void hidePopup() {
        this.popupView.popup.hide();
        container.repaint();
    }

    private boolean inModalDialog() {
        return this.getDialog() != null;
    }

    public void setTopicList(String string) {
        this.topics = new Topics(string);
    }

    public void setViewData(View view) {
        this.myView = view;
        container = this.myView.getContainer();
        this.font = this.getFont();
    }

    private void showPopup() {
        if (this.popupView.combobox.getSelectedIndex() != -1) {
            this.popupView.combobox.setSelectedIndex(-1);
        }
        Dimension dimension = this.popupView.popup.getPreferredSize();
        dimension.height = this.popupView.popup.getRequiredHeight(20);
        Insets insets = this.popupView.border.getBorderInsets(this.popupView.popup);
        dimension.width += insets.left;
        this.popupView.popup.setPreferredSize(dimension);
        Toolkit toolkit = this.popupView.popup.getToolkit();
        Point point = this.getPopupPos(dimension, 5, 5);
        this.popupView.popup.show(this, point.x, point.y);
    }

    protected void togglePopup() {
        if (this.popupView.popup.isVisible()) {
            this.hidePopup();
        } else {
            this.showPopup();
        }
    }

    class MyBasicComboPopup
    extends BasicComboPopup {
        public MyBasicComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        public int getRequiredHeight(int n) {
            Insets insets = this.getBorder().getBorderInsets(this);
            return this.getPopupHeightForRowCount(n) + insets.bottom + insets.top;
        }
    }

    class RelatedTopicsView {
        public JComboBox combobox;
        public MyBasicComboPopup popup;
        public BevelBorder border;

        public RelatedTopicsView(MyBasicComboPopup myBasicComboPopup, JComboBox jComboBox) {
            this.popup = myBasicComboPopup;
            this.combobox = jComboBox;
            this.border = new BevelBorder(0);
        }
    }

    class SelectionListener
    implements ActionListener {
        SelectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (((RelatedTopics)RelatedTopics.this).popupView.combobox.getSelectedIndex() == -1) {
                return;
            }
            Component component = container;
            while (component != null) {
                if (component instanceof JHelpContentViewer) break;
                component = component.getParent();
            }
            String string = (String)((RelatedTopics)RelatedTopics.this).popupView.combobox.getSelectedItem();
            int n = 0;
            n = 0;
            while (n < RelatedTopics.this.topics.getTopicCount()) {
                if (string.compareTo(RelatedTopics.this.topics.getTopicString(n)) == 0) {
                    if (component != null) {
                        if (RelatedTopics.this.topics.isTopicID(n)) {
                            ((JHelpContentViewer)component).setCurrentID(RelatedTopics.this.topics.getTopicID(n));
                        } else {
                            URL uRL = null;
                            try {
                                uRL = new URL(RelatedTopics.this.topics.getTopicURL(n));
                            }
                            catch (MalformedURLException malformedURLException) {
                                return;
                            }
                            ((JHelpContentViewer)component).setCurrentURL(uRL);
                        }
                        container.repaint();
                    }
                    n = RelatedTopics.this.topics.getTopicCount();
                }
                ++n;
            }
        }
    }

    class PopupCellRenderer
    extends JLabel
    implements ListCellRenderer {
        JComboBox combobox;

        public PopupCellRenderer(JComboBox jComboBox) {
            this.combobox = jComboBox;
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                if (n == -1) {
                    this.setOpaque(false);
                } else {
                    this.setOpaque(true);
                }
            } else {
                this.setOpaque(true);
            }
            if (object == null) {
                this.setText("");
            } else {
                String string = (String)object;
                if (!this.getFont().getName().equals(string)) {
                    this.setFont(new Font(RelatedTopics.this.font.getFamily(), 0, 14));
                    this.setText(string);
                }
                if (bl) {
                    this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                } else {
                    this.setBackground(UIManager.getColor("ComboBox.background"));
                    this.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
            }
            return this;
        }
    }

    class Topics {
        private String topicList;
        private int[] topicStringOffsets;
        private int[] topicURLOffsets;
        private char delimiter;
        private int topicCount;
        private int reqWidth;
        private int reqHeight;

        public Topics(String string) {
            int n = 0;
            int n2 = 0;
            this.reqHeight = 0;
            this.reqWidth = 0;
            this.delimiter = string.charAt(0);
            this.topicCount = 0;
            n = string.indexOf(this.delimiter, n);
            while (n != -1) {
                ++this.topicCount;
                if ((n = string.indexOf(this.delimiter, n + 1)) == -1) continue;
                n = string.indexOf(this.delimiter, n + 1);
            }
            this.topicStringOffsets = new int[this.topicCount];
            this.topicURLOffsets = new int[this.topicCount];
            n = 0;
            n2 = 0;
            while (n2 < this.topicCount) {
                n = this.topicStringOffsets[n2] = string.indexOf(this.delimiter, n) + 1;
                ++n;
                n = this.topicURLOffsets[n2] = string.indexOf(this.delimiter, n) + 1;
                ++n;
                ++n2;
            }
            this.topicList = string;
        }

        public int getTopicCount() {
            return this.topicCount;
        }

        public String getTopicID(int n) {
            if (n < this.topicCount - 1) {
                return this.topicList.substring(this.topicURLOffsets[n] + 1, this.topicStringOffsets[n + 1] - 1);
            }
            return this.topicList.substring(this.topicURLOffsets[n] + 1, this.topicList.length());
        }

        public String getTopicString(int n) {
            return " " + this.topicList.substring(this.topicStringOffsets[n], this.topicURLOffsets[n] - 1) + " ";
        }

        public String getTopicURL(int n) {
            if (n < this.topicCount - 1) {
                return this.topicList.substring(this.topicURLOffsets[n], this.topicStringOffsets[n + 1] - 1);
            }
            return this.topicList.substring(this.topicURLOffsets[n], this.topicList.length());
        }

        public boolean isTopicID(int n) {
            if (n < this.topicCount) {
                return this.getTopicURL(n).charAt(0) == '#';
            }
            return false;
        }
    }
}

